/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillaengine.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>


// Include files from the source.

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "gmozillaengine.h"
#include "gmozillamarshal.h"
#include "gmozillaweb.h"
#include "gmozillatransferitem.h"
#include "common.h"
#include "gmozillaconnectivity.h"
#include "gmozillahistorylist.h"
#include "gmozillasupport.h"
#include "gtkmicrob_context.h"
#include <sys/time.h>
#include <time.h>
#include <string.h>
#include <malloc.h>
#ifdef USE_OPENSSL
#include <openssl/x509.h>
#endif
#ifdef USE_HILDON2007
#include <hildon/hildon-helper.h>
#ifdef HILDON_2_2
#include <hildon/hildon-touch-selector.h>
#include <hildon/hildon-button.h>
#include "browser-translations.h"
#endif
#else
#ifdef USE_HILDON
#ifndef USE_OS2006
#include <hildon-widgets/hildon-finger.h>
#endif
#endif
#endif
#ifdef USE_CONIC
#endif
#ifndef MOZ_CAIRO_GFX
#endif
#ifndef MOZ_CAIRO_GFX
#endif
#ifdef USE_HILDON2007
#endif
#if 0
#endif
#ifdef USE_CONIC
#endif
#ifdef USE_CONIC
#else
#endif
#ifdef USE_CONIC
#endif
#ifdef USE_HILDON2007
#endif
#ifdef USE_HILDON
#endif
#ifdef USE_HILDON
#endif
#ifdef USE_HILDON
#endif
#ifdef USE_HILDON
#endif
#ifdef USE_HILDON
#endif
#ifdef USE_HILDON
#endif
#ifdef USE_HILDON2007
#else
#endif
#ifdef USE_HILDON2007
#else
#endif
#ifdef USE_HILDON
#endif
#ifdef USE_HILDON
#endif
#ifdef UNUSED
#endif
#ifdef MOZEAL_LOGGING
#endif
#ifndef USE_OS2006
#endif
#ifdef UNUSED
#endif
#ifdef HILDON_2_2
#endif


typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GdkCursorType type;
    gboolean expected_retvalue;
} ContentSetCursorStruct;
typedef struct {
    GtkMozEmbed* embed;
    void* event;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gint expected_retvalue;
} DomMouseDownCbStruct;
typedef struct {
    GtkMozEmbed* embed;
    void* event;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gint expected_retvalue;
} DomMouseLongPressCbStruct;
typedef struct {
    GtkIMContext* ctx;
    gchar* str;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean expected_retvalue;
} GMozEalImContextCommitStruct;
typedef struct {
    GtkIMContext* aContext;
    gint arg1;
    gint arg2;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean expected_retvalue;
} GMozEalImContextDeleteSurroundingStruct;
typedef struct {
    GtkIMContext* context;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean expected_retvalue;
} GMozEalImContextHasSelectionStruct;
typedef struct {
    GtkIMContext* aContext;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean expected_retvalue;
} GMozEalImContextRetrieveSurroundingStruct;
typedef struct {
    GtkIMContext* aContext;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
} GMozEalPreeditChangedCbStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gpointer* test_notification_widget_pp;
    gpointer notification_widget;
    gpointer notification;
    gpointer notification_button;
    gchar* label;
} GMozillaAddNotificationButtonStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gchar* notification_label;
    gpointer notification;
    gboolean test_is_retvalue_expected;
    gpointer retvalue;
} GMozillaAppendNotificationStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gchar* dialog_title;
    gchar* alert_msg;
    gboolean is_blocking;
    char* check_msg;
    gboolean* check_val;
    gint expected_retvalue;
} GMozillaEngineAlertStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gchar* dialog_title;
    gchar* dialog_msg;
    char* check_msg;
    gboolean* check_val;
    gboolean expected_retvalue;
} GMozillaEngineConfirmStruct;
typedef struct {
    GtkMozEmbed* embed;
    GWebEngineEncoding expected_retvalue;
} GMozillaEngineGetEncodingStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gchar* expected_retvalue;
} GMozillaEngineGetPageVerifierNameStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gpointer context;
    GArray* expected_retvalue;
} GMozillaEngineGetServerCertificateStruct;
typedef struct {
    GType expected_retvalue;
} GMozillaEngineGetTypeStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    guint expected_retvalue;
} GMozillaEngineGetZoomLevelStruct;
typedef struct {
    gboolean test_is_retvalue_expected;
    GObject* retvalue;
} GMozillaEngineNewStruct;
typedef struct {
    GtkMozEmbed* test_context_variable;
    gpointer context;
    gboolean test_is_retvalue_expected;
    GObject* retvalue;
} GMozillaEngineNewWithContextStruct;
typedef struct {
    GtkMozEmbed* test_context_variable;
    gpointer context;
    gboolean leave_tracks;
    gboolean without_history;
    guint32 flags;
    gboolean test_is_retvalue_expected;
    GObject* retvalue;
} GMozillaEngineNewWithContextAndTracksStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gpointer notification_widget;
} GMozillaRemoveNotificationStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gpointer notification_widget;
    gpointer notification;
} GMozillaShowNotificationStruct;
typedef struct {
    guint moz_embed_ctx;
    guint expected_retvalue;
} CtxMozembedToEalStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GSList* list;
    gpointer ctx_node;
    gboolean multiple;
    gint* selected;
    gint sel_count;
} GMozillaCreateSelectNotificationStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    glong cur_time_sec;
    glong cur_time_usec;
    glong timeout_usec;
    gboolean expected_retvalue;
} GMozillaEnginePermitPageUnloadStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    int type;
    int x;
    int y;
    int mod;
    int button;
    int clickcount;
    int time;
} GMozillaEngineSendMouseEventStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    int id;
    int top;
    int left;
    int width;
    int height;
    int zoom;
} GMozillaEngineUpdateAreaStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    int vx;
    int vy;
    int vw;
    int vh;
    int tx;
    int ty;
    int tw;
    int th;
    int wx;
    int wy;
    int ww;
    int wh;
} GMozillaEngineVisibleAreaStruct;
typedef struct {
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gpointer notification_widget;
} GMozillaSendNotificationStruct;

// Structs for Interface functions
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
} IfaceGMozillaEngineDestroyStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
} IfaceGMozillaEngineResetStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gchar* url;
} IfaceGMozillaEngineLoadUrlStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gchar* url;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineLoadFollowLinkStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gchar* url;
    gchar* cssfile;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineLoadUrlWithCssStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean enable;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineLoadUrlWithJsStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
} IfaceGMozillaEngineLoadHomePageStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
} IfaceGMozillaEngineStopLoadStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
} IfaceGMozillaEngineReloadStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    guint nsteps;
} IfaceGMozillaEngineGoBackStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    guint nsteps;
} IfaceGMozillaEngineGoForwardStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean expected_retvalue;
} IfaceGMozillaEngineCanGoBackStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean expected_retvalue;
} IfaceGMozillaEngineCanGoForwardStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gint level;
} IfaceGMozillaEngineSetZoomLevelStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    guint x;
    guint y;
    gint level;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineSetZoomLevelAroundPointStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean test_equal_variable;
    gboolean* equal;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineCompareFramesZoomLevelStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    guint relative_zoom;
    guint* legal_zoom_value;
} IfaceGMozillaEngineZoomByStepsStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    guint relative_zoom;
    guint* legal_zoom_value;
} IfaceGMozillaEngineNewZoomByStepsStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    guint level;
} IfaceGMozillaEngineSetFrameZoomLevelStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    guint expected_retvalue;
} IfaceGMozillaEngineGetFrameZoomLevelStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    const gchar* url;
    gchar* test_file_type_variable;
    gchar** file_type;
    guint test_file_size_variable;
    guint* file_size;
    guint test_width_variable;
    guint* width;
    guint test_height_variable;
    guint* height;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineGetImagePropertiesStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gchar* test_file_type_variable;
    gchar** file_type;
    guint test_file_size_variable;
    guint *file_size;
    GWebEngineEncoding test_file_encoding_variable;
    GWebEngineEncoding* file_encoding;
    guint test_security_variable;
    guint* security;
    gboolean test_automatic_encoding_variable;
    gboolean* automatic_encoding;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineGetFramePropertiesStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    const gchar* url;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineLoadImageStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GObject* test_history_variable;
    GObject** history;
    gint expected_retvalue;
} IfaceGMozillaEngineGetBackWindowHistoryListStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GObject* test_history_variable;
    GObject **history;
    gint expected_retvalue;
} IfaceGMozillaEngineGetForwardWindowHistoryListStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GWebEngineLayoutMode mode;
} IfaceGMozillaEngineSetLayoutModeStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GWebEngineLayoutMode expected_retvalue;
} IfaceGMozillaEngineGetLayoutModeStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GWebEngineImagePolicy level;
} IfaceGMozillaEngineSetLoadImagesStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GWebEngineImagePolicy expected_retvalue;
} IfaceGMozillaEngineGetLoadImagesStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean enabled;
} IfaceGMozillaEngineSetFrameStackingStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gboolean expected_retvalue;
} IfaceGMozillaEngineGetFrameStackingStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GWebEngineSaveAction setting;
    const gchar *file_name_with_path;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineSaveWebPageStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    GWebEngineSaveAction setting;
    const gchar *file_name_with_path;
    GWebStatus expected_retvalue;
} IfaceGMozillaEngineSaveCurrentFrameStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gint frame_number;
    const gchar* expected_retvalue;
} IfaceGMozillaEngineGetFrameTitleStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gint type;
    gchar* expected_retvalue;
} IfaceGMozillaEngineGetElementDetailsStruct;
typedef struct {
    GWebEngineIface* test_iface;
    GMozillaEngine** test_self_pp;
    GMozillaEngine* self;
    gint expected_retvalue;
} IfaceGMozillaEngineGetFrameNumberStruct;








typedef struct {
    gboolean automatic;
    gboolean basics;
    /*
    ContentSetCursorStruct content_set_cursor;
    DomMouseDownCbStruct dom_mouse_down_cb;
    DomMouseLongPressCbStruct dom_mouse_long_press_cb;
    GMozEalImContextCommitStruct g_moz_eal_im_context_commit;
    GMozEalImContextDeleteSurroundingStruct g_moz_eal_im_context_delete_surrounding;
    GMozEalImContextHasSelectionStruct g_moz_eal_im_context_has_selection;
    GMozEalImContextRetrieveSurroundingStruct g_moz_eal_im_context_retrieve_surrounding;
    GMozEalPreeditChangedCbStruct g_moz_eal_preedit_changed_cb;
    GMozillaAddNotificationButtonStruct g_mozilla_add_notification_button;
    GMozillaAppendNotificationStruct g_mozilla_append_notification;
    GMozillaEngineAlertStruct g_mozilla_engine_alert;
    GMozillaEngineConfirmStruct g_mozilla_engine_confirm;
    GMozillaEngineGetEncodingStruct g_mozilla_engine_get_encoding;
    GMozillaEngineGetPageVerifierNameStruct g_mozilla_engine_get_page_verifier_name;
    GMozillaEngineGetServerCertificateStruct g_mozilla_engine_get_server_certificate;
    GMozillaEngineGetTypeStruct g_mozilla_engine_get_type;
    GMozillaEngineGetZoomLevelStruct g_mozilla_engine_get_zoom_level;
    GMozillaEngineNewStruct g_mozilla_engine_new;
    GMozillaEngineNewWithContextStruct g_mozilla_engine_new_with_context;
    GMozillaEngineNewWithContextAndTracksStruct g_mozilla_engine_new_with_context_and_tracks;
    GMozillaRemoveNotificationStruct g_mozilla_remove_notification;
    GMozillaShowNotificationStruct g_mozilla_show_notification;
    CtxMozembedToEalStruct ctx_mozembed_to_eal;
    GMozillaCreateSelectNotificationStruct g_mozilla_create_select_notification;
    GMozillaEnginePermitPageUnloadStruct g_mozilla_engine_permit_page_unload;
    GMozillaEngineSendMouseEventStruct g_mozilla_engine_send_mouse_event;
    GMozillaEngineUpdateAreaStruct g_mozilla_engine_update_area;
    GMozillaEngineVisibleAreaStruct g_mozilla_engine_visible_area;
    GMozillaSendNotificationStruct g_mozilla_send_notification;
     */

    TestTableData content_set_cursor;
    TestTableData dom_mouse_down_cb;
    TestTableData dom_mouse_long_press_cb;
    TestTableData g_moz_eal_im_context_commit;
    TestTableData g_moz_eal_im_context_delete_surrounding;
    TestTableData g_moz_eal_im_context_has_selection;
    TestTableData g_moz_eal_im_context_retrieve_surrounding;
    TestTableData g_moz_eal_preedit_changed_cb;
    TestTableData g_mozilla_add_notification_button;
    TestTableData g_mozilla_append_notification;
    TestTableData g_mozilla_engine_alert;
    TestTableData g_mozilla_engine_confirm;
    TestTableData g_mozilla_engine_get_encoding;
    TestTableData g_mozilla_engine_get_page_verifier_name;
    TestTableData g_mozilla_engine_get_server_certificate;
    TestTableData g_mozilla_engine_get_type;
    TestTableData g_mozilla_engine_get_zoom_level;
    TestTableData g_mozilla_engine_new;
    TestTableData g_mozilla_engine_new_with_context;
    TestTableData g_mozilla_engine_new_with_context_and_tracks;
    TestTableData g_mozilla_remove_notification;
    TestTableData g_mozilla_show_notification;
    TestTableData ctx_mozembed_to_eal;
    TestTableData g_mozilla_create_select_notification;
    TestTableData g_mozilla_engine_permit_page_unload;
    TestTableData g_mozilla_engine_send_mouse_event;
    TestTableData g_mozilla_engine_update_area;
    TestTableData g_mozilla_engine_visible_area;
    TestTableData g_mozilla_send_notification;
    
    TestTableData iface_g_mozilla_engine_destroy;
    TestTableData iface_g_mozilla_engine_reset;
    TestTableData iface_g_mozilla_engine_load_url;
    TestTableData iface_g_mozilla_engine_load_follow_link;
    TestTableData iface_g_mozilla_engine_load_url_with_css;
    TestTableData iface_g_mozilla_engine_load_url_with_js;
    TestTableData iface_g_mozilla_engine_load_home_page;
    TestTableData iface_g_mozilla_engine_stop_load;
    TestTableData iface_g_mozilla_engine_reload;
    TestTableData iface_g_mozilla_engine_go_back;
    TestTableData iface_g_mozilla_engine_go_forward;
    TestTableData iface_g_mozilla_engine_can_go_back;
    TestTableData iface_g_mozilla_engine_can_go_forward;
    TestTableData iface_g_mozilla_engine_set_zoom_level;
    TestTableData iface_g_mozilla_engine_set_zoom_level_around_point;
    TestTableData iface_g_mozilla_engine_compare_frames_zoom_level;
    TestTableData iface_g_mozilla_engine_zoom_by_steps;
    TestTableData iface_g_mozilla_engine_new_zoom_by_steps;
    TestTableData iface_g_mozilla_engine_set_frame_zoom_level;
    TestTableData iface_g_mozilla_engine_get_frame_zoom_level;
    TestTableData iface_g_mozilla_engine_get_image_properties;
    TestTableData iface_g_mozilla_engine_get_frame_properties;
    TestTableData iface_g_mozilla_engine_load_image;
    TestTableData iface_g_mozilla_engine_get_back_window_history_list;
    TestTableData iface_g_mozilla_engine_get_forward_window_history_list;
    TestTableData iface_g_mozilla_engine_set_layout_mode;
    TestTableData iface_g_mozilla_engine_get_layout_mode;
    TestTableData iface_g_mozilla_engine_set_load_images;
    TestTableData iface_g_mozilla_engine_get_load_images;
    TestTableData iface_g_mozilla_engine_set_frame_stacking;
    TestTableData iface_g_mozilla_engine_get_frame_stacking;
    TestTableData iface_g_mozilla_engine_save_web_page;
    TestTableData iface_g_mozilla_engine_save_current_frame;
    TestTableData iface_g_mozilla_engine_get_frame_title;
    TestTableData iface_g_mozilla_engine_get_element_details;
    TestTableData iface_g_mozilla_engine_get_frame_number;


    
} TestData;
TestData testdata;
static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.content_set_cursor.table);
    testdata.content_set_cursor.table = NULL;
    testdata.content_set_cursor.index = -1;

    g_list_free(testdata.dom_mouse_down_cb.table);
    testdata.dom_mouse_down_cb.table = NULL;
    testdata.dom_mouse_down_cb.index = -1;

    g_list_free(testdata.dom_mouse_long_press_cb.table);
    testdata.dom_mouse_long_press_cb.table = NULL;
    testdata.dom_mouse_long_press_cb.index = -1;

    g_list_free(testdata.g_moz_eal_im_context_commit.table);
    testdata.g_moz_eal_im_context_commit.table = NULL;
    testdata.g_moz_eal_im_context_commit.index = -1;

    g_list_free(testdata.g_moz_eal_im_context_delete_surrounding.table);
    testdata.g_moz_eal_im_context_delete_surrounding.table = NULL;
    testdata.g_moz_eal_im_context_delete_surrounding.index = -1;

    g_list_free(testdata.g_moz_eal_im_context_has_selection.table);
    testdata.g_moz_eal_im_context_has_selection.table = NULL;
    testdata.g_moz_eal_im_context_has_selection.index = -1;

    g_list_free(testdata.g_moz_eal_im_context_retrieve_surrounding.table);
    testdata.g_moz_eal_im_context_retrieve_surrounding.table = NULL;
    testdata.g_moz_eal_im_context_retrieve_surrounding.index = -1;

    g_list_free(testdata.g_moz_eal_preedit_changed_cb.table);
    testdata.g_moz_eal_preedit_changed_cb.table = NULL;
    testdata.g_moz_eal_preedit_changed_cb.index = -1;

    g_list_free(testdata.g_mozilla_add_notification_button.table);
    testdata.g_mozilla_add_notification_button.table = NULL;
    testdata.g_mozilla_add_notification_button.index = -1;

    g_list_free(testdata.g_mozilla_append_notification.table);
    testdata.g_mozilla_append_notification.table = NULL;
    testdata.g_mozilla_append_notification.index = -1;

    g_list_free(testdata.g_mozilla_engine_alert.table);
    testdata.g_mozilla_engine_alert.table = NULL;
    testdata.g_mozilla_engine_alert.index = -1;

    g_list_free(testdata.g_mozilla_engine_confirm.table);
    testdata.g_mozilla_engine_confirm.table = NULL;
    testdata.g_mozilla_engine_confirm.index = -1;

    g_list_free(testdata.g_mozilla_engine_get_encoding.table);
    testdata.g_mozilla_engine_get_encoding.table = NULL;
    testdata.g_mozilla_engine_get_encoding.index = -1;

    g_list_free(testdata.g_mozilla_engine_get_page_verifier_name.table);
    testdata.g_mozilla_engine_get_page_verifier_name.table = NULL;
    testdata.g_mozilla_engine_get_page_verifier_name.index = -1;

    g_list_free(testdata.g_mozilla_engine_get_server_certificate.table);
    testdata.g_mozilla_engine_get_server_certificate.table = NULL;
    testdata.g_mozilla_engine_get_server_certificate.index = -1;

    g_list_free(testdata.g_mozilla_engine_get_type.table);
    testdata.g_mozilla_engine_get_type.table = NULL;
    testdata.g_mozilla_engine_get_type.index = -1;

    g_list_free(testdata.g_mozilla_engine_get_zoom_level.table);
    testdata.g_mozilla_engine_get_zoom_level.table = NULL;
    testdata.g_mozilla_engine_get_zoom_level.index = -1;

    g_list_free(testdata.g_mozilla_engine_new.table);
    testdata.g_mozilla_engine_new.table = NULL;
    testdata.g_mozilla_engine_new.index = -1;

    g_list_free(testdata.g_mozilla_engine_new_with_context.table);
    testdata.g_mozilla_engine_new_with_context.table = NULL;
    testdata.g_mozilla_engine_new_with_context.index = -1;

    g_list_free(testdata.g_mozilla_engine_new_with_context_and_tracks.table);
    testdata.g_mozilla_engine_new_with_context_and_tracks.table = NULL;
    testdata.g_mozilla_engine_new_with_context_and_tracks.index = -1;

    g_list_free(testdata.g_mozilla_remove_notification.table);
    testdata.g_mozilla_remove_notification.table = NULL;
    testdata.g_mozilla_remove_notification.index = -1;

    g_list_free(testdata.g_mozilla_show_notification.table);
    testdata.g_mozilla_show_notification.table = NULL;
    testdata.g_mozilla_show_notification.index = -1;

    g_list_free(testdata.ctx_mozembed_to_eal.table);
    testdata.ctx_mozembed_to_eal.table = NULL;
    testdata.ctx_mozembed_to_eal.index = -1;

    g_list_free(testdata.g_mozilla_create_select_notification.table);
    testdata.g_mozilla_create_select_notification.table = NULL;
    testdata.g_mozilla_create_select_notification.index = -1;

    g_list_free(testdata.g_mozilla_engine_permit_page_unload.table);
    testdata.g_mozilla_engine_permit_page_unload.table = NULL;
    testdata.g_mozilla_engine_permit_page_unload.index = -1;

    g_list_free(testdata.g_mozilla_engine_send_mouse_event.table);
    testdata.g_mozilla_engine_send_mouse_event.table = NULL;
    testdata.g_mozilla_engine_send_mouse_event.index = -1;

    g_list_free(testdata.g_mozilla_engine_update_area.table);
    testdata.g_mozilla_engine_update_area.table = NULL;
    testdata.g_mozilla_engine_update_area.index = -1;

    g_list_free(testdata.g_mozilla_engine_visible_area.table);
    testdata.g_mozilla_engine_visible_area.table = NULL;
    testdata.g_mozilla_engine_visible_area.index = -1;

    g_list_free(testdata.g_mozilla_send_notification.table);
    testdata.g_mozilla_send_notification.table = NULL;
    testdata.g_mozilla_send_notification.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_destroy.table);
    testdata.iface_g_mozilla_engine_destroy.table = NULL;
    testdata.iface_g_mozilla_engine_destroy.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_reset.table);
    testdata.iface_g_mozilla_engine_reset.table = NULL;
    testdata.iface_g_mozilla_engine_reset.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_load_url.table);
    testdata.iface_g_mozilla_engine_load_url.table = NULL;
    testdata.iface_g_mozilla_engine_load_url.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_load_follow_link.table);
    testdata.iface_g_mozilla_engine_load_follow_link.table = NULL;
    testdata.iface_g_mozilla_engine_load_follow_link.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_load_url_with_css.table);
    testdata.iface_g_mozilla_engine_load_url_with_css.table = NULL;
    testdata.iface_g_mozilla_engine_load_url_with_css.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_load_url_with_js.table);
    testdata.iface_g_mozilla_engine_load_url_with_js.table = NULL;
    testdata.iface_g_mozilla_engine_load_url_with_js.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_load_home_page.table);
    testdata.iface_g_mozilla_engine_load_home_page.table = NULL;
    testdata.iface_g_mozilla_engine_load_home_page.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_stop_load.table);
    testdata.iface_g_mozilla_engine_stop_load.table = NULL;
    testdata.iface_g_mozilla_engine_stop_load.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_reload.table);
    testdata.iface_g_mozilla_engine_reload.table = NULL;
    testdata.iface_g_mozilla_engine_reload.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_go_back.table);
    testdata.iface_g_mozilla_engine_go_back.table = NULL;
    testdata.iface_g_mozilla_engine_go_back.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_go_forward.table);
    testdata.iface_g_mozilla_engine_go_forward.table = NULL;
    testdata.iface_g_mozilla_engine_go_forward.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_can_go_back.table);
    testdata.iface_g_mozilla_engine_can_go_back.table = NULL;
    testdata.iface_g_mozilla_engine_can_go_back.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_can_go_forward.table);
    testdata.iface_g_mozilla_engine_can_go_forward.table = NULL;
    testdata.iface_g_mozilla_engine_can_go_forward.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_set_zoom_level.table);
    testdata.iface_g_mozilla_engine_set_zoom_level.table = NULL;
    testdata.iface_g_mozilla_engine_set_zoom_level.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_set_zoom_level_around_point.table);
    testdata.iface_g_mozilla_engine_set_zoom_level_around_point.table = NULL;
    testdata.iface_g_mozilla_engine_set_zoom_level_around_point.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_compare_frames_zoom_level.table);
    testdata.iface_g_mozilla_engine_compare_frames_zoom_level.table = NULL;
    testdata.iface_g_mozilla_engine_compare_frames_zoom_level.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_zoom_by_steps.table);
    testdata.iface_g_mozilla_engine_zoom_by_steps.table = NULL;
    testdata.iface_g_mozilla_engine_zoom_by_steps.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_new_zoom_by_steps.table);
    testdata.iface_g_mozilla_engine_new_zoom_by_steps.table = NULL;
    testdata.iface_g_mozilla_engine_new_zoom_by_steps.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_set_frame_zoom_level.table);
    testdata.iface_g_mozilla_engine_set_frame_zoom_level.table = NULL;
    testdata.iface_g_mozilla_engine_set_frame_zoom_level.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_frame_zoom_level.table);
    testdata.iface_g_mozilla_engine_get_frame_zoom_level.table = NULL;
    testdata.iface_g_mozilla_engine_get_frame_zoom_level.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_image_properties.table);
    testdata.iface_g_mozilla_engine_get_image_properties.table = NULL;
    testdata.iface_g_mozilla_engine_get_image_properties.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_frame_properties.table);
    testdata.iface_g_mozilla_engine_get_frame_properties.table = NULL;
    testdata.iface_g_mozilla_engine_get_frame_properties.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_load_image.table);
    testdata.iface_g_mozilla_engine_load_image.table = NULL;
    testdata.iface_g_mozilla_engine_load_image.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_back_window_history_list.table);
    testdata.iface_g_mozilla_engine_get_back_window_history_list.table = NULL;
    testdata.iface_g_mozilla_engine_get_back_window_history_list.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_forward_window_history_list.table);
    testdata.iface_g_mozilla_engine_get_forward_window_history_list.table = NULL;
    testdata.iface_g_mozilla_engine_get_forward_window_history_list.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_set_layout_mode.table);
    testdata.iface_g_mozilla_engine_set_layout_mode.table = NULL;
    testdata.iface_g_mozilla_engine_set_layout_mode.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_layout_mode.table);
    testdata.iface_g_mozilla_engine_get_layout_mode.table = NULL;
    testdata.iface_g_mozilla_engine_get_layout_mode.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_set_load_images.table);
    testdata.iface_g_mozilla_engine_set_load_images.table = NULL;
    testdata.iface_g_mozilla_engine_set_load_images.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_load_images.table);
    testdata.iface_g_mozilla_engine_get_load_images.table = NULL;
    testdata.iface_g_mozilla_engine_get_load_images.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_set_frame_stacking.table);
    testdata.iface_g_mozilla_engine_set_frame_stacking.table = NULL;
    testdata.iface_g_mozilla_engine_set_frame_stacking.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_frame_stacking.table);
    testdata.iface_g_mozilla_engine_get_frame_stacking.table = NULL;
    testdata.iface_g_mozilla_engine_get_frame_stacking.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_save_web_page.table);
    testdata.iface_g_mozilla_engine_save_web_page.table = NULL;
    testdata.iface_g_mozilla_engine_save_web_page.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_save_current_frame.table);
    testdata.iface_g_mozilla_engine_save_current_frame.table = NULL;
    testdata.iface_g_mozilla_engine_save_current_frame.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_frame_title.table);
    testdata.iface_g_mozilla_engine_get_frame_title.table = NULL;
    testdata.iface_g_mozilla_engine_get_frame_title.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_element_details.table);
    testdata.iface_g_mozilla_engine_get_element_details.table = NULL;
    testdata.iface_g_mozilla_engine_get_element_details.index = -1;

    g_list_free(testdata.iface_g_mozilla_engine_get_frame_number.table);
    testdata.iface_g_mozilla_engine_get_frame_number.table = NULL;
    testdata.iface_g_mozilla_engine_get_frame_number.index = -1;


}

/**
 * New test case added automatically by test creation script.
 */
void test_content_set_cursor(void)
{

    DEBUG_FUNCTIONS_STARTED("content_set_cursor");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.content_set_cursor.index;
        printf("Index of test data: %i\n", test_index);
        ContentSetCursorStruct* test_item_data = (ContentSetCursorStruct*)g_list_nth_data(testdata.content_set_cursor.table, test_index);
        testdata.content_set_cursor.index++;


        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GdkCursorType type = test_item_data->type;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = content_set_cursor(self,type);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = content_set_cursor(self,type);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_dom_mouse_down_cb(void)
{

    DEBUG_FUNCTIONS_STARTED("dom_mouse_down_cb");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.dom_mouse_down_cb.index;
        printf("Index of test data: %i\n", test_index);
        DomMouseDownCbStruct* test_item_data = (DomMouseDownCbStruct*)g_list_nth_data(testdata.dom_mouse_down_cb.table, test_index);
        testdata.dom_mouse_down_cb.index++;

        GtkMozEmbed* embed = test_item_data->embed;
        void* event = test_item_data->event;
        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gint retvalue;
        if(testdata.basics) {
            retvalue = dom_mouse_down_cb(embed,event,self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = dom_mouse_down_cb(embed,event,self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_dom_mouse_long_press_cb(void)
{

    DEBUG_FUNCTIONS_STARTED("dom_mouse_long_press_cb");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.dom_mouse_long_press_cb.index;
        printf("Index of test data: %i\n", test_index);
        DomMouseLongPressCbStruct* test_item_data = (DomMouseLongPressCbStruct*)g_list_nth_data(testdata.dom_mouse_long_press_cb.table, test_index);
        testdata.dom_mouse_long_press_cb.index++;

        GtkMozEmbed* embed = test_item_data->embed;
        void* event = test_item_data->event;
        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gint retvalue;
        if(testdata.basics) {
            retvalue = dom_mouse_long_press_cb(embed,event,self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = dom_mouse_long_press_cb(embed,event,self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_moz_eal_im_context_commit(void)
{

    DEBUG_FUNCTIONS_STARTED("g_moz_eal_im_context_commit");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_moz_eal_im_context_commit.index;
        printf("Index of test data: %i\n", test_index);
        GMozEalImContextCommitStruct* test_item_data = (GMozEalImContextCommitStruct*)g_list_nth_data(testdata.g_moz_eal_im_context_commit.table, test_index);
        testdata.g_moz_eal_im_context_commit.index++;

        GtkIMContext* ctx = test_item_data->ctx;
         const gchar* str = test_item_data->str;
         GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_moz_eal_im_context_commit(ctx,str,self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_moz_eal_im_context_commit(ctx,str,self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_moz_eal_im_context_delete_surrounding(void)
{

    DEBUG_FUNCTIONS_STARTED("g_moz_eal_im_context_delete_surrounding");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_moz_eal_im_context_delete_surrounding.index;
        printf("Index of test data: %i\n", test_index);
        GMozEalImDeleteSurroundingStruct* test_item_data = (GMozEalImDeleteSurroundingStruct*)g_list_nth_data(testdata.g_moz_eal_im_context_delete_surrounding.table, test_index);
        testdata.g_moz_eal_im_context_delete_surrounding.index++;

        GtkIMContext* aContext = test_item_data->aContext;
         gint arg1 = test_item_data->arg1;
         gint arg2 = test_item_data->arg2;
         GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_moz_eal_im_context_delete_surrounding(aContext,arg1,arg2,self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_moz_eal_im_context_delete_surrounding(aContext,arg1,arg2,self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_moz_eal_im_context_has_selection(void)
{

    DEBUG_FUNCTIONS_STARTED("g_moz_eal_im_context_has_selection");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_moz_eal_im_context_has_selection.index;
        printf("Index of test data: %i\n", test_index);
        GMozEalImContextHasSelectionStruct* test_item_data = (GMozEalImContextHasSelectionStruct*)g_list_nth_data(testdata.g_moz_eal_im_context_has_selection.table, test_index);
        testdata.g_moz_eal_im_context_has_selection.index++;

        GtkIMContext* context = test_item_data->context;
         GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_moz_eal_im_context_has_selection(context,self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_moz_eal_im_context_has_selection(context,self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_moz_eal_im_context_retrieve_surrounding(void)
{

    DEBUG_FUNCTIONS_STARTED("g_moz_eal_im_context_retrieve_surrounding");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_moz_eal_im_context_retrieve_surrounding.index;
        printf("Index of test data: %i\n", test_index);
        GMozEalImContextRetrieveSurroundingStruct* test_item_data = (GMozEalImContextRetrieveSurroundingStruct*)g_list_nth_data(testdata.g_moz_eal_im_context_retrieve_surrounding.table, test_index);
        testdata.g_moz_eal_im_context_retrieve_surrounding.index++;

        GtkIMContext* aContext = test_item_data->aContext;
         GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_moz_eal_im_context_retrieve_surrounding(aContext,self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_moz_eal_im_context_retrieve_surrounding(aContext,self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_moz_eal_preedit_changed_cb(void)
{

    DEBUG_FUNCTIONS_STARTED("g_moz_eal_preedit_changed_cb");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_moz_eal_preedit_changed_cb.index;
        printf("Index of test data: %i\n", test_index);
        GMozEalPreeditChangedCbStruct* test_item_data = (GMozEalPreeditChangedCbStruct*)g_list_nth_data(testdata.g_moz_eal_preedit_changed_cb.table, test_index);
        testdata.g_moz_eal_preedit_changed_cb.index++;

        GtkIMContext* aContext = test_item_data->aContext;
         GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        if(testdata.basics) {
            g_moz_eal_preedit_changed_cb(aContext,self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_moz_eal_preedit_changed_cb(aContext,self);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_add_notification_button(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_add_notification_button");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_add_notification_button.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaAddNotificationButtonStruct* test_item_data = (GMozillaAddNotificationButtonStruct*)g_list_nth_data(testdata.g_mozilla_add_notification_button.table, test_index);
        testdata.g_mozilla_add_notification_button.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gpointer notification_widget;
        if(test_item_data->test_notification_widget_pp)
        {
            notification_widget = *test_item_data->test_notification_widget_pp;
        }
        else
        {
            notification_widget = test_item_data->notification_widget;
        }
        gpointer notification = test_item_data->notification;
        gpointer notification_button = test_item_data->notification_button;
        gchar* label = test_item_data->label;
        if(testdata.basics) {
            g_mozilla_add_notification_button(self,notification_widget,notification,notification_button,label);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_add_notification_button(self,notification_widget,notification,notification_button,label);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_append_notification(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_append_notification");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_append_notification.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaAppendNotificationStruct* test_item_data = (GMozillaAppendNotificationStruct*)g_list_nth_data(testdata.g_mozilla_append_notification.table, test_index);
        testdata.g_mozilla_append_notification.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        const gchar* notification_label = test_item_data->notification_label;
        gpointer notification = test_item_data->notification;
        if(testdata.basics) {
            test_item_data->retvalue = g_mozilla_append_notification(self,notification_label,notification);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->retvalue = g_mozilla_append_notification(self,notification_label,notification);
            if(test_item_data->test_is_retvalue_expected)
            {
                CU_ASSERT_NOT_EQUAL(test_item_data->retvalue, NULL);
            }
            else
            {
                CU_ASSERT_EQUAL(test_item_data->retvalue, NULL);
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_alert(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_alert");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_alert.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineAlertStruct* test_item_data = (GMozillaEngineAlertStruct*)g_list_nth_data(testdata.g_mozilla_engine_alert.table, test_index);
        testdata.g_mozilla_engine_alert.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        const gchar* dialog_title = test_item_data->dialog_title;
        const gchar* alert_msg = test_item_data->alert_msg;
        gboolean is_blocking = test_item_data->is_blocking;
        const char* check_msg = test_item_data->check_msg;
        gboolean* check_val = test_item_data->check_val;
        gint retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_engine_alert(self,dialog_title,alert_msg,is_blocking,check_msg,check_val);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_engine_alert(self,dialog_title,alert_msg,is_blocking,check_msg,check_val);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_confirm(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_confirm");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_confirm.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineConfirmStruct* test_item_data = (GMozillaEngineConfirmStruct*)g_list_nth_data(testdata.g_mozilla_engine_confirm.table, test_index);
        testdata.g_mozilla_engine_confirm.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        const gchar* dialog_title = test_item_data->dialog_title;
        const gchar* dialog_msg = test_item_data->dialog_msg;
        const char* check_msg = test_item_data->check_msg;
        gboolean* check_val = test_item_data->check_val;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_engine_confirm(self,dialog_title,dialog_msg,check_msg,check_val);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_engine_confirm(self,dialog_title,dialog_msg,check_msg,check_val);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_get_encoding(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_get_encoding");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_get_encoding.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineGetEncodingStruct* test_item_data = (GMozillaEngineGetEncodingStruct*)g_list_nth_data(testdata.g_mozilla_engine_get_encoding.table, test_index);
        testdata.g_mozilla_engine_get_encoding.index++;

        GtkMozEmbed* embed = test_item_data->embed;
        GWebEngineEncoding retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_engine_get_encoding(embed);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebEngineEncoding expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_engine_get_encoding(embed);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_get_page_verifier_name(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_get_page_verifier_name");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_engine_get_page_verifier_name.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineGetPageVerifierNameStruct* test_item_data = (GMozillaEngineGetPageVerifierNameStruct*)g_list_nth_data(testdata.g_mozilla_engine_get_page_verifier_name.table, test_index);
        testdata.g_mozilla_engine_get_page_verifier_name.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gchar* retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_engine_get_page_verifier_name(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gchar* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_engine_get_page_verifier_name(self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_get_server_certificate(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_get_server_certificate");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_engine_get_server_certificate.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineGetServerCertificateStruct* test_item_data = (GMozillaEngineGetServerCertificateStruct*)g_list_nth_data(testdata.g_mozilla_engine_get_server_certificate.table, test_index);
        testdata.g_mozilla_engine_get_server_certificate.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
         gpointer context = test_item_data->context;
        GArray* retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_engine_get_server_certificate(self,context);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GArray* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_engine_get_server_certificate(self,context);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_get_type(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_get_type");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_get_type.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineGetTypeStruct* test_item_data = (GMozillaEngineGetTypeStruct*)g_list_nth_data(testdata.g_mozilla_engine_get_type.table, test_index);
        testdata.g_mozilla_engine_get_type.index++;

        GType retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_engine_get_type();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        /*
        else
        {
            GType expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_engine_get_type();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_get_zoom_level(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_get_zoom_level");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_get_zoom_level.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineGetZoomLevelStruct* test_item_data = (GMozillaEngineGetZoomLevelStruct*)g_list_nth_data(testdata.g_mozilla_engine_get_zoom_level.table, test_index);
        testdata.g_mozilla_engine_get_zoom_level.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        guint retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_engine_get_zoom_level(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            guint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_engine_get_zoom_level(self);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_new(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_new");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_new.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineNewStruct* test_item_data = (GMozillaEngineNewStruct*)g_list_nth_data(testdata.g_mozilla_engine_new.table, test_index);
        testdata.g_mozilla_engine_new.index++;

        if(testdata.basics) {
            test_item_data->retvalue = g_mozilla_engine_new();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->retvalue = g_mozilla_engine_new();
            if(test_item_data->test_is_retvalue_expected)
            {
                CU_ASSERT_NOT_EQUAL(test_item_data->retvalue, NULL);
            }
            else
            {
                CU_ASSERT_EQUAL(test_item_data->retvalue, NULL);
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_new_with_context(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_new_with_context");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_new_with_context.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineNewWithContextStruct* test_item_data = (GMozillaEngineNewWithContextStruct*)g_list_nth_data(testdata.g_mozilla_engine_new_with_context.table, test_index);
        testdata.g_mozilla_engine_new_with_context.index++;

        gpointer context = test_item_data->context;
        if(testdata.basics) {
            test_item_data->retvalue = g_mozilla_engine_new_with_context(context);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->retvalue = g_mozilla_engine_new_with_context(context);
            if(test_item_data->test_is_retvalue_expected)
            {
                CU_ASSERT_NOT_EQUAL(test_item_data->retvalue, NULL);
            }
            else
            {
                CU_ASSERT_EQUAL(test_item_data->retvalue, NULL);
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_new_with_context_and_tracks(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_new_with_context_and_tracks");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_new_with_context_and_tracks.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineNewWithContextAndTracksStruct* test_item_data = (GMozillaEngineNewWithContextAndTracksStruct*)g_list_nth_data(testdata.g_mozilla_engine_new_with_context_and_tracks.table, test_index);
        testdata.g_mozilla_engine_new_with_context_and_tracks.index++;

        gpointer context = test_item_data->context;
        gboolean leave_tracks = test_item_data->leave_tracks;
        gboolean without_history = test_item_data->without_history;
        guint32 flags = test_item_data->flags;
        if(testdata.basics) {
            test_item_data->retvalue = g_mozilla_engine_new_with_context_and_tracks(context,leave_tracks,without_history,flags);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->retvalue = g_mozilla_engine_new_with_context_and_tracks(context,leave_tracks,without_history,flags);
            if(test_item_data->test_is_retvalue_expected)
            {
                CU_ASSERT_NOT_EQUAL(test_item_data->retvalue, NULL);
            }
            else
            {
                CU_ASSERT_EQUAL(test_item_data->retvalue, NULL);
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_remove_notification(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_remove_notification");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_remove_notification.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaRemoveNotificationStruct* test_item_data = (GMozillaRemoveNotificationStruct*)g_list_nth_data(testdata.g_mozilla_remove_notification.table, test_index);
        testdata.g_mozilla_remove_notification.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gpointer notification_widget = test_item_data->notification_widget;
        if(testdata.basics) {
            g_mozilla_remove_notification(self,notification_widget);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_remove_notification(self,notification_widget);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_show_notification(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_show_notification");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_show_notification.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaShowNotificationStruct* test_item_data = (GMozillaShowNotificationStruct*)g_list_nth_data(testdata.g_mozilla_show_notification.table, test_index);
        testdata.g_mozilla_show_notification.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gpointer notification_widget = test_item_data->notification_widget;
        gpointer notification = test_item_data->notification;
        if(testdata.basics) {
            g_mozilla_show_notification(self,notification_widget,notification);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_show_notification(self,notification_widget,notification);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_ctx_mozembed_to_eal(void)
{

    DEBUG_FUNCTIONS_STARTED("ctx_mozembed_to_eal");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.ctx_mozembed_to_eal.index;
        printf("Index of test data: %i\n", test_index);
        CtxMozembedToEalStruct* test_item_data = (CtxMozembedToEalStruct*)g_list_nth_data(testdata.ctx_mozembed_to_eal.table, test_index);
        testdata.ctx_mozembed_to_eal.index++;

        guint moz_embed_ctx = test_item_data->moz_embed_ctx;
        guint retvalue;
        if(testdata.basics) {
            retvalue = ctx_mozembed_to_eal(moz_embed_ctx);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            guint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = ctx_mozembed_to_eal(moz_embed_ctx);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_create_select_notification(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_create_select_notification");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_create_select_notification.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaCreateSelectNotificationStruct* test_item_data = (GMozillaCreateSelectNotificationStruct*)g_list_nth_data(testdata.g_mozilla_create_select_notification.table, test_index);
        testdata.g_mozilla_create_select_notification.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GSList* list = test_item_data->list;
        gpointer ctx_node = test_item_data->ctx_node;
        gboolean multiple = test_item_data->multiple;
        gint* selected = test_item_data->selected;
        gint sel_count = test_item_data->sel_count;
        if(testdata.basics) {
            g_mozilla_create_select_notification(self,list,ctx_node,multiple,selected,sel_count);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_create_select_notification(self,list,ctx_node,multiple,selected,sel_count);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_permit_page_unload(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_permit_page_unload");

    if(testdata.automatic)
    {
        CU_FAIL("//INTERFACE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_engine_permit_page_unload.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEnginePermitPageUnloadStruct* test_item_data = (GMozillaEnginePermitPageUnloadStruct*)g_list_nth_data(testdata.g_mozilla_engine_permit_page_unload.table, test_index);
        testdata.g_mozilla_engine_permit_page_unload.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_engine_permit_page_unload(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_engine_permit_page_unload(self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_send_mouse_event(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_send_mouse_event");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_send_mouse_event.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineSendMouseEventStruct* test_item_data = (GMozillaEngineSendMouseEventStruct*)g_list_nth_data(testdata.g_mozilla_engine_send_mouse_event.table, test_index);
        testdata.g_mozilla_engine_send_mouse_event.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        int type = test_item_data->type;
        int x = test_item_data->x;
        int y = test_item_data->y;
        int mod = test_item_data->mod;
        int button = test_item_data->button;
        int clickcount = test_item_data->clickcount;
        int time = test_item_data->time;
        if(testdata.basics) {
            g_mozilla_engine_send_mouse_event(self,type,x,y,mod,button,clickcount,time);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_engine_send_mouse_event(self,type,x,y,mod,button,clickcount,time);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_update_area(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_update_area");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_update_area.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineUpdateAreaStruct* test_item_data = (GMozillaEngineUpdateAreaStruct*)g_list_nth_data(testdata.g_mozilla_engine_update_area.table, test_index);
        testdata.g_mozilla_engine_update_area.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        int id = test_item_data->id;
        int top = test_item_data->top;
        int left = test_item_data->left;
        int width = test_item_data->width;
        int height = test_item_data->height;
        int zoom = test_item_data->zoom;
        if(testdata.basics) {
            g_mozilla_engine_update_area(self,id,top,left,width,height,zoom);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_engine_update_area(self,id,top,left,width,height,zoom);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_engine_visible_area(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_engine_visible_area");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_engine_visible_area.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaEngineVisibleAreaStruct* test_item_data = (GMozillaEngineVisibleAreaStruct*)g_list_nth_data(testdata.g_mozilla_engine_visible_area.table, test_index);
        testdata.g_mozilla_engine_visible_area.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        int vx = test_item_data->vx;
        int vy = test_item_data->vy;
        int vw = test_item_data->vw;
        int vh = test_item_data->vh;
        int tx = test_item_data->tx;
        int ty = test_item_data->ty;
        int tw = test_item_data->tw;
        int th = test_item_data->th;
        int wx = test_item_data->wx;
        int wy = test_item_data->wy;
        int ww = test_item_data->ww;
        int wh = test_item_data->wh;
        if(testdata.basics) {
            g_mozilla_engine_visible_area(self,vx,vy,vw,vh,tx,ty,tw,th,wx,wy,ww,wh);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_engine_visible_area(self,vx,vy,vw,vh,tx,ty,tw,th,wx,wy,ww,wh);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_send_notification(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_send_notification");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_send_notification.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaSendNotificationStruct* test_item_data = (GMozillaSendNotificationStruct*)g_list_nth_data(testdata.g_mozilla_send_notification.table, test_index);
        testdata.g_mozilla_send_notification.index++;

        GMozillaEngine* self = test_item_data->self;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
         gpointer notification_widget = test_item_data->notification_widget;
        if(testdata.basics) {
            g_mozilla_send_notification(self,notification_widget);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_send_notification(self,notification_widget);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_destroy(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_destroy");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_destroy.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineDestroyStruct* test_item_data = (IfaceGMozillaEngineDestroyStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_destroy.table, test_index);
        testdata.iface_g_mozilla_engine_destroy.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        if(testdata.basics) {
            iface->destroy((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->destroy((GWebEngine*)self);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_reset(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_reset");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_reset.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineResetStruct* test_item_data = (IfaceGMozillaEngineResetStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_reset.table, test_index);
        testdata.iface_g_mozilla_engine_reset.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        if(testdata.basics) {
            iface->reset((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->reset((GWebEngine*)self);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_load_url(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_load_url");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_load_url.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineLoadUrlStruct* test_item_data = (IfaceGMozillaEngineLoadUrlStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_load_url.table, test_index);
        testdata.iface_g_mozilla_engine_load_url.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gchar* url = test_item_data->url;
        GWebEngineIface* iface = test_item_data->test_iface;
        if(testdata.basics) {
            iface->load_url((GWebEngine*)self, url);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->load_url((GWebEngine*)self, url);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_load_follow_link(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_load_follow_link");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_load_follow_link.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineLoadFollowLinkStruct* test_item_data = (IfaceGMozillaEngineLoadFollowLinkStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_load_follow_link.table, test_index);
        testdata.iface_g_mozilla_engine_load_follow_link.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gchar* url = test_item_data->url;
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->load_follow_link((GWebEngine*)self, url);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->load_follow_link((GWebEngine*)self, url);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_load_url_with_css(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_load_url_with_css");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_load_url_with_css.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineLoadUrlWithCssStruct* test_item_data = (IfaceGMozillaEngineLoadUrlWithCssStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_load_url_with_css.table, test_index);
        testdata.iface_g_mozilla_engine_load_url_with_css.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gchar* url = test_item_data->url;
        gchar* cssfile = test_item_data->cssfile;
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->load_url_with_css((GWebEngine*)self, url, cssfile);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->load_url_with_css((GWebEngine*)self, url, cssfile);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_load_url_with_js(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_load_url_with_js");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_load_url_with_js.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineLoadUrlWithJsStruct* test_item_data = (IfaceGMozillaEngineLoadUrlWithJsStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_load_url_with_js.table, test_index);
        testdata.iface_g_mozilla_engine_load_url_with_js.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gboolean enable = test_item_data->enable;
        GWebEngineIface* iface = test_item_data->test_iface;
        if(testdata.basics) {
            iface->load_url_with_js((GWebEngine*)self, enable);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->load_url_with_js((GWebEngine*)self, enable);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_load_home_page(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_load_home_page");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_load_home_page.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineLoadHomePageStruct* test_item_data =
            (IfaceGMozillaEngineLoadHomePageStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_load_home_page.table, test_index);
        testdata.iface_g_mozilla_engine_load_home_page.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        if(testdata.basics) {
            iface->load_home_page((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->load_home_page((GWebEngine*)self);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_stop_load(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_stop_load");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_stop_load.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineStopLoadStruct* test_item_data =
            (IfaceGMozillaEngineStopLoadStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_stop_load.table, test_index);
        testdata.iface_g_mozilla_engine_stop_load.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        if(testdata.basics) {
            iface->stop_load((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->stop_load((GWebEngine*)self);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_reload(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_reload");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_reload.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineReloadStruct* test_item_data =
            (IfaceGMozillaEngineReloadStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_reload.table, test_index);
        testdata.iface_g_mozilla_engine_reload.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        if(testdata.basics) {
            iface->reload((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->reload((GWebEngine*)self);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_go_back(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_go_back");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_go_back.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGoBackStruct* test_item_data =
            (IfaceGMozillaEngineGoBackStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_go_back.table, test_index);
        testdata.iface_g_mozilla_engine_go_back.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        guint nsteps = test_item_data->nsteps;
        if(testdata.basics) {
            iface->go_back((GWebEngine*)self, nsteps);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->go_back((GWebEngine*)self, nsteps);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_go_forward(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_go_forward");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_go_forward.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGoForwardStruct* test_item_data =
            (IfaceGMozillaEngineGoForwardStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_go_forward.table, test_index);
        testdata.iface_g_mozilla_engine_go_forward.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        guint nsteps = test_item_data->nsteps;
        if(testdata.basics) {
            iface->go_forward((GWebEngine*)self, nsteps);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->go_forward((GWebEngine*)self, nsteps);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_can_go_back(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_can_go_back");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_can_go_back.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineCanGoBackStruct* test_item_data =
            (IfaceGMozillaEngineCanGoBackStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_can_go_back.table, test_index);
        testdata.iface_g_mozilla_engine_can_go_back.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = iface->can_go_back((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->can_go_back((GWebEngine*)self);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_can_go_forward(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_can_go_forward");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_can_go_forward.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineCanGoForwardStruct* test_item_data =
            (IfaceGMozillaEngineCanGoForwardStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_can_go_forward.table, test_index);
        testdata.iface_g_mozilla_engine_can_go_forward.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = iface->can_go_forward((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->can_go_forward((GWebEngine*)self);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_set_zoom_level(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_set_zoom_level");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_set_zoom_level.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineSetZoomLevelStruct* test_item_data =
            (IfaceGMozillaEngineSetZoomLevelStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_set_zoom_level.table, test_index);
        testdata.iface_g_mozilla_engine_set_zoom_level.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gint level = test_item_data->level;
        if(testdata.basics) {
            iface->set_zoom_level((GWebEngine*)self, level);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->set_zoom_level((GWebEngine*)self, level);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_set_zoom_level_around_point(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_set_zoom_level_around_point");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_set_zoom_level_around_point.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineSetZoomLevelAroundPointStruct* test_item_data =
            (IfaceGMozillaEngineSetZoomLevelAroundPointStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_set_zoom_level_around_point.table, test_index);
        testdata.iface_g_mozilla_engine_set_zoom_level_around_point.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        guint x = test_item_data->x;
        guint y = test_item_data->y;
        gint level = test_item_data->level;
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->set_zoom_level_around_point((GWebEngine*)self, x, y, level);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->set_zoom_level_around_point((GWebEngine*)self, x, y, level);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_compare_frames_zoom_level(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_compare_frames_zoom_level");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_compare_frames_zoom_level.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineCompareFramesZoomLevelStruct* test_item_data =
            (IfaceGMozillaEngineCompareFramesZoomLevelStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_compare_frames_zoom_level.table, test_index);
        testdata.iface_g_mozilla_engine_compare_frames_zoom_level.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        gboolean* equal = test_item_data->equal;
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->compare_frames_zoom_level((GWebEngine*)self, equal);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->compare_frames_zoom_level((GWebEngine*)self, equal);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_zoom_by_steps(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_zoom_by_steps");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_zoom_by_steps.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineZoomByStepsStruct* test_item_data =
            (IfaceGMozillaEngineZoomByStepsStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_zoom_by_steps.table, test_index);
        testdata.iface_g_mozilla_engine_zoom_by_steps.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        guint relative_zoom = test_item_data->relative_zoom;
        guint* legal_zoom_value = test_item_data->legal_zoom_value;
        if(testdata.basics) {
            iface->zoom_by_steps((GWebEngine*)self, relative_zoom, legal_zoom_value);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->zoom_by_steps((GWebEngine*)self, relative_zoom, legal_zoom_value);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_new_zoom_by_steps(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_new_zoom_by_steps");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_new_zoom_by_steps.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineNewZoomByStepsStruct* test_item_data =
            (IfaceGMozillaEngineNewZoomByStepsStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_new_zoom_by_steps.table, test_index);
        testdata.iface_g_mozilla_engine_new_zoom_by_steps.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        guint relative_zoom = test_item_data->relative_zoom;
        guint* legal_zoom_value = test_item_data->legal_zoom_value;
        if(testdata.basics) {
            iface->new_zoom_by_steps((GWebEngine*)self, relative_zoom, legal_zoom_value);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->new_zoom_by_steps((GWebEngine*)self, relative_zoom, legal_zoom_value);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_set_frame_zoom_level(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_set_frame_zoom_level");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_set_frame_zoom_level.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineSetFrameZoomLevelStruct* test_item_data =
            (IfaceGMozillaEngineSetFrameZoomLevelStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_set_frame_zoom_level.table, test_index);
        testdata.iface_g_mozilla_engine_set_frame_zoom_level.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        guint level = test_item_data->level;
        if(testdata.basics) {
            iface->set_frame_zoom_level((GWebEngine*)self, level);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->set_frame_zoom_level((GWebEngine*)self, level);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_frame_zoom_level(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_frame_zoom_level");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_frame_zoom_level.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetFrameZoomLevelStruct* test_item_data =
            (IfaceGMozillaEngineGetFrameZoomLevelStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_frame_zoom_level.table, test_index);
        testdata.iface_g_mozilla_engine_get_frame_zoom_level.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        guint retvalue;
        if(testdata.basics) {
            retvalue = iface->get_frame_zoom_level((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            guint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_frame_zoom_level((GWebEngine*)self);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_image_properties(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_image_properties");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_image_properties.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetImagePropertiesStruct* test_item_data =
            (IfaceGMozillaEngineGetImagePropertiesStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_image_properties.table, test_index);
        testdata.iface_g_mozilla_engine_get_image_properties.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        const gchar* url = test_item_data->url;
        gchar* test_file_type_variable = test_item_data->test_file_type_variable;
        gchar** file_type = test_item_data->file_type;
        guint test_file_size_variable = test_item_data->test_file_size_variable;
        guint* file_size = test_item_data->file_size;
        guint test_width_variable = test_item_data->test_width_variable;
        guint* width = test_item_data->width;
        guint test_height_variable = test_item_data->test_height_variable;
        guint* height = test_item_data->height;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->get_image_properties((GWebEngine*)self, url, file_type,
                    file_size, width, height);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_image_properties((GWebEngine*)self, url, file_type,
                    file_size, width, height);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_frame_properties(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_frame_properties");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_frame_properties.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetFramePropertiesStruct* test_item_data =
            (IfaceGMozillaEngineGetFramePropertiesStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_frame_properties.table, test_index);
        testdata.iface_g_mozilla_engine_get_frame_properties.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gchar* test_file_type_variable = test_item_data->test_file_type_variable;
        gchar** file_type = test_item_data->file_type;
        guint *file_size = test_item_data->file_size;
        GWebEngineEncoding* file_encoding = test_item_data->file_encoding;
        guint* security = test_item_data->security;
        gboolean* automatic_encoding = test_item_data->automatic_encoding;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->get_frame_properties((GWebEngine*)self, file_type,
                    file_size, file_encoding, security, automatic_encoding);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_frame_properties((GWebEngine*)self, file_type,
                    file_size, file_encoding, security, automatic_encoding);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_load_image(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_load_image");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_load_image.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineLoadImageStruct* test_item_data =
            (IfaceGMozillaEngineLoadImageStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_load_image.table, test_index);
        testdata.iface_g_mozilla_engine_load_image.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        const gchar* url = test_item_data->url;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->load_image((GWebEngine*)self, url);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->load_image((GWebEngine*)self, url);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_back_window_history_list(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_back_window_history_list");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_back_window_history_list.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetBackWindowHistoryListStruct* test_item_data =
            (IfaceGMozillaEngineGetBackWindowHistoryListStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_back_window_history_list.table, test_index);
        testdata.iface_g_mozilla_engine_get_back_window_history_list.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        GObject **history = test_item_data->history;
        gint retvalue;
        if(testdata.basics) {
            retvalue = iface->get_back_window_history_list((GWebEngine*)self, (GWebHistoryList**)history);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_back_window_history_list((GWebEngine*)self, (GWebHistoryList**)history);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_forward_window_history_list(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_forward_window_history_list");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_forward_window_history_list.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetForwardWindowHistoryListStruct* test_item_data =
            (IfaceGMozillaEngineGetForwardWindowHistoryListStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_forward_window_history_list.table, test_index);
        testdata.iface_g_mozilla_engine_get_forward_window_history_list.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        GObject **history = test_item_data->history;
        gint retvalue;
        if(testdata.basics) {
            retvalue = iface->get_forward_window_history_list((GWebEngine*)self, (GWebHistoryList**)history);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_forward_window_history_list((GWebEngine*)self, (GWebHistoryList**)history);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_set_layout_mode(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_set_layout_mode");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_set_layout_mode.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineSetLayoutModeStruct* test_item_data =
            (IfaceGMozillaEngineSetLayoutModeStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_set_layout_mode.table, test_index);
        testdata.iface_g_mozilla_engine_set_layout_mode.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebEngineLayoutMode mode = test_item_data->mode;
        if(testdata.basics) {
            iface->set_layout_mode((GWebEngine*)self, mode);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->set_layout_mode((GWebEngine*)self, mode);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_layout_mode(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_layout_mode");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_layout_mode.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetLayoutModeStruct* test_item_data =
            (IfaceGMozillaEngineGetLayoutModeStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_layout_mode.table, test_index);
        testdata.iface_g_mozilla_engine_get_layout_mode.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebEngineLayoutMode retvalue;
        if(testdata.basics) {
            retvalue = iface->get_layout_mode((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebEngineLayoutMode expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_layout_mode((GWebEngine*)self);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_set_load_images(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_set_load_images");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_set_load_images.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineSetLoadImagesStruct* test_item_data =
            (IfaceGMozillaEngineSetLoadImagesStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_set_load_images.table, test_index);
        testdata.iface_g_mozilla_engine_set_load_images.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebEngineImagePolicy level = test_item_data->level;
        if(testdata.basics) {
            iface->set_load_images((GWebEngine*)self, level);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->set_load_images((GWebEngine*)self, level);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_load_images(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_load_images");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_load_images.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetLoadImagesStruct* test_item_data =
            (IfaceGMozillaEngineGetLoadImagesStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_load_images.table, test_index);
        testdata.iface_g_mozilla_engine_get_load_images.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebEngineImagePolicy retvalue;
        if(testdata.basics) {
            retvalue = iface->get_load_images((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebEngineImagePolicy expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_load_images((GWebEngine*)self);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_set_frame_stacking(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_set_frame_stacking");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_set_frame_stacking.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineSetFrameStackingStruct* test_item_data =
            (IfaceGMozillaEngineSetFrameStackingStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_set_frame_stacking.table, test_index);
        testdata.iface_g_mozilla_engine_set_frame_stacking.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gboolean enabled = test_item_data->enabled;
        if(testdata.basics) {
            iface->set_frame_stacking((GWebEngine*)self, enabled);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->set_frame_stacking((GWebEngine*)self, enabled);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_frame_stacking(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_frame_stacking");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_frame_stacking.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetFrameStackingStruct* test_item_data =
            (IfaceGMozillaEngineGetFrameStackingStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_frame_stacking.table, test_index);
        testdata.iface_g_mozilla_engine_get_frame_stacking.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = iface->get_frame_stacking((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_frame_stacking((GWebEngine*)self);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_save_web_page(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_save_web_page");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_save_web_page.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineSaveWebPageStruct* test_item_data =
            (IfaceGMozillaEngineSaveWebPageStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_save_web_page.table, test_index);
        testdata.iface_g_mozilla_engine_save_web_page.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebEngineSaveAction setting = test_item_data->setting;
        const gchar* file_name_with_path = test_item_data->file_name_with_path;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->save_web_page((GWebEngine*)self, setting, file_name_with_path);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->save_web_page((GWebEngine*)self, setting, file_name_with_path);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_save_current_frame(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_save_current_frame");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_save_current_frame.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineSaveCurrentFrameStruct* test_item_data =
            (IfaceGMozillaEngineSaveCurrentFrameStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_save_current_frame.table, test_index);
        testdata.iface_g_mozilla_engine_save_current_frame.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        GWebEngineSaveAction setting = test_item_data->setting;
        const gchar* file_name_with_path = test_item_data->file_name_with_path;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = iface->save_current_frame((GWebEngine*)self, setting, file_name_with_path);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->save_current_frame((GWebEngine*)self, setting, file_name_with_path);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_frame_title(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_frame_title");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_frame_title.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetFrameTitleStruct* test_item_data =
            (IfaceGMozillaEngineGetFrameTitleStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_frame_title.table, test_index);
        testdata.iface_g_mozilla_engine_get_frame_title.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gint frame_number = test_item_data->frame_number;
        const gchar* retvalue;
        if(testdata.basics) {
            retvalue = iface->get_frame_title((GWebEngine*)self, frame_number);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            const gchar* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_frame_title((GWebEngine*)self, frame_number);
            TESTS_ASSERT_STRING_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_element_details(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_element_details");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_element_details.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetElementDetailsStruct* test_item_data =
            (IfaceGMozillaEngineGetElementDetailsStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_element_details.table, test_index);
        testdata.iface_g_mozilla_engine_get_element_details.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gint type = test_item_data->type;
        gchar* retvalue;
        if(testdata.basics) {
            retvalue = iface->get_element_details((GWebEngine*)self, type);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gchar* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_element_details((GWebEngine*)self, type);
            TESTS_ASSERT_STRING_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case for interface function.
 */
void test_iface_g_mozilla_engine_get_frame_number(void)
{

    DEBUG_FUNCTIONS_STARTED("test_iface_g_mozilla_engine_get_frame_number");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_engine_get_frame_number.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaEngineGetFrameNumberStruct* test_item_data =
            (IfaceGMozillaEngineGetFrameNumberStruct*)g_list_nth_data(testdata.iface_g_mozilla_engine_get_frame_number.table, test_index);
        testdata.iface_g_mozilla_engine_get_frame_number.index++;

        GMozillaEngine* self = NULL;
        if(test_item_data->test_self_pp)
        {
            self = *test_item_data->test_self_pp;
        }
        else
        {
            self = test_item_data->self;
        }
        GWebEngineIface* iface = test_item_data->test_iface;
        gint retvalue;
        if(testdata.basics) {
            retvalue = iface->get_frame_number((GWebEngine*)self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_frame_number((GWebEngine*)self);
            TESTS_ASSERT_INT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}







/**
 * Init function created by test creation script. It is success always.
 */


static int
testgmozillaengine_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaengine_automatic_init");
    
    //init_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaengine_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaengine_automatic_clean");
    
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillaengine_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaengine_basics_init");
    
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;

    ContentSetCursorStruct* tmp_content_set_cursor = g_new0(ContentSetCursorStruct, 1);
    /* GMozillaEngine** */tmp_content_set_cursor->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_content_set_cursor->self = NULL;
    /* GdkCursorType */tmp_content_set_cursor->type = 0;
    /* gboolean */tmp_content_set_cursor->expected_retvalue = FALSE;
    testdata.content_set_cursor.table = g_list_append (testdata.content_set_cursor.table, tmp_content_set_cursor);
    testdata.content_set_cursor.index = 0;

    DomMouseDownCbStruct* tmp_dom_mouse_down_cb = g_new0(DomMouseDownCbStruct, 1);
    /* GtkMozEmbed* */tmp_dom_mouse_down_cb->embed = NULL;
    /* void* */tmp_dom_mouse_down_cb->event = NULL;
    /* GMozillaEngine** */tmp_dom_mouse_down_cb->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_dom_mouse_down_cb->self = NULL;
    /* gint */tmp_dom_mouse_down_cb->expected_retvalue = 0;
    testdata.dom_mouse_down_cb.table = g_list_append (testdata.dom_mouse_down_cb.table, tmp_dom_mouse_down_cb);
    testdata.dom_mouse_down_cb.index = 0;

    DomMouseLongPressCbStruct* tmp_dom_mouse_long_press_cb = g_new0(DomMouseLongPressCbStruct, 1);
    /* GtkMozEmbed* */tmp_dom_mouse_long_press_cb->embed = NULL;
    /* void* */tmp_dom_mouse_long_press_cb->event = NULL;
    /* GMozillaEngine** */tmp_dom_mouse_long_press_cb->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_dom_mouse_long_press_cb->self = NULL;
    /* gint */tmp_dom_mouse_long_press_cb->expected_retvalue = 0;
    testdata.dom_mouse_long_press_cb.table = g_list_append (testdata.dom_mouse_long_press_cb.table, tmp_dom_mouse_long_press_cb);
    testdata.dom_mouse_long_press_cb.index = 0;

    GMozEalImContextCommitStruct* tmp_g_moz_eal_im_context_commit = g_new0(GMozEalImContextCommitStruct, 1);
    /* GtkIMContext* */tmp_g_moz_eal_im_context_commit->ctx = NULL;
    /* const gchar* */tmp_g_moz_eal_im_context_commit->str = NULL;
    /* GMozillaEngine** */tmp_g_moz_eal_im_context_commit->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_moz_eal_im_context_commit->self = NULL;
    /* gboolean */tmp_g_moz_eal_im_context_commit->expected_retvalue = FALSE;
    testdata.g_moz_eal_im_context_commit.table = g_list_append (testdata.g_moz_eal_im_context_commit.table, tmp_g_moz_eal_im_context_commit);
    testdata.g_moz_eal_im_context_commit.index = 0;

    GMozEalImContextDeleteSurroundingStruct* tmp_g_moz_eal_im_context_delete_surrounding = g_new0(GMozEalImContextDeleteSurroundingStruct, 1);
    /* GtkIMContext* */tmp_g_moz_eal_im_context_delete_surrounding->aContext = NULL;
    /* gint */tmp_g_moz_eal_im_context_delete_surrounding->arg1 = 0;
    /* gint */tmp_g_moz_eal_im_context_delete_surrounding->arg2 = 0;
    /* GMozillaEngine** */tmp_g_moz_eal_im_context_delete_surrounding->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_moz_eal_im_context_delete_surrounding->self = NULL;
    /* gboolean */tmp_g_moz_eal_im_context_delete_surrounding->expected_retvalue = FALSE;
    testdata.g_moz_eal_im_context_delete_surrounding.table = g_list_append (testdata.g_moz_eal_im_context_delete_surrounding.table, tmp_g_moz_eal_im_context_delete_surrounding);
    testdata.g_moz_eal_im_context_delete_surrounding.index = 0;

    GMozEalImContextHasSelectionStruct* tmp_g_moz_eal_im_context_has_selection = g_new0(GMozEalImContextHasSelectionStruct, 1);
    /* GtkIMContext* */tmp_g_moz_eal_im_context_has_selection->context = NULL;
    /* GMozillaEngine** */tmp_g_moz_eal_im_context_has_selection->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_moz_eal_im_context_has_selection->self = NULL;
    /* gboolean */tmp_g_moz_eal_im_context_has_selection->expected_retvalue = FALSE;
    testdata.g_moz_eal_im_context_has_selection.table = g_list_append (testdata.g_moz_eal_im_context_has_selection.table, tmp_g_moz_eal_im_context_has_selection);
    testdata.g_moz_eal_im_context_has_selection.index = 0;

    GMozEalImContextRetrieveSurroundingStruct* tmp_g_moz_eal_im_context_retrieve_surrounding = g_new0(GMozEalImContextRetrieveSurroundingStruct, 1);
    /* GtkIMContext* */tmp_g_moz_eal_im_context_retrieve_surrounding->aContext = NULL;
    /* GMozillaEngine** */tmp_g_moz_eal_im_context_retrieve_surrounding->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_moz_eal_im_context_retrieve_surrounding->self = NULL;
    /* gboolean */tmp_g_moz_eal_im_context_retrieve_surrounding->expected_retvalue = FALSE;
    testdata.g_moz_eal_im_context_retrieve_surrounding.table = g_list_append (testdata.g_moz_eal_im_context_retrieve_surrounding.table, tmp_g_moz_eal_im_context_retrieve_surrounding);
    testdata.g_moz_eal_im_context_retrieve_surrounding.index = 0;

    GMozEalPreeditChangedCbStruct* tmp_g_moz_eal_preedit_changed_cb = g_new0(GMozEalPreeditChangedCbStruct, 1);
    /* GtkIMContext* */tmp_g_moz_eal_preedit_changed_cb->aContext = NULL;
    /* GMozillaEngine** */tmp_g_moz_eal_preedit_changed_cb->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_moz_eal_preedit_changed_cb->self = NULL;
    testdata.g_moz_eal_preedit_changed_cb.table = g_list_append (testdata.g_moz_eal_preedit_changed_cb.table, tmp_g_moz_eal_preedit_changed_cb);
    testdata.g_moz_eal_preedit_changed_cb.index = 0;

    GMozillaAddNotificationButtonStruct* tmp_g_mozilla_add_notification_button = g_new0(GMozillaAddNotificationButtonStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_add_notification_button->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_add_notification_button->self = NULL;
    /* gpointer* */tmp_g_mozilla_add_notification_button->test_notification_widget_pp = NULL;
    /* gpointer */tmp_g_mozilla_add_notification_button->notification_widget = NULL;
    /* gpointer */tmp_g_mozilla_add_notification_button->notification = NULL;
    /* gpointer */tmp_g_mozilla_add_notification_button->notification_button = NULL;
    /* gchar* */tmp_g_mozilla_add_notification_button->label = NULL;
    testdata.g_mozilla_add_notification_button.table = g_list_append (testdata.g_mozilla_add_notification_button.table, tmp_g_mozilla_add_notification_button);
    testdata.g_mozilla_add_notification_button.index = 0;

    GMozillaAppendNotificationStruct* tmp_g_mozilla_append_notification = g_new0(GMozillaAppendNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_append_notification->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_append_notification->self = NULL;
    /* const gchar* */tmp_g_mozilla_append_notification->notification_label = NULL;
    /* gpointer */tmp_g_mozilla_append_notification->notification = NULL;
    /* gboolean */tmp_g_mozilla_append_notification->test_is_retvalue_expected = FALSE;
    /* gpointer */tmp_g_mozilla_append_notification->retvalue = NULL;
    testdata.g_mozilla_append_notification.table = g_list_append (testdata.g_mozilla_append_notification.table, tmp_g_mozilla_append_notification);
    testdata.g_mozilla_append_notification.index = 0;

    GMozillaEngineAlertStruct* tmp_g_mozilla_engine_alert = g_new0(GMozillaEngineAlertStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_alert->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_alert->self = NULL;
    /* const gchar* */tmp_g_mozilla_engine_alert->dialog_title = NULL;
    /* const gchar* */tmp_g_mozilla_engine_alert->alert_msg = NULL;
    /* gboolean */tmp_g_mozilla_engine_alert->is_blocking = FALSE;
    /* const char* */tmp_g_mozilla_engine_alert->check_msg = NULL;
    /* gboolean* */tmp_g_mozilla_engine_alert->check_val = NULL;
    /* gint */tmp_g_mozilla_engine_alert->expected_retvalue = 0;
    testdata.g_mozilla_engine_alert.table = g_list_append (testdata.g_mozilla_engine_alert.table, tmp_g_mozilla_engine_alert);
    testdata.g_mozilla_engine_alert.index = 0;

    GMozillaEngineConfirmStruct* tmp_g_mozilla_engine_confirm = g_new0(GMozillaEngineConfirmStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_confirm->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_confirm->self = NULL;
    /* const gchar* */tmp_g_mozilla_engine_confirm->dialog_title = NULL;
    /* const gchar* */tmp_g_mozilla_engine_confirm->dialog_msg = NULL;
    /* const char* */tmp_g_mozilla_engine_confirm->check_msg = NULL;
    /* gboolean* */tmp_g_mozilla_engine_confirm->check_val = NULL;
    /* gboolean */tmp_g_mozilla_engine_confirm->expected_retvalue = FALSE;
    testdata.g_mozilla_engine_confirm.table = g_list_append (testdata.g_mozilla_engine_confirm.table, tmp_g_mozilla_engine_confirm);
    testdata.g_mozilla_engine_confirm.index = 0;

    GMozillaEngineGetEncodingStruct* tmp_g_mozilla_engine_get_encoding = g_new0(GMozillaEngineGetEncodingStruct, 1);
    /* GtkMozEmbed* */tmp_g_mozilla_engine_get_encoding->embed = NULL;
    /* GWebEngineEncoding */tmp_g_mozilla_engine_get_encoding->expected_retvalue = 0;
    testdata.g_mozilla_engine_get_encoding.table = g_list_append (testdata.g_mozilla_engine_get_encoding.table, tmp_g_mozilla_engine_get_encoding);
    testdata.g_mozilla_engine_get_encoding.index = 0;

    GMozillaEngineGetPageVerifierNameStruct* tmp_g_mozilla_engine_get_page_verifier_name = g_new0(GMozillaEngineGetPageVerifierNameStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_get_page_verifier_name->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_get_page_verifier_name->self = NULL;
    /* gchar* */tmp_g_mozilla_engine_get_page_verifier_name->expected_retvalue = NULL;
    testdata.g_mozilla_engine_get_page_verifier_name.table = g_list_append (testdata.g_mozilla_engine_get_page_verifier_name.table, tmp_g_mozilla_engine_get_page_verifier_name);
    testdata.g_mozilla_engine_get_page_verifier_name.index = 0;

    GMozillaEngineGetServerCertificateStruct* tmp_g_mozilla_engine_get_server_certificate = g_new0(GMozillaEngineGetServerCertificateStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_get_server_certificate->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_get_server_certificate->self = NULL;
    /* gpointer */tmp_g_mozilla_engine_get_server_certificate->context = NULL;
    /* GArray* */tmp_g_mozilla_engine_get_server_certificate->expected_retvalue = NULL;

    GMozillaEngineGetTypeStruct* tmp_g_mozilla_engine_get_type = g_new0(GMozillaEngineGetTypeStruct, 1);
    /* GType */tmp_g_mozilla_engine_get_type->expected_retvalue = 0;
    testdata.g_mozilla_engine_get_type.table = g_list_append (testdata.g_mozilla_engine_get_type.table, tmp_g_mozilla_engine_get_type);
    testdata.g_mozilla_engine_get_type.index = 0;

    GMozillaEngineGetZoomLevelStruct* tmp_g_mozilla_engine_get_zoom_level = g_new0(GMozillaEngineGetZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_get_zoom_level->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_get_zoom_level->self = NULL;
    /* guint */tmp_g_mozilla_engine_get_zoom_level->expected_retvalue = 0;
    testdata.g_mozilla_engine_get_zoom_level.table = g_list_append (testdata.g_mozilla_engine_get_zoom_level.table, tmp_g_mozilla_engine_get_zoom_level);
    testdata.g_mozilla_engine_get_zoom_level.index = 0;

    GMozillaEngineNewStruct* tmp_g_mozilla_engine_new = g_new0(GMozillaEngineNewStruct, 1);
    /* gboolean */tmp_g_mozilla_engine_new->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_engine_new->retvalue = NULL;
    testdata.g_mozilla_engine_new.table = g_list_append (testdata.g_mozilla_engine_new.table, tmp_g_mozilla_engine_new);
    testdata.g_mozilla_engine_new.index = 0;

    GMozillaEngineNewWithContextStruct* tmp_g_mozilla_engine_new_with_context = g_new0(GMozillaEngineNewWithContextStruct, 1);
    /* GtkMozEmbed* */tmp_g_mozilla_engine_new_with_context->test_context_variable = NULL;
    /* gpointer */tmp_g_mozilla_engine_new_with_context->context = NULL;
    /* gboolean */tmp_g_mozilla_engine_new_with_context->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_engine_new_with_context->retvalue = NULL;
    testdata.g_mozilla_engine_new_with_context.table = g_list_append (testdata.g_mozilla_engine_new_with_context.table, tmp_g_mozilla_engine_new_with_context);
    testdata.g_mozilla_engine_new_with_context.index = 0;

    GMozillaEngineNewWithContextAndTracksStruct* tmp_g_mozilla_engine_new_with_context_and_tracks = g_new0(GMozillaEngineNewWithContextAndTracksStruct, 1);
    /* GtkMozEmbed* */tmp_g_mozilla_engine_new_with_context_and_tracks->test_context_variable = NULL;
    /* gpointer */tmp_g_mozilla_engine_new_with_context_and_tracks->context = NULL;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->leave_tracks = FALSE;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->without_history = FALSE;
    /* guint32 */tmp_g_mozilla_engine_new_with_context_and_tracks->flags = 0;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_engine_new_with_context_and_tracks->retvalue = NULL;
    testdata.g_mozilla_engine_new_with_context_and_tracks.table = g_list_append (testdata.g_mozilla_engine_new_with_context_and_tracks.table, tmp_g_mozilla_engine_new_with_context_and_tracks);
    testdata.g_mozilla_engine_new_with_context_and_tracks.index = 0;

    GMozillaRemoveNotificationStruct* tmp_g_mozilla_remove_notification = g_new0(GMozillaRemoveNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_remove_notification->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_remove_notification->self = NULL;
    /* gpointer */tmp_g_mozilla_remove_notification->notification_widget = NULL;
    testdata.g_mozilla_remove_notification.table = g_list_append (testdata.g_mozilla_remove_notification.table, tmp_g_mozilla_remove_notification);
    testdata.g_mozilla_remove_notification.index = 0;

    GMozillaShowNotificationStruct* tmp_g_mozilla_show_notification = g_new0(GMozillaShowNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_show_notification->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_show_notification->self = NULL;
    /* gpointer */tmp_g_mozilla_show_notification->notification_widget = NULL;
    /* gpointer */tmp_g_mozilla_show_notification->notification = NULL;
    testdata.g_mozilla_show_notification.table = g_list_append (testdata.g_mozilla_show_notification.table, tmp_g_mozilla_show_notification);
    testdata.g_mozilla_show_notification.index = 0;

    CtxMozembedToEalStruct* tmp_ctx_mozembed_to_eal = g_new0(CtxMozembedToEalStruct, 1);
    /* guint */tmp_ctx_mozembed_to_eal->moz_embed_ctx = 0;
    /* guint  */tmp_ctx_mozembed_to_eal->expected_retvalue = 0;
    testdata.ctx_mozembed_to_eal.table = g_list_append (testdata.ctx_mozembed_to_eal.table, tmp_ctx_mozembed_to_eal);
    testdata.ctx_mozembed_to_eal.index = 0;

    GMozillaCreateSelectNotificationStruct* tmp_g_mozilla_create_select_notification = g_new0(GMozillaCreateSelectNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_create_select_notification->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_create_select_notification->self = NULL;
    /* GSList* */tmp_g_mozilla_create_select_notification->list = NULL;
    /* gpointer */tmp_g_mozilla_create_select_notification->ctx_node = NULL;
    /* gboolean */ tmp_g_mozilla_create_select_notification->multiple = FALSE;
    /* gint* */ tmp_g_mozilla_create_select_notification->selected = 0;
    /* gint */ tmp_g_mozilla_create_select_notification->sel_count = 0;
    testdata.g_mozilla_create_select_notification.table = g_list_append (testdata.g_mozilla_create_select_notification.table, tmp_g_mozilla_create_select_notification);
    testdata.g_mozilla_create_select_notification.index = 0;

    GMozillaEnginePermitPageUnloadStruct* tmp_g_mozilla_engine_permit_page_unload = g_new0(GMozillaEnginePermitPageUnloadStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_permit_page_unload->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_permit_page_unload->self = NULL;
    /* glong */tmp_g_mozilla_engine_permit_page_unload->cur_time_sec = 0;
    /* glong */tmp_g_mozilla_engine_permit_page_unload->cur_time_usec = 0;
    /* glong */tmp_g_mozilla_engine_permit_page_unload->timeout_usec = 0;
    /* gboolean */tmp_g_mozilla_engine_permit_page_unload->expected_retvalue = FALSE;
    testdata.g_mozilla_engine_permit_page_unload.table = g_list_append (testdata.g_mozilla_engine_permit_page_unload.table, tmp_g_mozilla_engine_permit_page_unload);
    testdata.g_mozilla_engine_permit_page_unload.index = 0;

    GMozillaEngineSendMouseEventStruct* tmp_g_mozilla_engine_send_mouse_event = g_new0(GMozillaEngineSendMouseEventStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_send_mouse_event->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_send_mouse_event->self = NULL;
    /* int */tmp_g_mozilla_engine_send_mouse_event->type = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->x = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->y = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->mod = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->button = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->clickcount = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->time = 0;
    testdata.g_mozilla_engine_send_mouse_event.table = g_list_append (testdata.g_mozilla_engine_send_mouse_event.table, tmp_g_mozilla_engine_send_mouse_event);
    testdata.g_mozilla_engine_send_mouse_event.index = 0;

    GMozillaEngineUpdateAreaStruct* tmp_g_mozilla_engine_update_area = g_new0(GMozillaEngineUpdateAreaStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_update_area->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_update_area->self = NULL;
    /* int */tmp_g_mozilla_engine_update_area->id = 0;
    /* int */tmp_g_mozilla_engine_update_area->top = 0;
    /* int */tmp_g_mozilla_engine_update_area->left = 0;
    /* int */tmp_g_mozilla_engine_update_area->width = 0;
    /* int */tmp_g_mozilla_engine_update_area->height = 0;
    /* int */tmp_g_mozilla_engine_update_area->zoom = 0;
    testdata.g_mozilla_engine_update_area.table = g_list_append (testdata.g_mozilla_engine_update_area.table, tmp_g_mozilla_engine_update_area);
    testdata.g_mozilla_engine_update_area.index = 0;

    GMozillaEngineVisibleAreaStruct* tmp_g_mozilla_engine_visible_area = g_new0(GMozillaEngineVisibleAreaStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_visible_area->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_engine_visible_area->self = NULL;
    /* int */tmp_g_mozilla_engine_visible_area->vx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vy = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vw = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vh = 0;
    /* int */tmp_g_mozilla_engine_visible_area->tx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->ty = 0;
    /* int */tmp_g_mozilla_engine_visible_area->tw = 0;
    /* int */tmp_g_mozilla_engine_visible_area->th = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wy = 0;
    /* int */tmp_g_mozilla_engine_visible_area->ww = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wh = 0;
    testdata.g_mozilla_engine_visible_area.table = g_list_append (testdata.g_mozilla_engine_visible_area.table, tmp_g_mozilla_engine_visible_area);
    testdata.g_mozilla_engine_visible_area.index = 0;

    GMozillaSendNotificationStruct* tmp_g_mozilla_send_notification = g_new0(GMozillaSendNotificationStruct, 1);
    testdata.g_mozilla_send_notification.table = g_list_append (testdata.g_mozilla_send_notification.table, tmp_g_mozilla_send_notification);
    testdata.g_mozilla_send_notification.index = 0;



    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaengine_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaengine_basics_clean");
    
    testdata.basics = FALSE;
    

    
    return 0;
}

/**
 * Init function for testing function that are straight accessible with real values.
 */
static int
testgmozillaengine_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaengine_advanced_init");
    

    g_type_init();
    init_test_data();
    
    GMozillaEngine* self = (GMozillaEngine*)g_mozilla_engine_new_with_context_and_tracks(NULL, TRUE, FALSE, 0);
    END_INIT_WITH_MESSAGE_IF_FAIL(self, "Creating GMozillaEngine failed!");
    END_INIT_WITH_MESSAGE_IF_FAIL(self->engine, "Creating GMozEmbeded failed!");
    END_INIT_WITH_MESSAGE_IF_FAIL(self->notification_vbox, "Creating self.notification_vbox failed!");

    
    GMozillaEngineNewWithContextAndTracksStruct* tmp_g_mozilla_engine_new_with_context_and_tracks = g_new0(GMozillaEngineNewWithContextAndTracksStruct, 1);
    /* GtkMozEmbed* */tmp_g_mozilla_engine_new_with_context_and_tracks->test_context_variable = NULL;
    /* gpointer */tmp_g_mozilla_engine_new_with_context_and_tracks->context = &self->ctx;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->leave_tracks = TRUE;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->without_history = TRUE;
    /* guint32 */tmp_g_mozilla_engine_new_with_context_and_tracks->flags = 1;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_engine_new_with_context_and_tracks->retvalue = NULL;
    testdata.g_mozilla_engine_new_with_context_and_tracks.table = g_list_append (testdata.g_mozilla_engine_new_with_context_and_tracks.table, tmp_g_mozilla_engine_new_with_context_and_tracks);
    testdata.g_mozilla_engine_new_with_context_and_tracks.index = 0;

    tmp_g_mozilla_engine_new_with_context_and_tracks = g_new0(GMozillaEngineNewWithContextAndTracksStruct, 1);
    /* GtkMozEmbed* */tmp_g_mozilla_engine_new_with_context_and_tracks->test_context_variable = NULL;
    /* gpointer */tmp_g_mozilla_engine_new_with_context_and_tracks->context = &tmp_g_mozilla_engine_new_with_context_and_tracks->test_context_variable;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->leave_tracks = TRUE;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->without_history = TRUE;
    /* guint32 */tmp_g_mozilla_engine_new_with_context_and_tracks->flags = 0;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_engine_new_with_context_and_tracks->retvalue = NULL;
    testdata.g_mozilla_engine_new_with_context_and_tracks.table = g_list_append (testdata.g_mozilla_engine_new_with_context_and_tracks.table, tmp_g_mozilla_engine_new_with_context_and_tracks);
    testdata.g_mozilla_engine_new_with_context_and_tracks.index = 0;

    tmp_g_mozilla_engine_new_with_context_and_tracks = g_new0(GMozillaEngineNewWithContextAndTracksStruct, 1);
    /* GtkMozEmbed* */tmp_g_mozilla_engine_new_with_context_and_tracks->test_context_variable = NULL;
    /* gpointer */tmp_g_mozilla_engine_new_with_context_and_tracks->context = NULL;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->leave_tracks = TRUE;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->without_history = TRUE;
    /* guint32 */tmp_g_mozilla_engine_new_with_context_and_tracks->flags = 0;
    /* gboolean */tmp_g_mozilla_engine_new_with_context_and_tracks->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_engine_new_with_context_and_tracks->retvalue = NULL;
    testdata.g_mozilla_engine_new_with_context_and_tracks.table = g_list_append (testdata.g_mozilla_engine_new_with_context_and_tracks.table, tmp_g_mozilla_engine_new_with_context_and_tracks);
    testdata.g_mozilla_engine_new_with_context_and_tracks.index = 0;

    GMozillaEngineGetZoomLevelStruct* tmp_g_mozilla_engine_get_zoom_level = g_new0(GMozillaEngineGetZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_get_zoom_level->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_get_zoom_level->self = NULL;
    /* guint */tmp_g_mozilla_engine_get_zoom_level->expected_retvalue = 100;
    testdata.g_mozilla_engine_get_zoom_level.table = g_list_append (testdata.g_mozilla_engine_get_zoom_level.table, tmp_g_mozilla_engine_get_zoom_level);
    testdata.g_mozilla_engine_get_zoom_level.index = 0;

    GMozillaAppendNotificationStruct* tmp_g_mozilla_append_notification = g_new0(GMozillaAppendNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_append_notification->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_append_notification->self = NULL;
    /* const gchar* */tmp_g_mozilla_append_notification->notification_label = "notification_label";
    /* gpointer */tmp_g_mozilla_append_notification->notification = NULL;
    /* gboolean */tmp_g_mozilla_append_notification->test_is_retvalue_expected = TRUE;
    /* gpointer */tmp_g_mozilla_append_notification->retvalue = NULL;
    testdata.g_mozilla_append_notification.table = g_list_append (testdata.g_mozilla_append_notification.table, tmp_g_mozilla_append_notification);
    testdata.g_mozilla_append_notification.index = 0;

    GMozillaAddNotificationButtonStruct* tmp_g_mozilla_add_notification_button = g_new0(GMozillaAddNotificationButtonStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_add_notification_button->test_self_pp = NULL;
    /* GMozillaEngine* */tmp_g_mozilla_add_notification_button->self = NULL;
    /* gpointer* */tmp_g_mozilla_add_notification_button->test_notification_widget_pp = &tmp_g_mozilla_append_notification->retvalue;
    /* gpointer */tmp_g_mozilla_add_notification_button->notification_widget = NULL;
    /* gpointer */tmp_g_mozilla_add_notification_button->notification = NULL;
    /* gpointer */tmp_g_mozilla_add_notification_button->notification_button = (gpointer)gtk_button_new_with_label("notification_button");
    /* gchar* */tmp_g_mozilla_add_notification_button->label = "label";
    testdata.g_mozilla_add_notification_button.table = g_list_append (testdata.g_mozilla_add_notification_button.table, tmp_g_mozilla_add_notification_button);
    testdata.g_mozilla_add_notification_button.index = 0;

    GMozillaShowNotificationStruct* tmp_g_mozilla_show_notification = g_new0(GMozillaShowNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_show_notification->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_show_notification->self = NULL;
    /* gpointer */tmp_g_mozilla_show_notification->notification_widget = (gpointer)self->notification_vbox;
    /* gpointer */tmp_g_mozilla_show_notification->notification = (gpointer)tmp_g_mozilla_show_notification->notification_widget;
    testdata.g_mozilla_show_notification.table = g_list_append (testdata.g_mozilla_show_notification.table, tmp_g_mozilla_show_notification);
    testdata.g_mozilla_show_notification.index = 0;

    GMozillaRemoveNotificationStruct* tmp_g_mozilla_remove_notification = g_new0(GMozillaRemoveNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_remove_notification->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_remove_notification->self = NULL;
    /* gpointer */tmp_g_mozilla_remove_notification->notification_widget = (gpointer)tmp_g_mozilla_show_notification->notification_widget;
    testdata.g_mozilla_remove_notification.table = g_list_append (testdata.g_mozilla_remove_notification.table, tmp_g_mozilla_remove_notification);
    testdata.g_mozilla_remove_notification.index = 0;

    ContentSetCursorStruct* tmp_content_set_cursor = g_new0(ContentSetCursorStruct, 1);
    /* GMozillaEngine** */tmp_content_set_cursor->test_self_pp = &self;
    /* GMozillaEngine* */tmp_content_set_cursor->self = NULL;
    /* GdkCursorType */tmp_content_set_cursor->type = GDK_LEFT_PTR;
    /* gboolean */tmp_content_set_cursor->expected_retvalue = TRUE;
    testdata.content_set_cursor.table = g_list_append (testdata.content_set_cursor.table, tmp_content_set_cursor);
    testdata.content_set_cursor.index = 0;

    GMozillaEngineAlertStruct* tmp_g_mozilla_engine_alert = g_new0(GMozillaEngineAlertStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_alert->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_alert->self = NULL;
    /* const gchar* */tmp_g_mozilla_engine_alert->dialog_title = "Unknown Protocol";
    /* const gchar* */tmp_g_mozilla_engine_alert->alert_msg = "alert_msg";
    /* gboolean */tmp_g_mozilla_engine_alert->is_blocking = FALSE;
    /* const char* */tmp_g_mozilla_engine_alert->check_msg = NULL;
    /* gboolean* */tmp_g_mozilla_engine_alert->check_val = NULL;
    /* gint */tmp_g_mozilla_engine_alert->expected_retvalue = TRUE;
    testdata.g_mozilla_engine_alert.table = g_list_append (testdata.g_mozilla_engine_alert.table, tmp_g_mozilla_engine_alert);
    testdata.g_mozilla_engine_alert.index = 0;

    GMozillaEngineGetEncodingStruct* tmp_g_mozilla_engine_get_encoding = g_new0(GMozillaEngineGetEncodingStruct, 1);
    /* GtkMozEmbed* */tmp_g_mozilla_engine_get_encoding->embed = (GtkMozEmbed*)self->engine;
    /* GWebEngineEncoding */tmp_g_mozilla_engine_get_encoding->expected_retvalue = 0;
    testdata.g_mozilla_engine_get_encoding.table = g_list_append (testdata.g_mozilla_engine_get_encoding.table, tmp_g_mozilla_engine_get_encoding);
    testdata.g_mozilla_engine_get_encoding.index = 0;

    DomMouseDownCbStruct* tmp_dom_mouse_down_cb = g_new0(DomMouseDownCbStruct, 1);
    /* GtkMozEmbed* */tmp_dom_mouse_down_cb->embed = (GtkMozEmbed*)self->engine;
    /* void* */tmp_dom_mouse_down_cb->event = gdk_event_new(GDK_NOTHING);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_dom_mouse_down_cb->event, "Creating tmp_dom_mouse_down_cb.event failed!");
    /* GMozillaEngine** */tmp_dom_mouse_down_cb->test_self_pp = &self;
    /* GMozillaEngine* */tmp_dom_mouse_down_cb->self = NULL;
    /* gint */tmp_dom_mouse_down_cb->expected_retvalue = 0;
    testdata.dom_mouse_down_cb.table = g_list_append (testdata.dom_mouse_down_cb.table, tmp_dom_mouse_down_cb);
    testdata.dom_mouse_down_cb.index = 0;

    DomMouseLongPressCbStruct* tmp_dom_mouse_long_press_cb = g_new0(DomMouseLongPressCbStruct, 1);
    /* GtkMozEmbed* */tmp_dom_mouse_long_press_cb->embed = (GtkMozEmbed*)self->engine;
    /* void* */tmp_dom_mouse_long_press_cb->event = gdk_event_new(GDK_NOTHING);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_dom_mouse_long_press_cb->event, "Creating tmp_dom_mouse_long_press_cb.event failed!");
    /* GMozillaEngine** */tmp_dom_mouse_long_press_cb->test_self_pp = &self;
    /* GMozillaEngine* */tmp_dom_mouse_long_press_cb->self = NULL;
    /* gint */tmp_dom_mouse_long_press_cb->expected_retvalue = 0;
    testdata.dom_mouse_long_press_cb.table = g_list_append (testdata.dom_mouse_long_press_cb.table, tmp_dom_mouse_long_press_cb);
    testdata.dom_mouse_long_press_cb.index = 0;

    GMozillaEngineConfirmStruct* tmp_g_mozilla_engine_confirm = g_new0(GMozillaEngineConfirmStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_confirm->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_confirm->self = NULL;
    /* const gchar* */tmp_g_mozilla_engine_confirm->dialog_title = NULL;
    /* const gchar* */tmp_g_mozilla_engine_confirm->dialog_msg = "dialog_msg";
    /* const char* */tmp_g_mozilla_engine_confirm->check_msg = NULL;
    /* gboolean* */tmp_g_mozilla_engine_confirm->check_val = NULL;
    /* gboolean */tmp_g_mozilla_engine_confirm->expected_retvalue = FALSE;
    testdata.g_mozilla_engine_confirm.table = g_list_append (testdata.g_mozilla_engine_confirm.table, tmp_g_mozilla_engine_confirm);
    testdata.g_mozilla_engine_confirm.index = 0;

    CtxMozembedToEalStruct* tmp_ctx_mozembed_to_eal = g_new0(CtxMozembedToEalStruct, 1);
    //GTK_MICROB_EAL_CONTEXT_MULTILINE GTK_MICROB_EAL_CONTEXT_NONE GTK_MICROB_EAL_CONTEXT_XUL GTK_MICROB_EAL_CONTEXT_DOCUMENT GTK_MICROB_EAL_CONTEXT_LINK GTK_MICROB_EAL_CONTEXT_IMAGE GTK_MICROB_EAL_CONTEXT_IFRAME GTK_MICROB_EAL_CONTEXT_INPUT_TEXT GTK_MICROB_EAL_CONTEXT_IPASSWORD GTK_MICROB_EAL_CONTEXT_RICHEDIT GTK_MICROB_EAL_CONTEXT_MAILTO GTK_MICROB_EAL_CONTEXT_EMBED 
    /* guint */tmp_ctx_mozembed_to_eal->moz_embed_ctx |= GTK_MICROB_EAL_CONTEXT_MULTILINE | GTK_MICROB_EAL_CONTEXT_NONE | GTK_MICROB_EAL_CONTEXT_XUL | GTK_MICROB_EAL_CONTEXT_DOCUMENT | GTK_MICROB_EAL_CONTEXT_LINK | GTK_MICROB_EAL_CONTEXT_IMAGE | GTK_MICROB_EAL_CONTEXT_IFRAME | GTK_MICROB_EAL_CONTEXT_INPUT_TEXT | GTK_MICROB_EAL_CONTEXT_IPASSWORD | GTK_MICROB_EAL_CONTEXT_RICHEDIT | GTK_MICROB_EAL_CONTEXT_MAILTO | GTK_MICROB_EAL_CONTEXT_EMBED;
    /* guint  */tmp_ctx_mozembed_to_eal->expected_retvalue = 784;
    testdata.ctx_mozembed_to_eal.table = g_list_append (testdata.ctx_mozembed_to_eal.table, tmp_ctx_mozembed_to_eal);
    testdata.ctx_mozembed_to_eal.index = 0;

    GMozillaCreateSelectNotificationStruct* tmp_g_mozilla_create_select_notification = g_new0(GMozillaCreateSelectNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_create_select_notification->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_create_select_notification->self = NULL;
    GSList* list = NULL;
    list = g_slist_append(list, g_strdup("label1"));
    list = g_slist_append(list, g_strdup("label2"));
    list = g_slist_append(list, g_strdup("label3"));
    /* GSList* */tmp_g_mozilla_create_select_notification->list = list;
    /* gpointer */tmp_g_mozilla_create_select_notification->ctx_node = self->ctx_node;
    /* gboolean */ tmp_g_mozilla_create_select_notification->multiple = TRUE;
    gint* selected = g_new0(gint,2);
    selected[0] = 0;
    selected[1] = 2;
    /* gint* */ tmp_g_mozilla_create_select_notification->selected = selected;
    /* gint */ tmp_g_mozilla_create_select_notification->sel_count = 2;
    testdata.g_mozilla_create_select_notification.table = g_list_append (testdata.g_mozilla_create_select_notification.table, tmp_g_mozilla_create_select_notification);
    testdata.g_mozilla_create_select_notification.index = 0;

    tmp_g_mozilla_create_select_notification = g_new0(GMozillaCreateSelectNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_create_select_notification->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_create_select_notification->self = NULL;
    GSList* list2 = NULL;
    list2 = g_slist_append(list2, g_strdup("label1"));
    /* GSList* */tmp_g_mozilla_create_select_notification->list = list2;
    /* gpointer */tmp_g_mozilla_create_select_notification->ctx_node = self->ctx_node;
    /* gboolean */ tmp_g_mozilla_create_select_notification->multiple = FALSE;
    selected = g_new0(gint,1);
    selected[0] = 0;
    /* gint* */ tmp_g_mozilla_create_select_notification->selected = selected;
    /* gint */ tmp_g_mozilla_create_select_notification->sel_count = 1;
    testdata.g_mozilla_create_select_notification.table = g_list_append (testdata.g_mozilla_create_select_notification.table, tmp_g_mozilla_create_select_notification);
    testdata.g_mozilla_create_select_notification.index = 0;

    tmp_g_mozilla_create_select_notification = g_new0(GMozillaCreateSelectNotificationStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_create_select_notification->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_create_select_notification->self = NULL;
    GSList* list3 = NULL;
    gchar* null_label = NULL;
    list3 = g_slist_append(list3, null_label);
    /* GSList* */tmp_g_mozilla_create_select_notification->list = list3;
    /* gpointer */tmp_g_mozilla_create_select_notification->ctx_node = self->ctx_node;
    /* gboolean */ tmp_g_mozilla_create_select_notification->multiple = FALSE;
    /* gint* */ tmp_g_mozilla_create_select_notification->selected = NULL;
    /* gint */ tmp_g_mozilla_create_select_notification->sel_count = 0;
    testdata.g_mozilla_create_select_notification.table = g_list_append (testdata.g_mozilla_create_select_notification.table, tmp_g_mozilla_create_select_notification);
    testdata.g_mozilla_create_select_notification.index = 0;

    GMozillaEngineSendMouseEventStruct* tmp_g_mozilla_engine_send_mouse_event = g_new0(GMozillaEngineSendMouseEventStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_send_mouse_event->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_send_mouse_event->self = NULL;
    /* int */tmp_g_mozilla_engine_send_mouse_event->type = G_WEBENGINE_ACTIVE_STATUS;
    /* int */tmp_g_mozilla_engine_send_mouse_event->x = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->y = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->mod = FALSE;
    /* int */tmp_g_mozilla_engine_send_mouse_event->button = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->clickcount = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->time = 0;
    testdata.g_mozilla_engine_send_mouse_event.table = g_list_append (testdata.g_mozilla_engine_send_mouse_event.table, tmp_g_mozilla_engine_send_mouse_event);
    testdata.g_mozilla_engine_send_mouse_event.index = 0;

    tmp_g_mozilla_engine_send_mouse_event = g_new0(GMozillaEngineSendMouseEventStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_send_mouse_event->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_send_mouse_event->self = NULL;
    /* int */tmp_g_mozilla_engine_send_mouse_event->type = G_WEBENGINE_MOUSE_SCROLL;
    /* int */tmp_g_mozilla_engine_send_mouse_event->x = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->y = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->mod = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->button = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->clickcount = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->time = 0;
    testdata.g_mozilla_engine_send_mouse_event.table = g_list_append (testdata.g_mozilla_engine_send_mouse_event.table, tmp_g_mozilla_engine_send_mouse_event);
    testdata.g_mozilla_engine_send_mouse_event.index = 0;

    tmp_g_mozilla_engine_send_mouse_event = g_new0(GMozillaEngineSendMouseEventStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_send_mouse_event->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_send_mouse_event->self = NULL;
    /* int */tmp_g_mozilla_engine_send_mouse_event->type = G_WEBENGINE_ELEMENT_INFO;
    /* int */tmp_g_mozilla_engine_send_mouse_event->x = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->y = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->mod = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->button = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->clickcount = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->time = 0;
    testdata.g_mozilla_engine_send_mouse_event.table = g_list_append (testdata.g_mozilla_engine_send_mouse_event.table, tmp_g_mozilla_engine_send_mouse_event);
    testdata.g_mozilla_engine_send_mouse_event.index = 0;

    tmp_g_mozilla_engine_send_mouse_event = g_new0(GMozillaEngineSendMouseEventStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_send_mouse_event->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_send_mouse_event->self = NULL;
    /* int */tmp_g_mozilla_engine_send_mouse_event->type = G_WEBENGINE_MOUSE_CLICK;
    /* int */tmp_g_mozilla_engine_send_mouse_event->x = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->y = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->mod = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->button = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->clickcount = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->time = 0;
    testdata.g_mozilla_engine_send_mouse_event.table = g_list_append (testdata.g_mozilla_engine_send_mouse_event.table, tmp_g_mozilla_engine_send_mouse_event);
    testdata.g_mozilla_engine_send_mouse_event.index = 0;

    tmp_g_mozilla_engine_send_mouse_event = g_new0(GMozillaEngineSendMouseEventStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_send_mouse_event->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_send_mouse_event->self = NULL;
    /* int */tmp_g_mozilla_engine_send_mouse_event->type = G_WEBENGINE_MOUSE_LONG_PRESS;
    /* int */tmp_g_mozilla_engine_send_mouse_event->x = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->y = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->mod = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->button = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->clickcount = 0;
    /* int */tmp_g_mozilla_engine_send_mouse_event->time = 0;
    testdata.g_mozilla_engine_send_mouse_event.table = g_list_append (testdata.g_mozilla_engine_send_mouse_event.table, tmp_g_mozilla_engine_send_mouse_event);
    testdata.g_mozilla_engine_send_mouse_event.index = 0;

    GMozillaEngineUpdateAreaStruct* tmp_g_mozilla_engine_update_area = g_new0(GMozillaEngineUpdateAreaStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_update_area->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_update_area->self = NULL;
    /* int */tmp_g_mozilla_engine_update_area->id = 0;
    /* int */tmp_g_mozilla_engine_update_area->top = 0;
    /* int */tmp_g_mozilla_engine_update_area->left = 0;
    /* int */tmp_g_mozilla_engine_update_area->width = 0;
    /* int */tmp_g_mozilla_engine_update_area->height = 0;
    /* int */tmp_g_mozilla_engine_update_area->zoom = 100;
    testdata.g_mozilla_engine_update_area.table = g_list_append (testdata.g_mozilla_engine_update_area.table, tmp_g_mozilla_engine_update_area);
    testdata.g_mozilla_engine_update_area.index = 0;

    GMozillaEngineVisibleAreaStruct* tmp_g_mozilla_engine_visible_area = g_new0(GMozillaEngineVisibleAreaStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_visible_area->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_visible_area->self = NULL;
    /* int */tmp_g_mozilla_engine_visible_area->vx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vy = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vw = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vh = 0;
    /* int */tmp_g_mozilla_engine_visible_area->tx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->ty = 0;
    /* int */tmp_g_mozilla_engine_visible_area->tw = 0;
    /* int */tmp_g_mozilla_engine_visible_area->th = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wy = 0;
    /* int */tmp_g_mozilla_engine_visible_area->ww = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wh = 1;
    testdata.g_mozilla_engine_visible_area.table = g_list_append (testdata.g_mozilla_engine_visible_area.table, tmp_g_mozilla_engine_visible_area);
    testdata.g_mozilla_engine_visible_area.index = 0;

    tmp_g_mozilla_engine_visible_area = g_new0(GMozillaEngineVisibleAreaStruct, 1);
    /* GMozillaEngine** */tmp_g_mozilla_engine_visible_area->test_self_pp = &self;
    /* GMozillaEngine* */tmp_g_mozilla_engine_visible_area->self = NULL;
    /* int */tmp_g_mozilla_engine_visible_area->vx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vy = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vw = 0;
    /* int */tmp_g_mozilla_engine_visible_area->vh = 0;
    /* int */tmp_g_mozilla_engine_visible_area->tx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->ty = 0;
    /* int */tmp_g_mozilla_engine_visible_area->tw = 0;
    /* int */tmp_g_mozilla_engine_visible_area->th = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wx = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wy = 0;
    /* int */tmp_g_mozilla_engine_visible_area->ww = 0;
    /* int */tmp_g_mozilla_engine_visible_area->wh = 0;
    testdata.g_mozilla_engine_visible_area.table = g_list_append (testdata.g_mozilla_engine_visible_area.table, tmp_g_mozilla_engine_visible_area);
    testdata.g_mozilla_engine_visible_area.index = 0;


    
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaengine_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaengine_advanced_clean");
    
    return 0;
}

/**
 * Init function for testing function that are straight accessible with real values.
 */
static int
testgmozillaengine_interface_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaengine_interface_init");
    

    g_type_init();
    init_test_data();
    
    GObject* web = g_web_new();
    GMozillaEngine* self = (GMozillaEngine*)G_WEB_GET_CLASS(web)->new_web_engine_window_with_context (G_WEB(web), NULL, TRUE, FALSE);
    //GMozillaEngine* self = (GMozillaEngine*)g_mozilla_engine_new_with_context_and_tracks(NULL, TRUE, FALSE, 0);
    END_INIT_WITH_MESSAGE_IF_FAIL(self, "Creating GMozillaEngine failed!");
    END_INIT_WITH_MESSAGE_IF_FAIL(self->engine, "Creating GMozEmbeded failed!");
    END_INIT_WITH_MESSAGE_IF_FAIL(self->notification_vbox, "Creating self.notification_vbox failed!");

    printf("About to get interface.\n");
    GWebEngineIface* iface = g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (self)), G_TYPE_WEB_ENGINE);
    END_INIT_WITH_MESSAGE_IF_FAIL(self, "Getting interface for GMozillaEngine failed!");

    IfaceGMozillaEngineLoadUrlStruct* tmp_iface_g_mozilla_engine_load_url =
        g_new0(IfaceGMozillaEngineLoadUrlStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_load_url->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_load_url->self = NULL;
    /* gchar* */tmp_iface_g_mozilla_engine_load_url->url = "url";
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_load_url->test_iface = iface;
    testdata.iface_g_mozilla_engine_load_url.table =
        g_list_append (testdata.iface_g_mozilla_engine_load_url.table,
                tmp_iface_g_mozilla_engine_load_url);
    testdata.iface_g_mozilla_engine_load_url.index = 0;
    
    tmp_iface_g_mozilla_engine_load_url = g_new0(IfaceGMozillaEngineLoadUrlStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_load_url->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_load_url->self = NULL;
    /* gchar* */tmp_iface_g_mozilla_engine_load_url->url = "http://www.testurl.com";
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_load_url->test_iface = iface;
    testdata.iface_g_mozilla_engine_load_url.table =
        g_list_append (testdata.iface_g_mozilla_engine_load_url.table,
                tmp_iface_g_mozilla_engine_load_url);
    testdata.iface_g_mozilla_engine_load_url.index = 0;
    
    IfaceGMozillaEngineLoadFollowLinkStruct* tmp_iface_g_mozilla_engine_load_follow_link = 
        g_new0(IfaceGMozillaEngineLoadFollowLinkStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_load_follow_link->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_load_follow_link->self = NULL;
    /* gchar* */tmp_iface_g_mozilla_engine_load_follow_link->url = "url";
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_load_follow_link->test_iface = iface;
    /* GWebStatus* */tmp_iface_g_mozilla_engine_load_follow_link->expected_retvalue = G_WEB_STATUS_OK;
    testdata.iface_g_mozilla_engine_load_follow_link.table =
        g_list_append (testdata.iface_g_mozilla_engine_load_follow_link.table,
                tmp_iface_g_mozilla_engine_load_url);
    testdata.iface_g_mozilla_engine_load_follow_link.index = 0;
    
    IfaceGMozillaEngineLoadUrlWithCssStruct* tmp_iface_g_mozilla_engine_load_url_with_css = 
        g_new0(IfaceGMozillaEngineLoadUrlWithCssStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_load_url_with_css->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_load_url_with_css->self = NULL;
    /* gchar* */tmp_iface_g_mozilla_engine_load_url_with_css->url = "url";
    /* gchar* */tmp_iface_g_mozilla_engine_load_url_with_css->cssfile = "cssfile";
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_load_url_with_css->test_iface = iface;
    testdata.iface_g_mozilla_engine_load_url_with_css.table =
        g_list_append (testdata.iface_g_mozilla_engine_load_url_with_css.table,
                tmp_iface_g_mozilla_engine_load_url_with_css);
    testdata.iface_g_mozilla_engine_load_url_with_css.index = 0;
    
    IfaceGMozillaEngineLoadUrlWithJsStruct* tmp_iface_g_mozilla_engine_load_url_with_js = 
        g_new0(IfaceGMozillaEngineLoadUrlWithJsStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_load_url_with_js->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_load_url_with_js->self = NULL;
    /* gboolean */tmp_iface_g_mozilla_engine_load_url_with_js->enable = TRUE;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_load_url_with_js->test_iface = iface;
    testdata.iface_g_mozilla_engine_load_url_with_js.table =
        g_list_append (testdata.iface_g_mozilla_engine_load_url_with_js.table,
                tmp_iface_g_mozilla_engine_load_url);
    testdata.iface_g_mozilla_engine_load_url_with_js.index = 0;
    
    IfaceGMozillaEngineLoadHomePageStruct* tmp_iface_g_mozilla_engine_load_home_page = 
        g_new0(IfaceGMozillaEngineLoadHomePageStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_load_home_page->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_load_home_page->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_load_home_page->test_iface = iface;
    testdata.iface_g_mozilla_engine_load_home_page.table =
        g_list_append (testdata.iface_g_mozilla_engine_load_home_page.table,
                tmp_iface_g_mozilla_engine_load_home_page);
    testdata.iface_g_mozilla_engine_load_home_page.index = 0;
    
    IfaceGMozillaEngineStopLoadStruct* tmp_iface_g_mozilla_engine_stop_load = 
        g_new0(IfaceGMozillaEngineStopLoadStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_stop_load->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_stop_load->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_stop_load->test_iface = iface;
    testdata.iface_g_mozilla_engine_stop_load.table =
        g_list_append (testdata.iface_g_mozilla_engine_stop_load.table,
                tmp_iface_g_mozilla_engine_stop_load);
    testdata.iface_g_mozilla_engine_stop_load.index = 0;
    
    IfaceGMozillaEngineReloadStruct* tmp_iface_g_mozilla_engine_reload = 
        g_new0(IfaceGMozillaEngineReloadStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_reload->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_reload->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_reload->test_iface = iface;
    testdata.iface_g_mozilla_engine_reload.table =
        g_list_append (testdata.iface_g_mozilla_engine_reload.table,
                tmp_iface_g_mozilla_engine_reload);
    testdata.iface_g_mozilla_engine_reload.index = 0;
    
    IfaceGMozillaEngineGoBackStruct* tmp_iface_g_mozilla_engine_go_back = 
        g_new0(IfaceGMozillaEngineGoBackStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_go_back->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_go_back->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_go_back->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_go_back->nsteps = 1;
    testdata.iface_g_mozilla_engine_go_back.table =
        g_list_append (testdata.iface_g_mozilla_engine_go_back.table,
                tmp_iface_g_mozilla_engine_go_back);
    testdata.iface_g_mozilla_engine_go_back.index = 0;
    
    IfaceGMozillaEngineGoForwardStruct* tmp_iface_g_mozilla_engine_go_forward = 
        g_new0(IfaceGMozillaEngineGoForwardStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_go_forward->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_go_forward->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_go_forward->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_go_forward->nsteps = 1;
    testdata.iface_g_mozilla_engine_go_forward.table =
        g_list_append (testdata.iface_g_mozilla_engine_go_forward.table,
                tmp_iface_g_mozilla_engine_go_forward);
    testdata.iface_g_mozilla_engine_go_forward.index = 0;
    
    tmp_iface_g_mozilla_engine_go_back = 
        g_new0(IfaceGMozillaEngineGoBackStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_go_back->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_go_back->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_go_back->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_go_back->nsteps = 2;
    testdata.iface_g_mozilla_engine_go_back.table =
        g_list_append (testdata.iface_g_mozilla_engine_go_back.table,
                tmp_iface_g_mozilla_engine_go_back);
    testdata.iface_g_mozilla_engine_go_back.index = 0;
    
    tmp_iface_g_mozilla_engine_go_forward = 
        g_new0(IfaceGMozillaEngineGoForwardStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_go_forward->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_go_forward->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_go_forward->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_go_forward->nsteps = 2;
    testdata.iface_g_mozilla_engine_go_forward.table =
        g_list_append (testdata.iface_g_mozilla_engine_go_forward.table,
                tmp_iface_g_mozilla_engine_go_forward);
    testdata.iface_g_mozilla_engine_go_forward.index = 0;
    
    IfaceGMozillaEngineCanGoBackStruct* tmp_iface_g_mozilla_engine_can_go_back = 
        g_new0(IfaceGMozillaEngineCanGoBackStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_can_go_back->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_can_go_back->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_can_go_back->test_iface = iface;
    /* gboolean* */tmp_iface_g_mozilla_engine_can_go_back->expected_retvalue = FALSE;
    testdata.iface_g_mozilla_engine_can_go_back.table =
        g_list_append (testdata.iface_g_mozilla_engine_can_go_back.table,
                tmp_iface_g_mozilla_engine_can_go_back);
    testdata.iface_g_mozilla_engine_can_go_back.index = 0;
    
    IfaceGMozillaEngineCanGoForwardStruct* tmp_iface_g_mozilla_engine_can_go_forward = 
        g_new0(IfaceGMozillaEngineCanGoForwardStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_can_go_forward->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_can_go_forward->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_can_go_forward->test_iface = iface;
    /* gboolean* */tmp_iface_g_mozilla_engine_can_go_forward->expected_retvalue = FALSE;
    testdata.iface_g_mozilla_engine_can_go_forward.table =
        g_list_append (testdata.iface_g_mozilla_engine_can_go_forward.table,
                tmp_iface_g_mozilla_engine_can_go_forward);
    testdata.iface_g_mozilla_engine_can_go_forward.index = 0;
    
    IfaceGMozillaEngineSetZoomLevelStruct* tmp_iface_g_mozilla_engine_set_zoom_level =
        g_new0(IfaceGMozillaEngineSetZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_zoom_level->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_zoom_level->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_zoom_level->test_iface = iface;
    /* gint */tmp_iface_g_mozilla_engine_set_zoom_level->level = 90;
    testdata.iface_g_mozilla_engine_set_zoom_level.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_zoom_level.table,
                tmp_iface_g_mozilla_engine_set_zoom_level);
    testdata.iface_g_mozilla_engine_set_zoom_level.index = 0;
    
    tmp_iface_g_mozilla_engine_set_zoom_level =
        g_new0(IfaceGMozillaEngineSetZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_zoom_level->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_zoom_level->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_zoom_level->test_iface = iface;
    /* gint */tmp_iface_g_mozilla_engine_set_zoom_level->level = 90;
    testdata.iface_g_mozilla_engine_set_zoom_level.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_zoom_level.table,
                tmp_iface_g_mozilla_engine_set_zoom_level);
    testdata.iface_g_mozilla_engine_set_zoom_level.index = 0;
    
    tmp_iface_g_mozilla_engine_set_zoom_level =
        g_new0(IfaceGMozillaEngineSetZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_zoom_level->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_zoom_level->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_zoom_level->test_iface = iface;
    /* gint */tmp_iface_g_mozilla_engine_set_zoom_level->level = 100;
    testdata.iface_g_mozilla_engine_set_zoom_level.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_zoom_level.table,
                tmp_iface_g_mozilla_engine_set_zoom_level);
    testdata.iface_g_mozilla_engine_set_zoom_level.index = 0;
    
    IfaceGMozillaEngineSetZoomLevelAroundPointStruct* tmp_iface_g_mozilla_engine_set_zoom_level_around_point =
        g_new0(IfaceGMozillaEngineSetZoomLevelAroundPointStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_zoom_level_around_point->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_zoom_level_around_point->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_zoom_level_around_point->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_set_zoom_level_around_point->x = 0;
    /* guint */tmp_iface_g_mozilla_engine_set_zoom_level_around_point->y = 0;
    /* gint */tmp_iface_g_mozilla_engine_set_zoom_level_around_point->level = 100;
    /* GWebStatus */tmp_iface_g_mozilla_engine_set_zoom_level_around_point->expected_retvalue = G_WEB_STATUS_OK;
    testdata.iface_g_mozilla_engine_set_zoom_level_around_point.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_zoom_level_around_point.table,
                tmp_iface_g_mozilla_engine_set_zoom_level_around_point);
    testdata.iface_g_mozilla_engine_set_zoom_level_around_point.index = 0;
    
    IfaceGMozillaEngineCompareFramesZoomLevelStruct* tmp_iface_g_mozilla_engine_compare_frames_zoom_level =
        g_new0(IfaceGMozillaEngineCompareFramesZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->test_iface = iface;
    /* gboolean */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->test_equal_variable = FALSE;
    /* gboolean */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->equal =
        &tmp_iface_g_mozilla_engine_compare_frames_zoom_level->test_equal_variable;
    /* GWebStatus */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->expected_retvalue = G_WEB_STATUS_OK;
    testdata.iface_g_mozilla_engine_compare_frames_zoom_level.table =
        g_list_append (testdata.iface_g_mozilla_engine_compare_frames_zoom_level.table,
                tmp_iface_g_mozilla_engine_compare_frames_zoom_level);
    testdata.iface_g_mozilla_engine_compare_frames_zoom_level.index = 0;
    
    tmp_iface_g_mozilla_engine_compare_frames_zoom_level =
        g_new0(IfaceGMozillaEngineCompareFramesZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->test_iface = iface;
    /* gboolean */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->test_equal_variable = FALSE;
    /* gboolean */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->equal = NULL;
    /* GWebStatus */tmp_iface_g_mozilla_engine_compare_frames_zoom_level->expected_retvalue = G_WEB_STATUS_OK;
    testdata.iface_g_mozilla_engine_compare_frames_zoom_level.table =
        g_list_append (testdata.iface_g_mozilla_engine_compare_frames_zoom_level.table,
                tmp_iface_g_mozilla_engine_compare_frames_zoom_level);
    testdata.iface_g_mozilla_engine_compare_frames_zoom_level.index = 0;
    
    IfaceGMozillaEngineZoomByStepsStruct* tmp_iface_g_mozilla_engine_zoom_by_steps =
        g_new0(IfaceGMozillaEngineZoomByStepsStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_zoom_by_steps->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_zoom_by_steps->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_zoom_by_steps->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_zoom_by_steps->relative_zoom = 100;
    /* guint* */tmp_iface_g_mozilla_engine_zoom_by_steps->legal_zoom_value = NULL;
    testdata.iface_g_mozilla_engine_zoom_by_steps.table =
        g_list_append (testdata.iface_g_mozilla_engine_zoom_by_steps.table,
                tmp_iface_g_mozilla_engine_zoom_by_steps);
    testdata.iface_g_mozilla_engine_zoom_by_steps.index = 0;
    
    IfaceGMozillaEngineNewZoomByStepsStruct* tmp_iface_g_mozilla_engine_new_zoom_by_steps =
        g_new0(IfaceGMozillaEngineNewZoomByStepsStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_new_zoom_by_steps->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_new_zoom_by_steps->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_new_zoom_by_steps->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_new_zoom_by_steps->relative_zoom = 100;
    /* guint* */tmp_iface_g_mozilla_engine_new_zoom_by_steps->legal_zoom_value = NULL;
    testdata.iface_g_mozilla_engine_new_zoom_by_steps.table =
        g_list_append (testdata.iface_g_mozilla_engine_new_zoom_by_steps.table,
                tmp_iface_g_mozilla_engine_new_zoom_by_steps);
    testdata.iface_g_mozilla_engine_new_zoom_by_steps.index = 0;
    
    IfaceGMozillaEngineSetFrameZoomLevelStruct* tmp_iface_g_mozilla_engine_set_frame_zoom_level =
        g_new0(IfaceGMozillaEngineSetFrameZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_frame_zoom_level->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_frame_zoom_level->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_frame_zoom_level->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_set_frame_zoom_level->level = 100;
    testdata.iface_g_mozilla_engine_set_frame_zoom_level.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_frame_zoom_level.table,
                tmp_iface_g_mozilla_engine_set_frame_zoom_level);
    testdata.iface_g_mozilla_engine_set_frame_zoom_level.index = 0;
    
    IfaceGMozillaEngineGetFrameZoomLevelStruct* tmp_iface_g_mozilla_engine_get_frame_zoom_level =
        g_new0(IfaceGMozillaEngineGetFrameZoomLevelStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_frame_zoom_level->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_frame_zoom_level->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_frame_zoom_level->test_iface = iface;
    /* guint */tmp_iface_g_mozilla_engine_get_frame_zoom_level->expected_retvalue =
        tmp_iface_g_mozilla_engine_set_frame_zoom_level->level;
    testdata.iface_g_mozilla_engine_get_frame_zoom_level.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_frame_zoom_level.table,
                tmp_iface_g_mozilla_engine_get_frame_zoom_level);
    testdata.iface_g_mozilla_engine_get_frame_zoom_level.index = 0;
    
    IfaceGMozillaEngineGetImagePropertiesStruct* tmp_iface_g_mozilla_engine_get_image_properties =
        g_new0(IfaceGMozillaEngineGetImagePropertiesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_image_properties->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_image_properties->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_image_properties->test_iface = iface;
    /* const gchar*  */tmp_iface_g_mozilla_engine_get_image_properties->url = "url";
    /* gchar*  */tmp_iface_g_mozilla_engine_get_image_properties->test_file_type_variable = NULL;
    /* gchar**  */tmp_iface_g_mozilla_engine_get_image_properties->file_type =
        &tmp_iface_g_mozilla_engine_get_image_properties->test_file_type_variable;
    /* guint  */tmp_iface_g_mozilla_engine_get_image_properties->test_file_size_variable = 0;
    /* guint*  */tmp_iface_g_mozilla_engine_get_image_properties->file_size =
        &tmp_iface_g_mozilla_engine_get_image_properties->test_file_size_variable;
    /* guint  */tmp_iface_g_mozilla_engine_get_image_properties->test_width_variable = 0;
    /* guint*  */tmp_iface_g_mozilla_engine_get_image_properties->width = 
        &tmp_iface_g_mozilla_engine_get_image_properties->test_width_variable;
    /* guint  */tmp_iface_g_mozilla_engine_get_image_properties->test_height_variable = 0;
    /* guint*  */tmp_iface_g_mozilla_engine_get_image_properties->height = 
        &tmp_iface_g_mozilla_engine_get_image_properties->test_height_variable;
    /* GWebStatus */tmp_iface_g_mozilla_engine_get_image_properties->expected_retvalue = G_WEB_STATUS_OK;
    testdata.iface_g_mozilla_engine_get_image_properties.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_image_properties.table,
                tmp_iface_g_mozilla_engine_get_image_properties);
    testdata.iface_g_mozilla_engine_get_image_properties.index = 0;
    
    IfaceGMozillaEngineGetFramePropertiesStruct* tmp_iface_g_mozilla_engine_get_frame_properties =
        g_new0(IfaceGMozillaEngineGetFramePropertiesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_frame_properties->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_frame_properties->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_frame_properties->test_iface = iface;
    /* gchar*  */tmp_iface_g_mozilla_engine_get_frame_properties->test_file_type_variable = NULL;
    /* gchar**  */tmp_iface_g_mozilla_engine_get_frame_properties->file_type =
        &tmp_iface_g_mozilla_engine_get_frame_properties->test_file_type_variable;
    /* guint  */tmp_iface_g_mozilla_engine_get_frame_properties->test_file_size_variable = 0;
    /* guint*  */tmp_iface_g_mozilla_engine_get_frame_properties->file_size =
        &tmp_iface_g_mozilla_engine_get_frame_properties->test_file_size_variable;
    /* GWebEngineEncoding */tmp_iface_g_mozilla_engine_get_frame_properties->test_file_encoding_variable = 0;
    /* GWebEngineEncoding* */tmp_iface_g_mozilla_engine_get_frame_properties->file_encoding =
        &tmp_iface_g_mozilla_engine_get_frame_properties->test_file_encoding_variable;
    /* guint */tmp_iface_g_mozilla_engine_get_frame_properties->test_security_variable = 0;
    /* guint* */tmp_iface_g_mozilla_engine_get_frame_properties->security =
        &tmp_iface_g_mozilla_engine_get_frame_properties->test_security_variable;
    /* gboolean */tmp_iface_g_mozilla_engine_get_frame_properties->test_automatic_encoding_variable = FALSE;
    /* gboolean* */tmp_iface_g_mozilla_engine_get_frame_properties->automatic_encoding =
        &tmp_iface_g_mozilla_engine_get_frame_properties->test_automatic_encoding_variable;
    /* GWebStatus */tmp_iface_g_mozilla_engine_get_frame_properties->expected_retvalue = G_WEB_STATUS_OK;
    testdata.iface_g_mozilla_engine_get_frame_properties.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_frame_properties.table,
                tmp_iface_g_mozilla_engine_get_frame_properties);
    testdata.iface_g_mozilla_engine_get_frame_properties.index = 0;
    
    IfaceGMozillaEngineLoadImageStruct* tmp_iface_g_mozilla_engine_load_image =
        g_new0(IfaceGMozillaEngineLoadImageStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_load_image->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_load_image->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_load_image->test_iface = iface;
    /* const gchar* */tmp_iface_g_mozilla_engine_load_image->url = "url";
    /* GWebStatus */tmp_iface_g_mozilla_engine_load_image->expected_retvalue = G_WEB_ERR;
    testdata.iface_g_mozilla_engine_load_image.table =
        g_list_append (testdata.iface_g_mozilla_engine_load_image.table,
                tmp_iface_g_mozilla_engine_load_image);
    testdata.iface_g_mozilla_engine_load_image.index = 0;
    
    IfaceGMozillaEngineGetBackWindowHistoryListStruct* tmp_iface_g_mozilla_engine_get_back_window_history_list =
        g_new0(IfaceGMozillaEngineGetBackWindowHistoryListStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_back_window_history_list->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_back_window_history_list->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_back_window_history_list->test_iface = iface;
    /* GObject* history */tmp_iface_g_mozilla_engine_get_back_window_history_list->test_history_variable = NULL;
    /* GObject** history */tmp_iface_g_mozilla_engine_get_back_window_history_list->history =
        &tmp_iface_g_mozilla_engine_get_back_window_history_list->test_history_variable;
    /* gint */tmp_iface_g_mozilla_engine_get_back_window_history_list->expected_retvalue = 0;
    testdata.iface_g_mozilla_engine_get_back_window_history_list.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_back_window_history_list.table,
                tmp_iface_g_mozilla_engine_get_back_window_history_list);
    testdata.iface_g_mozilla_engine_get_back_window_history_list.index = 0;
    
    IfaceGMozillaEngineGetBackWindowHistoryListStruct* tmp_iface_g_mozilla_engine_get_forward_window_history_list =
        g_new0(IfaceGMozillaEngineGetBackWindowHistoryListStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_forward_window_history_list->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_forward_window_history_list->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_forward_window_history_list->test_iface = iface;
    /* GObject* history */tmp_iface_g_mozilla_engine_get_back_window_history_list->test_history_variable = NULL;
    /* GObject** history */tmp_iface_g_mozilla_engine_get_forward_window_history_list->history =
        &tmp_iface_g_mozilla_engine_get_back_window_history_list->test_history_variable;
    /* gint */tmp_iface_g_mozilla_engine_get_forward_window_history_list->expected_retvalue = 0;
    testdata.iface_g_mozilla_engine_get_forward_window_history_list.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_forward_window_history_list.table,
                tmp_iface_g_mozilla_engine_get_forward_window_history_list);
    testdata.iface_g_mozilla_engine_get_forward_window_history_list.index = 0;
    
    IfaceGMozillaEngineSetLayoutModeStruct* tmp_iface_g_mozilla_engine_set_layout_mode =
        g_new0(IfaceGMozillaEngineSetLayoutModeStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_layout_mode->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_layout_mode->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_layout_mode->test_iface = iface;
    /* GWebEngineLayoutMode */tmp_iface_g_mozilla_engine_set_layout_mode->mode = G_WEBENGINE_LAYOUT_NORMAL;
    testdata.iface_g_mozilla_engine_set_layout_mode.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_layout_mode.table,
                tmp_iface_g_mozilla_engine_set_layout_mode);
    testdata.iface_g_mozilla_engine_set_layout_mode.index = 0;
    
    IfaceGMozillaEngineGetLayoutModeStruct* tmp_iface_g_mozilla_engine_get_layout_mode =
        g_new0(IfaceGMozillaEngineGetLayoutModeStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_layout_mode->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_layout_mode->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_layout_mode->test_iface = iface;
    /* GWebEngineLayoutMode */tmp_iface_g_mozilla_engine_get_layout_mode->expected_retvalue =
        tmp_iface_g_mozilla_engine_set_layout_mode->mode;
    testdata.iface_g_mozilla_engine_get_layout_mode.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_layout_mode.table,
                tmp_iface_g_mozilla_engine_get_layout_mode);
    testdata.iface_g_mozilla_engine_get_layout_mode.index = 0;
    
    tmp_iface_g_mozilla_engine_set_layout_mode =
        g_new0(IfaceGMozillaEngineSetLayoutModeStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_layout_mode->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_layout_mode->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_layout_mode->test_iface = iface;
    /* GWebEngineLayoutMode */tmp_iface_g_mozilla_engine_set_layout_mode->mode = G_WEBENGINE_LAYOUT_SSR;
    testdata.iface_g_mozilla_engine_set_layout_mode.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_layout_mode.table,
                tmp_iface_g_mozilla_engine_set_layout_mode);
    testdata.iface_g_mozilla_engine_set_layout_mode.index = 0;

    tmp_iface_g_mozilla_engine_get_layout_mode =
        g_new0(IfaceGMozillaEngineGetLayoutModeStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_layout_mode->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_layout_mode->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_layout_mode->test_iface = iface;
    /* GWebEngineLayoutMode */tmp_iface_g_mozilla_engine_get_layout_mode->expected_retvalue = G_WEBENGINE_LAYOUT_MSR;
    testdata.iface_g_mozilla_engine_get_layout_mode.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_layout_mode.table,
                tmp_iface_g_mozilla_engine_get_layout_mode);
    testdata.iface_g_mozilla_engine_get_layout_mode.index = 0;
    
    tmp_iface_g_mozilla_engine_set_layout_mode =
        g_new0(IfaceGMozillaEngineSetLayoutModeStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_layout_mode->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_layout_mode->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_layout_mode->test_iface = iface;
    /* GWebEngineLayoutMode */tmp_iface_g_mozilla_engine_set_layout_mode->mode = G_WEBENGINE_LAYOUT_MSR;
    testdata.iface_g_mozilla_engine_set_layout_mode.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_layout_mode.table,
                tmp_iface_g_mozilla_engine_set_layout_mode);
    testdata.iface_g_mozilla_engine_set_layout_mode.index = 0;

    tmp_iface_g_mozilla_engine_get_layout_mode =
        g_new0(IfaceGMozillaEngineGetLayoutModeStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_layout_mode->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_layout_mode->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_layout_mode->test_iface = iface;
    /* GWebEngineLayoutMode */tmp_iface_g_mozilla_engine_get_layout_mode->expected_retvalue =
        tmp_iface_g_mozilla_engine_set_layout_mode->mode;
    testdata.iface_g_mozilla_engine_get_layout_mode.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_layout_mode.table,
                tmp_iface_g_mozilla_engine_get_layout_mode);
    testdata.iface_g_mozilla_engine_get_layout_mode.index = 0;
    
    IfaceGMozillaEngineSetLoadImagesStruct* tmp_iface_g_mozilla_engine_set_load_images =
        g_new0(IfaceGMozillaEngineSetLoadImagesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_load_images->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_load_images->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_load_images->test_iface = iface;
    /* GWebEngineImagePolicy */tmp_iface_g_mozilla_engine_set_load_images->level = G_WEBENGINE_POLICY_ALL_IMAGES;
    testdata.iface_g_mozilla_engine_set_load_images.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_load_images.table,
                tmp_iface_g_mozilla_engine_set_load_images);
    testdata.iface_g_mozilla_engine_set_load_images.index = 0;
    
    IfaceGMozillaEngineGetLoadImagesStruct* tmp_iface_g_mozilla_engine_get_load_images =
        g_new0(IfaceGMozillaEngineGetLoadImagesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_load_images->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_load_images->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_load_images->test_iface = iface;
    /* GWebEngineImagePolicy */tmp_iface_g_mozilla_engine_get_load_images->expected_retvalue =
        tmp_iface_g_mozilla_engine_set_load_images->level;
    testdata.iface_g_mozilla_engine_get_load_images.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_load_images.table,
                tmp_iface_g_mozilla_engine_get_load_images);
    testdata.iface_g_mozilla_engine_get_load_images.index = 0;
    
    tmp_iface_g_mozilla_engine_set_load_images =
        g_new0(IfaceGMozillaEngineSetLoadImagesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_load_images->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_load_images->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_load_images->test_iface = iface;
    /* GWebEngineImagePolicy */tmp_iface_g_mozilla_engine_set_load_images->level = G_WEBENGINE_POLICY_NO_IMAGES;
    testdata.iface_g_mozilla_engine_set_load_images.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_load_images.table,
                tmp_iface_g_mozilla_engine_set_load_images);
    testdata.iface_g_mozilla_engine_set_load_images.index = 0;
    
    tmp_iface_g_mozilla_engine_get_load_images =
        g_new0(IfaceGMozillaEngineGetLoadImagesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_load_images->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_load_images->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_load_images->test_iface = iface;
    /* GWebEngineImagePolicy */tmp_iface_g_mozilla_engine_get_load_images->expected_retvalue = G_WEBENGINE_POLICY_ALL_IMAGES;
    testdata.iface_g_mozilla_engine_get_load_images.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_load_images.table,
                tmp_iface_g_mozilla_engine_get_load_images);
    testdata.iface_g_mozilla_engine_get_load_images.index = 0;
    
    tmp_iface_g_mozilla_engine_set_load_images =
        g_new0(IfaceGMozillaEngineSetLoadImagesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_load_images->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_load_images->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_load_images->test_iface = iface;
    // Return value is G_WEBENGINE_POLICY_ALL_IMAGES because we can't get service from navigation and then default is G_WEBENGINE_POLICY_ALL_IMAGES.
    /* GWebEngineImagePolicy */tmp_iface_g_mozilla_engine_set_load_images->level = G_WEBENGINE_POLICY_LOADED_IMAGES;
    testdata.iface_g_mozilla_engine_set_load_images.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_load_images.table,
                tmp_iface_g_mozilla_engine_set_load_images);
    testdata.iface_g_mozilla_engine_set_load_images.index = 0;
    
    tmp_iface_g_mozilla_engine_get_load_images =
        g_new0(IfaceGMozillaEngineGetLoadImagesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_load_images->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_load_images->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_load_images->test_iface = iface;
    // Return value is G_WEBENGINE_POLICY_ALL_IMAGES because we can't get service from navigation and then default is G_WEBENGINE_POLICY_ALL_IMAGES.
    /* GWebEngineImagePolicy */tmp_iface_g_mozilla_engine_get_load_images->expected_retvalue = G_WEBENGINE_POLICY_ALL_IMAGES;
    testdata.iface_g_mozilla_engine_get_load_images.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_load_images.table,
                tmp_iface_g_mozilla_engine_get_load_images);
    testdata.iface_g_mozilla_engine_get_load_images.index = 0;
    
    tmp_iface_g_mozilla_engine_set_load_images =
        g_new0(IfaceGMozillaEngineSetLoadImagesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_load_images->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_load_images->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_load_images->test_iface = iface;
    /* GWebEngineImagePolicy */tmp_iface_g_mozilla_engine_set_load_images->level = -100;
    testdata.iface_g_mozilla_engine_set_load_images.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_load_images.table,
                tmp_iface_g_mozilla_engine_set_load_images);
    testdata.iface_g_mozilla_engine_set_load_images.index = 0;
    
    tmp_iface_g_mozilla_engine_get_load_images =
        g_new0(IfaceGMozillaEngineGetLoadImagesStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_load_images->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_load_images->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_load_images->test_iface = iface;
    // Return value is G_WEBENGINE_POLICY_ALL_IMAGES because we can't get service from navigation and then default is G_WEBENGINE_POLICY_ALL_IMAGES.
    /* GWebEngineImagePolicy */tmp_iface_g_mozilla_engine_get_load_images->expected_retvalue =
        G_WEBENGINE_POLICY_ALL_IMAGES;
    testdata.iface_g_mozilla_engine_get_load_images.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_load_images.table,
                tmp_iface_g_mozilla_engine_get_load_images);
    testdata.iface_g_mozilla_engine_get_load_images.index = 0;
    
    IfaceGMozillaEngineSetFrameStackingStruct* tmp_iface_g_mozilla_engine_set_frame_stacking =
        g_new0(IfaceGMozillaEngineSetFrameStackingStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_set_frame_stacking->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_set_frame_stacking->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_set_frame_stacking->test_iface = iface;
    /* gboolean */tmp_iface_g_mozilla_engine_set_frame_stacking->enabled = TRUE;
    testdata.iface_g_mozilla_engine_set_frame_stacking.table =
        g_list_append (testdata.iface_g_mozilla_engine_set_frame_stacking.table,
                tmp_iface_g_mozilla_engine_set_frame_stacking);
    testdata.iface_g_mozilla_engine_set_frame_stacking.index = 0;
    
    IfaceGMozillaEngineGetFrameStackingStruct* tmp_iface_g_mozilla_engine_get_frame_stacking =
        g_new0(IfaceGMozillaEngineGetFrameStackingStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_frame_stacking->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_frame_stacking->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_frame_stacking->test_iface = iface;
    /* gboolean */tmp_iface_g_mozilla_engine_get_frame_stacking->expected_retvalue =
        tmp_iface_g_mozilla_engine_set_frame_stacking->enabled;
    testdata.iface_g_mozilla_engine_get_frame_stacking.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_frame_stacking.table,
                tmp_iface_g_mozilla_engine_get_frame_stacking);
    testdata.iface_g_mozilla_engine_get_frame_stacking.index = 0;
    
    IfaceGMozillaEngineSaveWebPageStruct* tmp_iface_g_mozilla_engine_save_web_page =
        g_new0(IfaceGMozillaEngineSaveWebPageStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_save_web_page->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_save_web_page->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_save_web_page->test_iface = iface;
    /* GWebEngineSaveAction */tmp_iface_g_mozilla_engine_save_web_page->setting = G_WEBENGINE_SAVE_ALL_INLINES;
    /* const gchar* */tmp_iface_g_mozilla_engine_save_web_page->file_name_with_path = "file_name_with_path";
    /* GWebStatus */tmp_iface_g_mozilla_engine_save_web_page->expected_retvalue = G_WEB_ERR;
    testdata.iface_g_mozilla_engine_save_web_page.table =
        g_list_append (testdata.iface_g_mozilla_engine_save_web_page.table,
                tmp_iface_g_mozilla_engine_save_web_page);
    testdata.iface_g_mozilla_engine_save_web_page.index = 0;
    
    IfaceGMozillaEngineSaveCurrentFrameStruct* tmp_iface_g_mozilla_engine_save_current_frame =
        g_new0(IfaceGMozillaEngineSaveCurrentFrameStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_save_current_frame->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_save_current_frame->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_save_current_frame->test_iface = iface;
    /* GWebEngineSaveAction */tmp_iface_g_mozilla_engine_save_current_frame->setting = G_WEBENGINE_SAVE_ALL_INLINES;
    /* const gchar* */tmp_iface_g_mozilla_engine_save_current_frame->file_name_with_path = "file_name_with_path";
    /* GWebStatus */tmp_iface_g_mozilla_engine_save_current_frame->expected_retvalue = G_WEB_ERR;
    testdata.iface_g_mozilla_engine_save_current_frame.table =
        g_list_append (testdata.iface_g_mozilla_engine_save_current_frame.table,
                tmp_iface_g_mozilla_engine_save_current_frame);
    testdata.iface_g_mozilla_engine_save_current_frame.index = 0;
    
    IfaceGMozillaEngineGetFrameTitleStruct* tmp_iface_g_mozilla_engine_get_frame_title =
        g_new0(IfaceGMozillaEngineGetFrameTitleStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_frame_title->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_frame_title->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_frame_title->test_iface = iface;
    /* gint */tmp_iface_g_mozilla_engine_get_frame_title->frame_number = 0;
    /* const gchar* */tmp_iface_g_mozilla_engine_get_frame_title->expected_retvalue = NULL;
    testdata.iface_g_mozilla_engine_get_frame_title.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_frame_title.table,
                tmp_iface_g_mozilla_engine_get_frame_title);
    testdata.iface_g_mozilla_engine_get_frame_title.index = 0;
    
    IfaceGMozillaEngineGetElementDetailsStruct* tmp_iface_g_mozilla_engine_get_element_details =
        g_new0(IfaceGMozillaEngineGetElementDetailsStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_element_details->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_element_details->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_element_details->test_iface = iface;
    /* gint */tmp_iface_g_mozilla_engine_get_element_details->type = 0;
    /* gchar* */tmp_iface_g_mozilla_engine_get_element_details->expected_retvalue = NULL;
    testdata.iface_g_mozilla_engine_get_element_details.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_element_details.table,
                tmp_iface_g_mozilla_engine_get_element_details);
    testdata.iface_g_mozilla_engine_get_element_details.index = 0;
    
    IfaceGMozillaEngineGetFrameNumberStruct* tmp_iface_g_mozilla_engine_get_frame_number =
        g_new0(IfaceGMozillaEngineGetFrameNumberStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_get_frame_number->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_get_frame_number->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_get_frame_number->test_iface = iface;
    /* gint */tmp_iface_g_mozilla_engine_get_frame_number->expected_retvalue = -1;
    testdata.iface_g_mozilla_engine_get_frame_number.table =
        g_list_append (testdata.iface_g_mozilla_engine_get_frame_number.table,
                tmp_iface_g_mozilla_engine_get_frame_number);
    testdata.iface_g_mozilla_engine_get_frame_number.index = 0;
    



    
    
    IfaceGMozillaEngineResetStruct* tmp_iface_g_mozilla_engine_reset = 
        g_new0(IfaceGMozillaEngineResetStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_reset->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_reset->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_reset->test_iface = iface;
    testdata.iface_g_mozilla_engine_reset.table =
        g_list_append (testdata.iface_g_mozilla_engine_reset.table,
            tmp_iface_g_mozilla_engine_reset);
    testdata.iface_g_mozilla_engine_reset.index = 0;
    
    IfaceGMozillaEngineDestroyStruct* tmp_iface_g_mozilla_engine_destroy = 
        g_new0(IfaceGMozillaEngineDestroyStruct, 1);
    /* GMozillaEngine** */tmp_iface_g_mozilla_engine_destroy->test_self_pp = &self;
    /* GMozillaEngine* */tmp_iface_g_mozilla_engine_destroy->self = NULL;
    /* GWebEngineIface* */tmp_iface_g_mozilla_engine_destroy->test_iface = iface;
    testdata.iface_g_mozilla_engine_destroy.table =
        g_list_append (testdata.iface_g_mozilla_engine_destroy.table,
            tmp_iface_g_mozilla_engine_destroy);
    testdata.iface_g_mozilla_engine_destroy.index = 0;
    
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaengine_interface_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaengine_interface_clean");
    
    return 0;
}
    

/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillaengine_automatic_added[] = {
        //{ "test_content_set_cursor", test_content_set_cursor },
        //{ "test_dom_mouse_down_cb", test_dom_mouse_down_cb },
        //{ "test_dom_mouse_long_press_cb", test_dom_mouse_long_press_cb },
        /*PIRVATE*/{ "test_g_moz_eal_im_context_commit", test_g_moz_eal_im_context_commit },
        /*PIRVATE*/{ "test_g_moz_eal_im_context_delete_surrounding", test_g_moz_eal_im_context_delete_surrounding },
        /*PIRVATE*/{ "test_g_moz_eal_im_context_has_selection", test_g_moz_eal_im_context_has_selection },
        /*PIRVATE*/{ "test_g_moz_eal_im_context_retrieve_surrounding", test_g_moz_eal_im_context_retrieve_surrounding },
        /*PIRVATE*/{ "test_g_moz_eal_preedit_changed_cb", test_g_moz_eal_preedit_changed_cb },
        //{ "test_g_mozilla_add_notification_button", test_g_mozilla_add_notification_button },
        //{ "test_g_mozilla_append_notification", test_g_mozilla_append_notification },
        //{ "test_g_mozilla_engine_alert", test_g_mozilla_engine_alert },
        //{ "test_g_mozilla_engine_confirm", test_g_mozilla_engine_confirm },
        //{ "test_g_mozilla_engine_get_encoding", test_g_mozilla_engine_get_encoding },
        /*PIRVATE*/{ "test_g_mozilla_engine_get_page_verifier_name", test_g_mozilla_engine_get_page_verifier_name },
        /*PIRVATE*/{ "test_g_mozilla_engine_get_server_certificate", test_g_mozilla_engine_get_server_certificate },
        //{ "test_g_mozilla_engine_get_type", test_g_mozilla_engine_get_type },
        { "test_g_mozilla_engine_get_zoom_level", test_g_mozilla_engine_get_zoom_level },
        //{ "test_g_mozilla_engine_new", test_g_mozilla_engine_new },
        //{ "test_g_mozilla_engine_new_with_context", test_g_mozilla_engine_new_with_context },
        //{ "test_g_mozilla_engine_new_with_context_and_tracks", test_g_mozilla_engine_new_with_context_and_tracks },
        //{ "test_g_mozilla_remove_notification", test_g_mozilla_remove_notification },
        //{ "test_g_mozilla_show_notification", test_g_mozilla_show_notification },
        //{ "test_ctx_mozembed_to_eal", test_ctx_mozembed_to_eal },
        //{ "test_g_mozilla_create_select_notification", test_g_mozilla_create_select_notification },
        /*NEW & INTERFACE */{ "test_g_mozilla_engine_permit_page_unload", test_g_mozilla_engine_permit_page_unload },
        //{ "test_g_mozilla_engine_send_mouse_event", test_g_mozilla_engine_send_mouse_event },
        //{ "test_g_mozilla_engine_update_area", test_g_mozilla_engine_update_area },
        //{ "test_g_mozilla_engine_visible_area", test_g_mozilla_engine_visible_area },
        /*NEW & PRIVATE */{ "test_g_mozilla_send_notification", test_g_mozilla_send_notification },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillaengine_basics[] = {
        { "test_content_set_cursor", test_content_set_cursor },
        { "test_dom_mouse_down_cb", test_dom_mouse_down_cb },
        { "test_dom_mouse_long_press_cb", test_dom_mouse_long_press_cb },
        //PRIVATE { "test_g_moz_eal_im_context_commit", test_g_moz_eal_im_context_commit },
        //PRIVATE  { "test_g_moz_eal_im_context_delete_surrounding", test_g_moz_eal_im_context_delete_surrounding },
        //PRIVATE  { "test_g_moz_eal_im_context_has_selection", test_g_moz_eal_im_context_has_selection },
        //PRIVATE { "test_g_moz_eal_im_context_retrieve_surrounding", test_g_moz_eal_im_context_retrieve_surrounding },
        //PRIVATE { "test_g_moz_eal_preedit_changed_cb", test_g_moz_eal_preedit_changed_cb },
        { "test_g_mozilla_add_notification_button", test_g_mozilla_add_notification_button },
        { "test_g_mozilla_append_notification", test_g_mozilla_append_notification },
        { "test_g_mozilla_engine_alert", test_g_mozilla_engine_alert },
        { "test_g_mozilla_engine_confirm", test_g_mozilla_engine_confirm },
        { "test_g_mozilla_engine_get_encoding", test_g_mozilla_engine_get_encoding },
        //PRIVATE  { "test_g_mozilla_engine_get_page_verifier_name", test_g_mozilla_engine_get_page_verifier_name },
        //PRIVATE  { "test_g_mozilla_engine_get_server_certificate", test_g_mozilla_engine_get_server_certificate },
        { "test_g_mozilla_engine_get_type", test_g_mozilla_engine_get_type },
        //TODO: Segmentation fault, investigate { "test_g_mozilla_engine_get_zoom_level", test_g_mozilla_engine_get_zoom_level },
        { "test_g_mozilla_engine_new", test_g_mozilla_engine_new },
        { "test_g_mozilla_engine_new_with_context", test_g_mozilla_engine_new_with_context },
        { "test_g_mozilla_engine_new_with_context_and_tracks", test_g_mozilla_engine_new_with_context_and_tracks },
        { "test_g_mozilla_remove_notification", test_g_mozilla_remove_notification },
        { "test_g_mozilla_show_notification", test_g_mozilla_show_notification },
        //NEW { "test_ctx_mozembed_to_eal", test_ctx_mozembed_to_eal },
        //NEW { "test_g_mozilla_create_select_notification", test_g_mozilla_create_select_notification },
        //NEW & INTERFACE { "test_g_mozilla_engine_permit_page_unload", test_g_mozilla_engine_permit_page_unload },
        //NEW { "test_g_mozilla_engine_send_mouse_event", test_g_mozilla_engine_send_mouse_event },
        //NEW { "test_g_mozilla_engine_update_area", test_g_mozilla_engine_update_area },
        //NEW { "test_g_mozilla_engine_visible_area", test_g_mozilla_engine_visible_area },
        //NEW & PRIVATE { "test_g_mozilla_send_notification", test_g_mozilla_send_notification },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillaengine_advanced[] = {
        { "test_g_mozilla_engine_new_with_context_and_tracks with valid pointer for context and chrome flags set", test_g_mozilla_engine_new_with_context_and_tracks },
        { "test_g_mozilla_engine_new_with_context_and_tracks with valid pointer for context which hold a pointer to NULL pointer", test_g_mozilla_engine_new_with_context_and_tracks },
        { "test_g_mozilla_engine_new_with_context_and_tracks with context set to NULL and leave_tracks==TRUE and without_history==TRUE", test_g_mozilla_engine_new_with_context_and_tracks },
        { "test_g_mozilla_engine_get_zoom_level", test_g_mozilla_engine_get_zoom_level },
        { "test_g_mozilla_append_notification", test_g_mozilla_append_notification },
        //TODO: Get notification for this one somehow.
        { "test_g_mozilla_add_notification_button", test_g_mozilla_add_notification_button },
        //TODO: Not working anymore 290509 { "test_g_mozilla_show_notification", test_g_mozilla_show_notification },
        /* Segmentation fault: in destroy_cb, where trying to access self->global which is NULL.
        { "test_g_mozilla_remove_notification", test_g_mozilla_remove_notification },*/
        /* TODO: Segmentation fault, if self->global is not set. global should be checked against NULL.
         * { "test_content_set_cursor", test_content_set_cursor },*/
        /* TODO: Segmentation fault: self->engine->window is not checked against NULL in register_im_context
        { "test_g_mozilla_engine_alert", test_g_mozilla_engine_alert },*/
        { "test_g_mozilla_engine_get_encoding", test_g_mozilla_engine_get_encoding },
        /* TODO: Segmentation fault, investigate
         * { "test_dom_mouse_down_cb", test_dom_mouse_down_cb },*/
        /* TODO: Segmentation fault, investigate
         * { "test_dom_mouse_long_press_cb", test_dom_mouse_long_press_cb },*/
        /* TODO: Segmentation fauld, because when test_content_set_cursor is called it will cause the segmetation fault.
        { "test_g_mozilla_engine_confirm", test_g_mozilla_engine_confirm },*/
        ////PRIVATE  { "test_g_moz_eal_im_context_commit", test_g_moz_eal_im_context_commit },
        ////PRIVATE  { "test_g_moz_eal_im_context_delete_surrounding", test_g_moz_eal_im_context_delete_surrounding },
        ////PRIVATE  { "test_g_moz_eal_im_context_has_selection", test_g_moz_eal_im_context_has_selection },
        ////PRIVATE  { "test_g_moz_eal_im_context_retrieve_surrounding", test_g_moz_eal_im_context_retrieve_surrounding },
        ////PRIVATE  { "test_g_moz_eal_preedit_changed_cb", test_g_moz_eal_preedit_changed_cb },
        ////PRIVATE  { "test_g_mozilla_engine_get_page_verifier_name", test_g_mozilla_engine_get_page_verifier_name },
        ////PRIVATE  { "test_g_mozilla_engine_get_server_certificate", test_g_mozilla_engine_get_server_certificate },
        //{ "test_g_mozilla_engine_get_type", test_g_mozilla_engine_get_type },
        //{ "test_g_mozilla_engine_new", test_g_mozilla_engine_new },
        //{ "test_g_mozilla_engine_new_with_context", test_g_mozilla_engine_new_with_context },
        /*NEW*/{ "test_ctx_mozembed_to_eal", test_ctx_mozembed_to_eal },
        //TODO: Not working anymore 290509 /*NEW*/{ "test_g_mozilla_create_select_notification with multiple==TRUE and three labels in the list from which first and second are selected", test_g_mozilla_create_select_notification },
        //TODO: Not working anymore 290509 /*NEW*/{ "test_g_mozilla_create_select_notification with multiple==FALSE and one label in the list which is selected", test_g_mozilla_create_select_notification },
        //TODO: Not working anymore 290509 /*NEW*/{ "test_g_mozilla_create_select_notification with multiple==FALSE and one NULL label in the list", test_g_mozilla_create_select_notification },
        //NEW & INTERFACE { "test_g_mozilla_engine_permit_page_unload", test_g_mozilla_engine_permit_page_unload },
        /*NEW*/{ "test_g_mozilla_engine_send_mouse_event with type==G_WEBENGINE_ACTIVE_STATUS and mod==FALSE", test_g_mozilla_engine_send_mouse_event },
        /*NEW*/{ "test_g_mozilla_engine_send_mouse_event with type==G_WEBENGINE_MOUSE_SCROLL", test_g_mozilla_engine_send_mouse_event },
        /*NEW*/{ "test_g_mozilla_engine_send_mouse_event with type==G_WEBENGINE_ELEMENT_INFO", test_g_mozilla_engine_send_mouse_event },
        /*NEW*/{ "test_g_mozilla_engine_send_mouse_event with type==G_WEBENGINE_MOUSE_CLICK", test_g_mozilla_engine_send_mouse_event },
        /*NEW*/{ "test_g_mozilla_engine_send_mouse_event with type==G_WEBENGINE_MOUSE_LONG_PRESS", test_g_mozilla_engine_send_mouse_event },
        /*NEW*/{ "test_g_mozilla_engine_update_area", test_g_mozilla_engine_update_area },
        /*NEW*/{ "test_g_mozilla_engine_visible_area changes self->mWindowSize.height to 1", test_g_mozilla_engine_visible_area },
        /*NEW*/{ "test_g_mozilla_engine_visible_area changes self->mWindowSize.height to 0", test_g_mozilla_engine_visible_area },
        //NEW & PRIVATE { "test_g_mozilla_send_notification", test_g_mozilla_send_notification },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillaengine_interface[] = {
        { "test_iface_g_mozilla_engine_load_url with url=='url'", test_iface_g_mozilla_engine_load_url},
        { "test_iface_g_mozilla_engine_load_url with url=='http://www.testurl.com'", test_iface_g_mozilla_engine_load_url},
        { "test_iface_g_mozilla_engine_load_follow_link with url=='url'", test_iface_g_mozilla_engine_load_follow_link},
        { "test_iface_g_mozilla_engine_load_url_with_css", test_iface_g_mozilla_engine_load_url_with_css},
        { "test_iface_g_mozilla_engine_load_url_with_js", test_iface_g_mozilla_engine_load_url_with_js},
        { "test_iface_g_mozilla_engine_load_home_page", test_iface_g_mozilla_engine_load_home_page},
        //TODO: Not working anymore 290509 { "test_iface_g_mozilla_engine_stop_load", test_iface_g_mozilla_engine_stop_load},
        //TODO: Segmentation fault: investigate { "test_iface_g_mozilla_engine_reload", test_iface_g_mozilla_engine_reload},
        { "test_iface_g_mozilla_engine_go_back one step", test_iface_g_mozilla_engine_go_back},
        { "test_iface_g_mozilla_engine_go_forward one step", test_iface_g_mozilla_engine_go_forward},
        { "test_iface_g_mozilla_engine_go_back two steps", test_iface_g_mozilla_engine_go_back},
        { "test_iface_g_mozilla_engine_go_forward two steps", test_iface_g_mozilla_engine_go_forward},
        { "test_iface_g_mozilla_engine_can_go_back", test_iface_g_mozilla_engine_can_go_back},
        { "test_iface_g_mozilla_engine_can_go_forward", test_iface_g_mozilla_engine_can_go_forward},
        { "test_iface_g_mozilla_engine_set_zoom_level to 90", test_iface_g_mozilla_engine_set_zoom_level},
        { "test_iface_g_mozilla_engine_set_zoom_level to 90 again", test_iface_g_mozilla_engine_set_zoom_level},
        { "test_iface_g_mozilla_engine_set_zoom_level to 100", test_iface_g_mozilla_engine_set_zoom_level},
        { "test_iface_g_mozilla_engine_set_zoom_level_around_point", test_iface_g_mozilla_engine_set_zoom_level_around_point},
        { "test_iface_g_mozilla_engine_compare_frames_zoom_level with equal pointing to gboolean variable", test_iface_g_mozilla_engine_compare_frames_zoom_level},
        { "test_iface_g_mozilla_engine_compare_frames_zoom_level with equal==NULL", test_iface_g_mozilla_engine_compare_frames_zoom_level},
        { "test_iface_g_mozilla_engine_zoom_by_steps", test_iface_g_mozilla_engine_zoom_by_steps},
        { "test_iface_g_mozilla_engine_new_zoom_by_steps", test_iface_g_mozilla_engine_new_zoom_by_steps},
        { "test_iface_g_mozilla_engine_set_frame_zoom_level", test_iface_g_mozilla_engine_set_frame_zoom_level},
        { "test_iface_g_mozilla_engine_get_frame_zoom_level", test_iface_g_mozilla_engine_get_frame_zoom_level},
        { "test_iface_g_mozilla_engine_get_image_properties", test_iface_g_mozilla_engine_get_image_properties},
        { "test_iface_g_mozilla_engine_get_frame_properties", test_iface_g_mozilla_engine_get_frame_properties},
        { "test_iface_g_mozilla_engine_load_image", test_iface_g_mozilla_engine_load_image},
        { "test_iface_g_mozilla_engine_get_back_window_history_list", test_iface_g_mozilla_engine_get_back_window_history_list},
        { "test_iface_g_mozilla_engine_get_forward_window_history_list", test_iface_g_mozilla_engine_get_forward_window_history_list},
        { "test_iface_g_mozilla_engine_set_layout_mode with mode==G_WEBENGINE_LAYOUT_NORMAL", test_iface_g_mozilla_engine_set_layout_mode},
        { "test_iface_g_mozilla_engine_get_layout_mode with mode==G_WEBENGINE_LAYOUT_NORMAL", test_iface_g_mozilla_engine_get_layout_mode},
        { "test_iface_g_mozilla_engine_set_layout_mode with mode==G_WEBENGINE_LAYOUT_SSR", test_iface_g_mozilla_engine_set_layout_mode},
        { "test_iface_g_mozilla_engine_get_layout_mode with mode==G_WEBENGINE_LAYOUT_SSR", test_iface_g_mozilla_engine_get_layout_mode},
        { "test_iface_g_mozilla_engine_set_layout_mode with mode==G_WEBENGINE_LAYOUT_MSR", test_iface_g_mozilla_engine_set_layout_mode},
        { "test_iface_g_mozilla_engine_get_layout_mode with mode==G_WEBENGINE_LAYOUT_MSR", test_iface_g_mozilla_engine_get_layout_mode},
        { "test_iface_g_mozilla_engine_set_load_images level==G_WEBENGINE_POLICY_ALL_IMAGES", test_iface_g_mozilla_engine_set_load_images},
        { "test_iface_g_mozilla_engine_get_load_images level==G_WEBENGINE_POLICY_ALL_IMAGES", test_iface_g_mozilla_engine_get_load_images},
        { "test_iface_g_mozilla_engine_set_load_images level==G_WEBENGINE_POLICY_NO_IMAGES", test_iface_g_mozilla_engine_set_load_images},
        { "test_iface_g_mozilla_engine_get_load_images level==G_WEBENGINE_POLICY_NO_IMAGES", test_iface_g_mozilla_engine_get_load_images},
        { "test_iface_g_mozilla_engine_set_load_images level==G_WEBENGINE_POLICY_LOADED_IMAGES", test_iface_g_mozilla_engine_set_load_images},
        { "test_iface_g_mozilla_engine_get_load_images level==G_WEBENGINE_POLICY_LOADED_IMAGES", test_iface_g_mozilla_engine_get_load_images},
        { "test_iface_g_mozilla_engine_set_load_images level==default", test_iface_g_mozilla_engine_set_load_images},
        { "test_iface_g_mozilla_engine_get_load_images level==default", test_iface_g_mozilla_engine_get_load_images},
        { "test_iface_g_mozilla_engine_set_frame_stacking", test_iface_g_mozilla_engine_set_frame_stacking},
        { "test_iface_g_mozilla_engine_get_frame_stacking", test_iface_g_mozilla_engine_get_frame_stacking},
        { "test_iface_g_mozilla_engine_save_web_page", test_iface_g_mozilla_engine_save_web_page},
        { "test_iface_g_mozilla_engine_save_current_frame", test_iface_g_mozilla_engine_save_current_frame},
        { "test_iface_g_mozilla_engine_get_frame_title", test_iface_g_mozilla_engine_get_frame_title},
        { "test_iface_g_mozilla_engine_get_element_details", test_iface_g_mozilla_engine_get_element_details},
        { "test_iface_g_mozilla_engine_get_frame_number", test_iface_g_mozilla_engine_get_frame_number},
        { "test_iface_g_mozilla_engine_reset", test_iface_g_mozilla_engine_reset},
        //TODO: Not working in hudson???? { "test_iface_g_mozilla_engine_destroy", test_iface_g_mozilla_engine_destroy},
        CU_TEST_INFO_NULL, //null terminated
};


/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillaengine[] = {
        {"testgmozillaengine_automatic_added", testgmozillaengine_automatic_init, testgmozillaengine_automatic_clean, testgmozillaengine_automatic_added },
        {"testgmozillaengine_basics", testgmozillaengine_basics_init, testgmozillaengine_basics_clean, testgmozillaengine_basics },
        {"testgmozillaengine_advanced", testgmozillaengine_advanced_init, testgmozillaengine_advanced_clean, testgmozillaengine_advanced },
        {"testgmozillaengine_interface", testgmozillaengine_interface_init, testgmozillaengine_interface_clean, testgmozillaengine_interface },
        CU_SUITE_INFO_NULL, //null terminated
};
