/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nokia code.
 *
 * The Initial Developer of the Original Code is Novell.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Aiken Tie <ext-tie.aiken@nokia.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef TESTMICROBEAL_H
#define TESTMICROBEAL_H

#include <cppunit/extensions/HelperMacros.h>
#include <gtk/gtk.h>
#include <glib.h>
#include "gmozillaweb.h"
#include "gmozillaengine.h"



class Testmicrobeal : public CppUnit::TestFixture
{

	CPPUNIT_TEST_SUITE( Testmicrobeal );
	//CPPUNIT_TEST(test_MicrobEalDownloadMgr);
	CPPUNIT_TEST(test_InitTransferItem);
	CPPUNIT_TEST(test_SetupDownloadListener);
	CPPUNIT_TEST(test_StartDownload);
	CPPUNIT_TEST(test_MicrobEalCertificate);
	CPPUNIT_TEST(test_MicrobEalCertificate_Init);
	//CPPUNIT_TEST(test_MicrobEalCertificate_SetUp);
	CPPUNIT_TEST(test_MicrobShmBufData);
	//CPPUNIT_TEST(test_MicrobShmBufData_SetData);
	CPPUNIT_TEST(test_MicrobShmBufData_SetBlocked);
	CPPUNIT_TEST(test_MicrobEalXshmRenderer);
	CPPUNIT_TEST(test_MicrobEalXshmRenderer_Init);
	//CPPUNIT_TEST(test_MicrobEalXshmRenderer_SetUp1);
	CPPUNIT_TEST(test_MicrobEalXshmRenderer_SetUp2);
	CPPUNIT_TEST(test_MicrobEalXshmRenderer_UnSetup);
	//CPPUNIT_TEST(test_MicrobEalXshmRenderer_CreateSharedImageData);
	//CPPUNIT_TEST(test_MicrobEalXshmRenderer_DrawRectToXshm);
	//CPPUNIT_TEST(test_MicrobEalXshmRenderer_byte_per_pixel);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_UpdateContextData);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_UpdateContextDataFromNode);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_UpdateContextDataFromElement);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_GetContextText);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_GetJSHandledInfo);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_InsertTextToNode);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_GetCSSBackground);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_CheckDomImageElement);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_GetImageRequest);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_ScrollToSelectedNode);
	CPPUNIT_TEST(test_MicrobEalContextMenuInfo_DoCommand);
	CPPUNIT_TEST(test_MicrobEalFilePicker);
	CPPUNIT_TEST(test_MicrobEalFilePicker_Init);
	CPPUNIT_TEST(test_MicrobEalFilePicker_AppendFilters);
	CPPUNIT_TEST(test_MicrobEalFilePicker_AppendFilter);
	CPPUNIT_TEST(test_MicrobEalFilePicker_GetFile);
	CPPUNIT_TEST(test_MicrobEalFilePicker_GetFileURL);
	CPPUNIT_TEST(test_MicrobEalFilePicker_Show);
	CPPUNIT_TEST(test_MicrobEalNotification);
	CPPUNIT_TEST(test_MicrobEalNotificationBox);
	CPPUNIT_TEST(test_MicrobEalNotificationBox_AppendNotification);
	CPPUNIT_TEST(test_MicrobEalNotificationBox_GetNotificationWithValue);
	CPPUNIT_TEST(test_MicrobEalNotificationBox_RemoveAllNotifications);
	CPPUNIT_TEST(test_MicrobEalNotificationBox_RemoveCurrentNotification);
	CPPUNIT_TEST(test_MicrobEalNotificationBox_RemoveNotification);
	CPPUNIT_TEST(test_MicrobEalNotificationBox_ButtonPressed);
	CPPUNIT_TEST(test_MicrobEalNotificationButton);
	CPPUNIT_TEST(test_MicrobEalObserver_Create);
	CPPUNIT_TEST(test_MicrobEalObserver_RegisterSelf);
	CPPUNIT_TEST(test_MicrobEalObserver_UnregisterSelf);
	CPPUNIT_TEST(test_MicrobEalPromptService);
	CPPUNIT_TEST(test_GetGMozEngineForDOMWindow);
	CPPUNIT_TEST(test_GetDOMWindowByNode);
	CPPUNIT_TEST(test_GetContentViewer);
	CPPUNIT_TEST(test_components_static_init);
	CPPUNIT_TEST(test_components_init);
	CPPUNIT_TEST(test_components_del);
	CPPUNIT_TEST(test_microb_context);
	CPPUNIT_TEST(test_microb_context_set_prop1);
	CPPUNIT_TEST(test_microb_context_set_prop2);
	CPPUNIT_TEST(test_microb_context_get_prop1);
	CPPUNIT_TEST(test_microb_context_get_prop2);
	CPPUNIT_TEST(test_microb_context_update_from_event);
	CPPUNIT_TEST(test_microb_context_update_from_element);
	CPPUNIT_TEST(test_microb_context_get_node);
	CPPUNIT_TEST(test_microb_context_get_text1);
	CPPUNIT_TEST(test_microb_context_get_text2);
	CPPUNIT_TEST(test_microb_context_insert_text1);
	CPPUNIT_TEST(test_microb_context_insert_text2);
	CPPUNIT_TEST_SUITE_END();


	public:
	void test_MicrobEalDownloadMgr();
	void test_InitTransferItem();
	void test_SetupDownloadListener();
	void test_StartDownload();
	void test_MicrobEalCertificate();
	void test_MicrobEalCertificate_Init();
	void test_MicrobEalCertificate_SetUp();
	void test_MicrobShmBufData();
	//void test_MicrobShmBufData_SetData();
	void test_MicrobShmBufData_SetBlocked();
	void test_MicrobEalXshmRenderer();
	void test_MicrobEalXshmRenderer_Init();
	void test_MicrobEalXshmRenderer_SetUp1();
	void test_MicrobEalXshmRenderer_SetUp2();
	void test_MicrobEalXshmRenderer_UnSetup();
	//void test_MicrobEalXshmRenderer_CreateSharedImageData();
	//void test_MicrobEalXshmRenderer_DrawRectToXshm();
	//void test_MicrobEalXshmRenderer_byte_per_pixel();
	void test_MicrobEalContextMenuInfo();
	void test_MicrobEalContextMenuInfo_UpdateContextData();
	void test_MicrobEalContextMenuInfo_UpdateContextDataFromNode();
	void test_MicrobEalContextMenuInfo_UpdateContextDataFromElement();
	void test_MicrobEalContextMenuInfo_GetContextText();
	void test_MicrobEalContextMenuInfo_GetJSHandledInfo();
	void test_MicrobEalContextMenuInfo_InsertTextToNode();
	void test_MicrobEalContextMenuInfo_GetCSSBackground();
	void test_MicrobEalContextMenuInfo_CheckDomImageElement();
	void test_MicrobEalContextMenuInfo_GetImageRequest();
	void test_MicrobEalContextMenuInfo_ScrollToSelectedNode();
	void test_MicrobEalContextMenuInfo_DoCommand();
	void test_MicrobEalFilePicker();
	void test_MicrobEalFilePicker_Init();
	void test_MicrobEalFilePicker_AppendFilters();
	void test_MicrobEalFilePicker_AppendFilter();
	void test_MicrobEalFilePicker_GetFile();
	void test_MicrobEalFilePicker_GetFileURL();
	void test_MicrobEalFilePicker_Show();
	void test_MicrobEalNotification();
	void test_MicrobEalNotificationBox();
	void test_MicrobEalNotificationBox_AppendNotification();
	void test_MicrobEalNotificationBox_GetNotificationWithValue();
	void test_MicrobEalNotificationBox_RemoveAllNotifications();
	void test_MicrobEalNotificationBox_RemoveCurrentNotification();
	void test_MicrobEalNotificationBox_RemoveNotification();
	void test_MicrobEalNotificationBox_ButtonPressed();
	void test_MicrobEalNotificationButton();
	void test_MicrobEalObserver_Create();
	void test_MicrobEalObserver_RegisterSelf();
	void test_MicrobEalObserver_UnregisterSelf();
	void test_MicrobEalPromptService();
	void test_GetGMozEngineForDOMWindow();
	void test_GetDOMWindowByNode();
	void test_GetContentViewer();
	void test_components_static_init();
	void test_components_init();
	void test_components_del();
	void test_microb_context();
	void test_microb_context_set_prop1();
	void test_microb_context_set_prop2();
	void test_microb_context_get_prop1();
	void test_microb_context_get_prop2();
	void test_microb_context_update_from_event();
	void test_microb_context_update_from_element();
	void test_microb_context_get_node();
	void test_microb_context_get_text1();
	void test_microb_context_get_text2();
	void test_microb_context_insert_text1();
	void test_microb_context_insert_text2();
	void init();
	GMozillaEngine *mozengine;
	GWebEngine *webengine;
	GObject *engine_widget;
};













#endif //TESTMICROBEAL_H
