/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=4 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"
#include "gmozillahistorylist.h"
#include "gmozillacppwrapper.h"

/* GMozillaHistoryList */


int
g_mozilla_history_list_clear_all ()
{
    return g_mozilla_cpp_history_list_remove_all();
}

static gboolean
g_mozilla_history_list_position_ok (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    return (G_MOZILLA_HISTORY_LIST(self)->items &&
            pos >= 0 &&
            pos < G_MOZILLA_HISTORY_LIST(self)->num_items);
}

static void
g_mozilla_history_list_delete_item (GMozillaHistoryList *self, gint pos)
{
    guint rv;
    TRACE_LOG();

    if (!g_mozilla_history_list_position_ok((GWebHistoryList*)self, pos)) {
        return;
    }
    gchar *string = (char*)(G_MOZILLA_HISTORY_LIST(self)->items)[pos].url;
    if (!string) {
        return ;
    }
    rv = g_mozilla_cpp_history_list_remove(string);
    /* we don't have NS_FAILED, this is NS_FAILED */
    if (rv & 0x80000000) {
        TRACE_LOG("gtk_moz_embed_common_remove_history failed");
        return ;
    }

    EAL_IF_GFREE(string);
    string = (char*)(G_MOZILLA_HISTORY_LIST(self)->items)[pos].title;
    EAL_IF_GFREE(string);
    string = (char*)(G_MOZILLA_HISTORY_LIST(self)->items)[pos].shistory_thumbnail_fn;
    EAL_IF_GFREE(string);
}

static GObject*
g_mozilla_history_list_get_items (GMozillaHistoryList *self)
{
    TRACE_LOG();
    // Not in use anymore
    return NULL;
}

static gint
g_mozilla_history_list_get_items_count (GMozillaHistoryList *self)
{
    TRACE_LOG();
    return G_MOZILLA_HISTORY_LIST(self)->num_items;
}

static const gchar*
g_mozilla_history_list_get_item_title (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    if (g_mozilla_history_list_position_ok(self, pos)) {
        return (G_MOZILLA_HISTORY_LIST(self)->items)[pos].title;
    }
    return NULL;
}

static const gchar*
g_mozilla_history_list_get_item_url (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    if (g_mozilla_history_list_position_ok(self, pos)) {
        return (G_MOZILLA_HISTORY_LIST(self)->items)[pos].url;
    }
    return NULL;
}

static const gchar*
g_mozilla_shistory_list_get_item_thumbnail (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    if (g_mozilla_history_list_position_ok(self, pos)) {
        return (G_MOZILLA_HISTORY_LIST(self)->items)[pos].shistory_thumbnail_fn;
    }
    return NULL;
}

static GTime
g_mozilla_history_list_get_item_time (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    if (g_mozilla_history_list_position_ok(self, pos)) {
	return (G_MOZILLA_HISTORY_LIST(self)->items)[pos].accessed;
    }
    return 0;
}

static void
g_mozilla_history_list_destroy (GMozillaHistoryList *self)
{
    TRACE_LOG();
    gint index;
    for (index = 0; index < self->num_items; index++) {
        gchar *url = (gchar *) g_mozilla_history_list_get_item_url((GWebHistoryList *)self, index);
        gchar *title = (gchar *) g_mozilla_history_list_get_item_title((GWebHistoryList *)self, index);
        EAL_IF_GFREE(url);
        EAL_IF_GFREE(title);
#if 0
        gchar *thumbnail_fn = (gchar *) g_mozilla_shistory_list_get_item_thumbnail((GWebHistoryList *)self, index);
        EAL_IF_GFREE(thumbnail_fn);
#endif
    }
    g_free(G_MOZILLA_HISTORY_LIST(self)->items);
}

static void
g_mozilla_history_list_interface_init (GWebHistoryListIface *iface)
{
    TRACE_LOG();
    iface->destroy         = (void (*) (GWebHistoryList*))
                             g_mozilla_history_list_destroy;
    iface->delete_item     = (void (*) (GWebHistoryList*, gint))
                             g_mozilla_history_list_delete_item;
    iface->get_items       = (GObject* (*) (GWebHistoryList*))
                             g_mozilla_history_list_get_items;
    iface->get_items_count = (gint (*) (GWebHistoryList*))
                             g_mozilla_history_list_get_items_count;
    iface->get_item_title  = (gchar* (*) (GWebHistoryList*, gint))
                             g_mozilla_history_list_get_item_title;
    iface->get_item_url    = (gchar* (*) (GWebHistoryList*, gint))
                             g_mozilla_history_list_get_item_url;
    iface->get_item_time   = (GTime (*) (GWebHistoryList*, gint))
                             g_mozilla_history_list_get_item_time;
    iface->get_item_thumbnail  = (gchar* (*) (GWebHistoryList*, gint))
                             g_mozilla_shistory_list_get_item_thumbnail;
}

static void
g_mozilla_history_list_instance_init (GTypeInstance *instance, gpointer  g_class)
{
    TRACE_LOG();
    G_MOZILLA_HISTORY_LIST(instance)->items     = NULL;
    G_MOZILLA_HISTORY_LIST(instance)->num_items = 0;
}

GType
g_mozilla_history_list_get_type (void)
{
    static GType type = 0;
    if (type == 0)
    {
        static const GTypeInfo info =
            {
                sizeof (GMozillaHistoryListClass),
                NULL,   /* base_init */
                NULL,   /* base_finalize */
                NULL,   /* class_init */
                NULL,   /* class_finalize */
                NULL,   /* class_data */
                sizeof (GMozillaHistoryList),
                0,      /* n_preallocs */
                g_mozilla_history_list_instance_init    /* instance_init */
            };
        static const GInterfaceInfo iface_info =
            {
                (GInterfaceInitFunc) g_mozilla_history_list_interface_init,
                NULL,   /* interface_finalize */
                NULL    /* interface_data */
            };
        type = g_type_register_static (G_TYPE_OBJECT,
                                       "GMozillaHistoryList",
                                       &info, 0);
        g_type_add_interface_static (type,
                                     G_TYPE_WEB_HISTORY_LIST,
                                     &iface_info);
    }
    return type;
}

GObject*
g_mozilla_history_list_new (void)
{
    TRACE_LOG();
    GObject* instance = G_OBJECT(g_object_new(g_mozilla_history_list_get_type(), NULL));
    G_MOZILLA_HISTORY_LIST(instance)->isSHistory = FALSE;
    G_MOZILLA_HISTORY_LIST(instance)->num_items =
                g_mozilla_cpp_get_history_list(
                        &(G_MOZILLA_HISTORY_LIST(instance))->items);
    return G_OBJECT(instance);
}

typedef struct
{
  gpointer engine;
  unsigned int message;
  int number;
  GWebEngineEncoding encoding;
} HistStruct;

//Workaround for bug #102760
static gboolean send_history_message_delayed(gpointer data)
{
  HistStruct* hist_data = data;
  g_return_val_if_fail(hist_data && hist_data->engine, FALSE);
  g_signal_emit_by_name (G_OBJECT(hist_data->engine), G_WEBWIDGET_SIGNAL_HISTORY_CHANGED, hist_data->message, hist_data->number, hist_data->encoding);
  free(hist_data);
  return FALSE;
}

void send_history_message(GMozillaEngine* engine, unsigned int message, int number, GWebEngineEncoding encoding)
{
  HistStruct* hist_data = malloc(sizeof(HistStruct));
  g_return_if_fail(hist_data);
  hist_data->engine = engine;
  hist_data->message = message;
  hist_data->number = number;
  hist_data->encoding = encoding;
  //send message in next loop iteration
  g_idle_add((GSourceFunc)send_history_message_delayed, (gpointer)hist_data);
}


