/*
 * This file is part of maemopad
 *
 * Copyright (C) 2005-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#ifndef _MAEMOPAD_WINDOW_H
#define _MAEMOPAD_WINDOW_H

#include <hildon/hildon.h>
#include <libosso.h>

G_BEGIN_DECLS

#define MAEMOPAD_TYPE_WINDOW maemopad_window_get_type()

#define MAEMOPAD_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MAEMOPAD_TYPE_WINDOW, MaemopadWindow))

#define MAEMOPAD_WINDOW_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MAEMOPAD_TYPE_WINDOW, MaemopadWindowClass))

#define MAEMOPAD_IS_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MAEMOPAD_TYPE_WINDOW))

#define MAEMOPAD_IS_WINDOW_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MAEMOPAD_TYPE_WINDOW))

#define MAEMOPAD_WINDOW_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MAEMOPAD_TYPE_WINDOW, MaemopadWindowClass))

typedef struct _MaemopadWindow MaemopadWindow;
typedef struct _MaemopadWindowClass MaemopadWindowClass;


struct _MaemopadWindow
{
  HildonWindow parent;
  
  /* Osso context, needed for "send via" functionality. */
  osso_context_t *osso; 

  /* Fullscreen mode is on (TRUE) or off (FALSE): */
  gboolean fullscreen;

  /* Button items for menu: */
  GtkWidget *new_item;
  GtkWidget *open_item;
  GtkWidget *save_item;
  GtkWidget *saveas_item;
  GtkWidget *cut_item;
  GtkWidget *copy_item;
  GtkWidget *paste_item;

  /* Send via stuff: */
  GtkWidget *sendvia_item;
  GtkWidget *sendemail_item;
  GtkWidget *sendbt_item;

  GtkWidget *font_item;
  GtkWidget *fullscreen_item;
  GtkWidget *close_item;
    
  /* Textview related: */
  GtkWidget* scrolledwindow;   /* textview is under this widget */
  GtkWidget* textview;         /* widget that shows the text */
  GtkTextBuffer* buffer;       /* buffer that contains the text */
   
  PangoFontDescription* font_desc;    /* font used in textview */

  gboolean file_edited;     /* tells is our file on view edited */
  gchar* file_name;         /* directory/file under editing */ 
  
  gboolean key_pressed;  

  struct _FullscreenManager *fullscreen_manager;
};

struct _MaemopadWindowClass
{
  HildonWindowClass parent_class;
};

GType maemopad_window_get_type (void);

MaemopadWindow* maemopad_window_new (osso_context_t *osso);

G_END_DECLS

#endif /* _MAEMOPAD_WINDOW_H */
