/**
    @file images.h

    Maemo-Blocks picture headers.

  This file is part of Maemo Blocks

  Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
  http://www.indt.org/maemo
 
  This software is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License
  as published by the Free Software Foundation; either version 2.1 of
  the License, or (at your option) any later version.
 
  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with this software; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  02110-1301 USA
*/


#ifndef _IMAGES_H_
#define _IMAGES_H_

#define BLOCK_WIDTH     29
#define BLOCK_HEIGHT    30
#define NUMBER_WIDTH    24
#define NUMBER_HEIGHT   16

#ifdef __ORIENT_REV_POTRAIT__
#define BOARDOFFSETX    28
#define BOARDOFFSETY    90
#define BOARDOFFSETX2	128
#define BOARDOFFSETY2	23
#define BOARDWIDTH	583
#define BOARDHEIGHT	310
#else
#define BOARDOFFSETX    (28+120)
#define BOARDOFFSETY    (90-20)
#define BOARDOFFSETX2	90	
#define BOARDOFFSETY2	150
#define BOARDWIDTH	580
#define BOARDHEIGHT	307
#endif

#ifdef __ORIENT_REV_POTRAIT__
#define NEXTOFFSETX     333
#define NEXTOFFSETY     110
#define NEXTOFFSETX2	517
#define NEXTOFFSETY2	333
#else
#define NEXTOFFSETX     17
#define NEXTOFFSETY     97
#define NEXTOFFSETX2	110
#define NEXTOFFSETY2	17
#endif

#define NEXT_WIDTH	173
#define NEXT_HEIGHT	129

#ifdef __ORIENT_REV_POTRAIT__
#define LEVELOFFSETX    404
#define LEVELOFFSETY    347
#define SCOREOFFSETX    278
#define SCOREOFFSETY    347
#define LINEOFFSETX     154
#define LINEOFFSETY     347
#else
#define LEVELOFFSETX    (404+220)
#define LEVELOFFSETY    (347-320)
#define SCOREOFFSETX    (278+220)
#define SCOREOFFSETY    (347-320)
#define LINEOFFSETX     (154+220)
#define LINEOFFSETY     (347-320)
#endif

/** The loaded images */
extern SDL_Surface *screen, *pieces, *background, *numbers, *loose;

/**
  Load images
  @return 0 on failure
*/
int load_images(void);

/**
  Free memory
*/
void free_images(void);

/**
  draw board
*/
void draw_board(void);

/**
  Draw block
*/
void draw_block(int x, int y, int block, int frame);

/**
  Draw next block
*/
void draw_next_block(void);

/**
  Draw numbers
*/
void draw_number(int x, int value);

/**
  Update panel
*/
void update_game_values(int current_lines, int current_level,
                        int current_score);

#endif // _IMAGES_H_
