#!/bin/sh

# maemo-optify-firstboot
#######################################################
# Copyright: (C) 2010 Nokia
# License:   DO WHAT YOU WANT TO PUBLIC LICENSE
# Authors:   Karpov Denis, ext-denis.2.karpov@nokia.com
#            Claudio Saavedra, csaavedra@igalia.com
#            Gary Birkett, gary.birkett@collabora.co.uk
#######################################################

# minimal script to cleanup /home/opt under very specific circumstances.
# will copy contents of rootfs /opt to /home-opt to allow image to be optified.
# will only run if do-not-clean-home-opt does not exist.
# postinst will create this file if used within scratchbox.
# IMPORTANT! this is called from upstart scripts, so make sure there are no 
# error codes returned

#only clean the /home/opt if needed
[ -e /var/lib/maemo-optify-firstboot-do-not-clean-home-opt ] &&  return 0

# clean up existing /home/opt
if [ -d /home/opt ] 
then
 rm -rf /home/opt/*
else
 mkdir /home/opt
fi
sync

# move /opt contents to /home/opt only if they exist
# ensure we update the donotclean flag now so we do not run again.
[ -d /opt ] && [ ! -z "`ls /opt`" ] && \
cp -a /opt/* /home/opt/ && sync && \
touch /var/lib/maemo-optify-firstboot-do-not-clean-home-opt && sync && \
rm -rf /opt/*

return 0

