#!/usr/bin/python2.5

import sys
import dbus

if len(sys.argv) < 3:
	print "Usage %s <name> <mode>" % sys.argv[0]
	sys.exit(1)

bus = dbus.SystemBus()

manager = dbus.Interface(bus.get_object("org.bluez", "/"), "org.bluez.Manager")
adapter = dbus.Interface(bus.get_object("org.bluez", manager.DefaultAdapter()),
							"org.bluez.Adapter")
adapter.SetProperty("Name", sys.argv[1])

if sys.argv[2] == "off":
	adapter.SetProperty("Powered", False)
	sys.exit(0)

adapter.SetProperty("Powered", True)

if sys.argv[2] == "discoverable":
	adapter.SetProperty("Discoverable", True)
elif sys.argv[2] == "connectable":
	adapter.SetProperty("Discoverable", False)

