
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dbus-common.h"

int main(int argc, char** argv)
{
	GError *error;
	DBusGConnection *conn;
	DBusGProxy *manager;
	DBusGProxy *adapter;
	const gchar *name;
	const gchar *mode;

	if (argc < 3) {
		g_debug("Usage %s <name> <mode>", argv[0]);
		exit(EXIT_FAILURE);
	}

	g_type_init();
	error = NULL;
	conn = dbus_g_bus_get(DBUS_BUS_SYSTEM, &error);

	if (error != NULL) {
		g_debug("Couldn't connect to bus: %s", error->message);
		g_error_free(error);
		exit(EXIT_FAILURE);
	}

	name = argv[1];
	mode = argv[2];
	manager = bluez_get_manager(conn);
	adapter = manager_get_default_adapter(manager, conn);

	if (manager != NULL)
		g_object_unref(manager);

	if (strlen(name) > 0)
		adapter_set_property_string(adapter, "Name", name);

	if (g_str_equal(mode, "off")) {
		adapter_set_property_boolean(adapter, "Powered", FALSE);
		exit(EXIT_SUCCESS);
	}

	adapter_set_property_boolean(adapter, "Powered", TRUE);

	if (g_str_equal(mode, "discoverable"))
		adapter_set_property_boolean(adapter, "Discoverable", TRUE);
	else if (g_str_equal(mode, "connectable"))
		adapter_set_property_boolean(adapter, "Discoverable", FALSE);

	exit(EXIT_SUCCESS);
}
