#!/usr/bin/python2.5

import dbus
import sys

if len(sys.argv) < 2:
	print "Usage: %s <product name>" % sys.argv[0]
	sys.exit(1)

bus = dbus.SystemBus()

manager = dbus.Interface(bus.get_object("org.bluez", "/"), "org.bluez.Manager")
adapter = dbus.Interface(bus.get_object("org.bluez", manager.DefaultAdapter()),
							"org.bluez.Adapter")

properties = adapter.GetProperties()
powered = properties["Powered"]

if not powered:
	adapter.SetProperty("Powered", True)

for device in properties["Devices"]:
	adapter.RemoveDevice(device)

adapter.SetProperty("Name", sys.argv[1])
adapter.SetProperty("Discoverable", False)
adapter.SetProperty("DiscoverableTimeout", dbus.UInt32(0))
adapter.SetProperty("Powered", False)
