#ifndef DBUS_COMMON_H
#define DBUS_COMMON_H

#include <dbus/dbus-glib.h>
#include <glib.h>

DBusGProxy* bluez_get_manager(DBusGConnection *connection);
DBusGProxy* manager_get_default_adapter(DBusGProxy *manager,
					DBusGConnection *connection);
void adapter_set_property_string(DBusGProxy* adapter, const gchar* attribute,
							const gchar* value);
const gchar* adapter_get_property_string(DBusGProxy* adapter,
					const gchar* attribute);
gboolean adapter_get_property_boolean(DBusGProxy* adapter,
					const gchar* attribute);
void adapter_set_property_boolean(DBusGProxy* adapter, const gchar* attribute,
							const gboolean value);
void adapter_set_property_uint(DBusGProxy* adapter, const gchar* attribute,
								guint value);
guint adapter_get_property_uint(DBusGProxy* adapter,const gchar* attribute);
GPtrArray* adapter_get_property_objectpath_array(DBusGProxy* adapter,
						const gchar* attribute);
#endif
