
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "dbus-common.h"

int main(int argc, char* argv[])
{
	GError *error;
	DBusGConnection *conn;
	DBusGProxy *manager;
	DBusGProxy *adapter;
	GPtrArray *devices;
	guint i;
	gchar *product_name;
	gboolean powered;

	if (argc < 2) {
		g_debug("Usage: %s <product name>", argv[0]);
		exit(EXIT_FAILURE);
	}

	g_type_init();
	error = NULL;
	conn = dbus_g_bus_get(DBUS_BUS_SYSTEM, &error);

	if (error != NULL) {
		g_debug("Couldn't connect to bus: %s", error->message);
		g_error_free(error);
		exit(EXIT_FAILURE);
	}

	manager = bluez_get_manager(conn);
	adapter = manager_get_default_adapter(manager, conn);

	if (manager != NULL)
		g_object_unref(manager);

	product_name = argv[1];
	powered = adapter_get_property_boolean(adapter, "Powered");

	if (!powered)
		adapter_set_property_boolean(adapter, "Powered", TRUE);

	devices = adapter_get_property_objectpath_array(adapter, "Devices");

	for (i = 0; i < devices->len; ++i) {
		dbus_g_proxy_call(adapter, "RemoveDevice", &error,
					DBUS_TYPE_G_OBJECT_PATH,
					g_ptr_array_index(devices, i),
					G_TYPE_INVALID, G_TYPE_INVALID);

		if (error != NULL) {
			g_debug("error removing device: %s", error->message);
			g_error_free(error);
		}
	}

	adapter_set_property_string(adapter, "Name", product_name);
	adapter_set_property_boolean(adapter, "Discoverable", FALSE);
	adapter_set_property_uint(adapter, "DiscoverableTimeout", 0);
	adapter_set_property_boolean(adapter, "Powered", FALSE);

	if (adapter)
		g_object_unref(adapter);

	exit(EXIT_SUCCESS);
}
