/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla's Element Optimizeing extension.
 *
 * The Initial Developer of the Original Code is the Mozilla Foundation.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Oleg Romashin <romaxa@gmail.com> (original author)
 *   Brad Lassey <blassey@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef _NSWINDOWLISTENER_H_
#define _NSWINDOWLISTENER_H_

#include "nsCOMPtr.h"
#include "nsIDOMMouseMotionListener.h"
#include "nsIDOMMouseListener.h"
#include "nsIDOMFocusListener.h"
//#include "nsIDOMDragListener.h"
#include "nsIWebProgressListener.h"
#include "nsStringGlue.h"
#include "nsWeakReference.h"
#include "pluginSupport.h"
#include "panningMode.h"
#include "iScrollBars.h"

class nsIDOMEvent;
class HoverMode;
class InputMode;
class MonoMode;
class ModeSwitchWin;

class nsWindowListener : public nsIDOMMouseMotionListener,
  public nsIDOMMouseListener, public nsIDOMFocusListener,
  public nsIWebProgressListener,
  public nsSupportsWeakReference
{
public:
  nsWindowListener();
  virtual ~nsWindowListener();

  // nsIDOMMouseMotionListener
  NS_IMETHOD MouseMove(nsIDOMEvent *aDOMEvent);
  NS_IMETHOD DragMove(nsIDOMEvent *aMouseEvent);
  NS_IMETHOD HandleEvent(nsIDOMEvent *aDOMEvent);

  // nsIDOMMouseListener
  NS_IMETHOD MouseDown(nsIDOMEvent *aDOMEvent);
  NS_IMETHOD MouseUp(nsIDOMEvent *aDOMEvent);
  NS_IMETHOD MouseClick(nsIDOMEvent *aDOMEvent);
  NS_IMETHOD MouseDblClick(nsIDOMEvent *aDOMEvent);
  NS_IMETHOD MouseOver(nsIDOMEvent *aDOMEvent);
  NS_IMETHOD MouseOut(nsIDOMEvent *aDOMEvent);

  // nsIDOMFocusListener
  NS_IMETHOD Focus(nsIDOMEvent *aEvent);
  NS_IMETHOD Blur(nsIDOMEvent *aEvent);

  // nsIDOMDragListener
/*
  NS_IMETHOD DragEnter(nsIDOMEvent* aDOMEvent);
  NS_IMETHOD DragOver(nsIDOMEvent* aDOMEvent);
  NS_IMETHOD DragExit(nsIDOMEvent* aDOMEvent);
  NS_IMETHOD DragDrop(nsIDOMEvent* aDOMEvent);
  NS_IMETHOD DragGesture(nsIDOMEvent* aDOMEvent);
  NS_IMETHOD DragEnd(nsIDOMEvent* aDOMEvent);
  NS_IMETHOD Drag(nsIDOMEvent* aDOMEvent);
*/

  NS_DECL_ISUPPORTS
  NS_DECL_NSIWEBPROGRESSLISTENER

private:
  nsresult Init(void);

  //mode change process
  nsresult ModeChangeStart(nsIDOMEvent *aDOMEvent);
  nsresult ModeChangeEnd(nsIDOMEvent *aDOMEvent);

  PRBool CheckBlockSite(nsIDOMEvent *aDOMEvent);

public:
  nsresult SetBlockZoomEnabled(PRBool aEnabled);
  nsresult SetTouchScreenMode(PRInt32 aNewMode);
  PRInt32 TouchScreenMode() const;
  nsresult SetCursorVisible(PRBool aVisible);

private:

  PRBool mBlockSite;
  PRBool mMouseDown;
  PRBool mMonoEnable;
  PRInt32 mTouchScreenMode;

  PanningMode *mPanningMode;
  HoverMode *mHoverMode;
  InputMode *mInputMode;
  MonoMode *mMonoMode;
  ModeSwitchWin *mModeSwitchWin;
  nsString mBlockDomains;
  PRBool mCursorVisible;
  nsCOMPtr<iScrollBars> mSBars;
  nsIDOMWindow* mLastDOMWindow;
  PRBool mBlockZoomEnabled;

#ifdef PLUGIN_SUPPORT_ENABLED
public:
  PluginSupport& GetPluginSupport();
  PRBool IsPanning() const;
private:
  PluginSupport *mPluginSupport;
#endif // PLUGIN_SUPPORT_ENABLED
};

#define DISPATCH_MOUSE_EVENT(rv) do { \
  int tmpMode = mTouchScreenMode; \
  if(mBlockSite && (mTouchScreenMode == MODE_PANNING || mTouchScreenMode == MODE_MONO)) \
    tmpMode = MODE_DINPUT; \
  switch (tmpMode) \
  { \
    case MODE_PANNING: \
    { \
      NS_ENSURE_TRUE(mPanningMode, NS_ERROR_FAILURE); \
      rv = mPanningMode->OnPanning(aDOMEvent); \
      break; \
    } \
    case MODE_HOVER: \
    { \
      NS_ENSURE_TRUE(mHoverMode, NS_ERROR_FAILURE); \
      rv = mHoverMode->OnHover(aDOMEvent); \
      break; \
    } \
    case MODE_DINPUT: \
    { \
      NS_ENSURE_TRUE(mInputMode, NS_ERROR_FAILURE); \
      rv = mInputMode->OnInput(aDOMEvent); \
      break; \
    } \
    case MODE_MONO: \
    { \
      NS_ENSURE_TRUE(mMonoMode, NS_ERROR_FAILURE); \
      rv = mMonoMode->OnMono(aDOMEvent); \
      break; \
    } \
    default: \
      break; \
  } \
  }while(0);

#endif //_NSWINDOWLISTENER_H_
