#ifndef _INPUTMODE_H_
#define _INPUTMODE_H_

#include "nsISupports.h"
#include "nsCOMPtr.h"
#include "HelperFunctions.h"
#include "IbaseMode.h"

class nsIDOMEvent;
class nsIWidget;
class nsIViewManager;
class nsITimer;

class InputMode : public IBaseMode
{
public:
  InputMode();
  ~InputMode();

  nsresult OnInput(nsIDOMEvent *aDOMEvent);
  PRBool SetMouseDown(PRBool aMouseDown);
  PRBool CanShowCxtMenu();
  nsIDOMEvent* GetDOMEvent();

  NS_DECL_ISUPPORTS

private:
  nsresult Init();

  //input
  nsresult MouseDown(nsIDOMEvent *aDOMEvent);
  nsresult MouseMove(nsIDOMEvent *aDOMEvent);
  nsresult MouseUp(nsIDOMEvent *aDOMEvent);
  nsresult MouseClick(nsIDOMEvent *aDOMEvent);

  nsCOMPtr<nsIDOMEvent> mDOMEvent;
  nsIViewManager *mViewManager;
  PRBool mMouseDown;

  //mouse
  MouseEventArg mFirstMousedownEvent;
  MouseEventArg mLastMouseEvent;
  MouseEventArg mCurrentMouseEvent;
  DECLARE_MOUSE_DISPATCH(InputMode);

};

#endif //_INPUTMODE_H_
