#ifndef _HOVERMODE_H_
#define _HOVERMODE_H_

#include "nsISupports.h"
#include "nsCOMPtr.h"
#include "HelperFunctions.h"
#include "IbaseMode.h"

class nsIDOMEvent;
class nsIWidget;
class nsIViewManager;
class HoverToolTip;

class HoverMode : public IBaseMode
{
public:
  HoverMode();
  ~HoverMode();

  nsresult OnHover(nsIDOMEvent *aDOMEvent);

  NS_DECL_ISUPPORTS

private:
  nsresult Init();

  nsresult MouseDown(nsIDOMEvent *aDOMEvent);
  nsresult MouseMove(nsIDOMEvent *aDOMEvent);
  nsresult MouseUp(nsIDOMEvent *aDOMEvent);
  nsresult MouseOver(nsIDOMEvent *aDOMEvent);
  nsresult MouseOut(nsIDOMEvent *aDOMEvent);

  nsIViewManager *mViewManager;
  nsCOMPtr<nsIDOMEvent> mDOMEvent;
  PRBool mMouseDown;
  HoverToolTip *mToolTip;
  DECLARE_MOUSE_DISPATCH(HoverMode);

};

#endif //_HOVERMODE_H_
