#ifndef _IBASEMODE_H_
#define _IBASEMODE_H_

#include "nsISupports.h"

class nsIWidget;

class IBaseMode : public nsISupports
{
public:
  virtual PRBool SetMouseDown(PRBool aMouseDown) { return PR_FALSE; }
  virtual PRBool CanShowCxtMenu() { return PR_FALSE; };
  virtual nsIDOMEvent* GetDOMEvent() { return nsnull; };
  virtual nsresult ModifierActionEvent(PRInt32 aModifier) { return NS_OK; }

  //MotionListener
  virtual nsresult MouseMove(nsIDOMEvent *aDOMEvent) { return NS_OK; }
  virtual nsresult DragMove(nsIDOMEvent *aMouseEvent) { return NS_OK; }
  virtual nsresult HandleEvent(nsIDOMEvent *aDOMEvent) { return NS_OK; }

  // MouseListener
  virtual nsresult MouseDown(nsIDOMEvent *aDOMEvent) { return NS_OK; }
  virtual nsresult MouseUp(nsIDOMEvent *aDOMEvent) { return NS_OK; }
  virtual nsresult MouseClick(nsIDOMEvent *aDOMEvent) { return NS_OK; }
  virtual nsresult MouseDblClick(nsIDOMEvent *aDOMEvent) { return NS_OK; }
  virtual nsresult MouseOver(nsIDOMEvent *aDOMEvent) { return NS_OK; }
  virtual nsresult MouseOut(nsIDOMEvent *aDOMEvent) { return NS_OK; }

  // FocusListener
  virtual nsresult Focus(nsIDOMEvent *aEvent) { return NS_OK; }
  virtual nsresult Blur(nsIDOMEvent *aEvent) { return NS_OK; }

  // unsupported event
  virtual nsresult UnsupportedEvent(nsIDOMEvent *aEvent) { return NS_OK; }
};

#endif //_IBASEMODE_H_
