#include "speedmanager.h"
#include <stdio.h>

NS_IMPL_ISUPPORTS1(SpeedManager, nsISupports)

SpeedManager::SpeedManager() :
  mSpeed(0)
{
}
void
SpeedManager::AddSpeed(PRInt32 aTime, PRInt32 aDistance)
{
  PRInt32 temp = 0;
  if (aTime != 0)
    temp = aDistance * 100 / aTime;
  mSpeed = (mSpeed + temp) / 2;
}
void
SpeedManager::ClearSpeed()
{
  mSpeed = 0;
}
PRInt32
SpeedManager::GetSpeed()
{
  return mSpeed;
}

void
SpeedManager::SetSpeed(PRInt32 aSpeed)
{
  mSpeed = aSpeed;
}
