#ifndef _HOVERTOOLTIP_H_
#define _HOVERTOOLTIP_H_

#include "nsISupports.h"
#include <gtk/gtk.h>
#include "nsCOMPtr.h"
#include "nsStringGlue.h"
#include "HelperFunctions.h"

class nsIDOMEvent;
class nsITimer;

class HoverToolTip : public nsISupports
{
public:
  HoverToolTip();
  ~HoverToolTip();

  nsresult Init();
  nsresult ShowToolTip(nsIDOMEvent *aDOMEvent);
  nsresult HideToolTip();

  NS_DECL_ISUPPORTS

private:
  nsresult CreateToolTip();
  nsresult GetHref(nsIDOMEvent *aDOMEvent, nsString &aHerf);
  nsresult IsAURI(const nsString &aHerf);
  nsresult FixUpFileName(gchar* &aFileName);
  nsresult MoveToolTipWin();
  static void ShowToolTipCallback(nsITimer *timer, void *closure);
  static gint PaintToolTip(GtkWidget *aWindow);
  static gboolean TooltipWindowConfigured(GtkWidget *widget,
                                          GdkEventConfigure *event,
                                          gpointer user_data);

  GtkWidget *mToolTipWin;
  GtkWidget *mToolTipLabel;
  nsCOMPtr<nsITimer> mShowTooTipTimer;
  PRBool mShowToolTip;
  nsString mHerf;
  MouseEventArg mCurrentMouseArg;
  MouseEventArg mLastMouseArg;
};

#endif // HOVERTOOLTIP_H_
