#ifndef _PANNINGMODE_H_
#define _PANNINGMODE_H_

#include "nsCOMPtr.h"
#include "HelperFunctions.h"
#include "IbaseMode.h"
#include "nsISupports.h"
#include "iScrollBars.h"

class nsIDOMEvent;
class nsITimer;
class nsIWidget;
class nsIViewManager;
class SpeedManager;
class nsIDOMNSHTMLElement;
class nsWindowListener;

class PanningMode : public IBaseMode
{
public:
  PanningMode(nsWindowListener& aWindowListener, iScrollBars *aSBars = nsnull);
  virtual ~PanningMode();

  nsresult OnPanning(nsIDOMEvent *aDOMEvent);
  PRInt32 IsPanning();
  PRBool SetMouseDown(PRBool aMouseDown);
  PRBool CanShowCxtMenu();
  nsIDOMEvent* GetDOMEvent();
  PRBool IsDispatchEvent();

  NS_DECL_ISUPPORTS

  float GetZoomLevel(void) { return mMouseDownZoomLevel; };
private:
  nsresult Init(void);

  //panning
  nsresult MouseDown(nsIDOMEvent *aDOMEvent);
  nsresult MouseMove(nsIDOMEvent *aDOMEvent);
  nsresult MouseUp(nsIDOMEvent *aDOMEvent);
  nsresult MouseClick(nsIDOMEvent *aDOMEvent);
  nsresult DoPan(nsIDOMEvent *aDOMEvent, nsIViewManager* aViewManager, PRInt32 aDx, PRInt32 aDy);
  nsresult EndPan(PRBool aDelay = PR_FALSE);
  SpeedManager* GetSpeedMngX();
  SpeedManager* GetSpeedMngY();
  PRInt32 GetKineticPanStep();
  PRInt32 DetectPanningMode(nsIViewManager* aViewManager, PRInt32 aDx, PRInt32 aDy);

  //timer callback
  static void DoKineticPan(nsITimer *timer, void *closure);
  static void EndPanDelayCallBack(nsITimer *timer, void *closure);
  static void DispatchMouseEvent(nsITimer *timer, void *closure);

  nsresult ChangeFocus(nsIDOMEvent *aDOMEvent);

  //timer
  nsCOMPtr<nsITimer> mPanningTimer;
  nsCOMPtr<nsITimer> mEndPanTimer;

  //mouse
  MouseEventArg mFirstMousedownEvent;
  MouseEventArg mLastMouseEvent;
  MouseEventArg mCurrentMouseEvent;

  //other
  nsWindowListener& mWindowListener;
  nsCOMPtr<nsIDOMEvent> mDOMEvent;
  nsIViewManager* mViewManager;
  SpeedManager *mSpeedX;
  SpeedManager *mSpeedY;
  PRInt32 mKineticPanStep;
  PRBool mMouseDown;
  nsCOMPtr<nsIDOMNode> mFocusElement;
  PRInt32 mPanningMode;
  PRBool mHasDispatchEvent;
  nsCOMPtr<iScrollBars> mSBars;

  //static
  volatile static PRInt32 *sPanning;

  DECLARE_MOUSE_DISPATCH(PanningMode);
  float mMaxPressure;
  float mMouseDownZoomLevel;
};

#endif //_PANNINGMODE_H_
