#ifndef _MODESWITCHWIN_H_
#define _MODESWITCHWIN_H_

#include "nsISupports.h"
#include <gtk/gtk.h>
#include "nsCOMPtr.h"
#include "HelperFunctions.h"

class nsITimer;
class nsIDOMEvent;
class nsIDOMWindow;
class nsIDOMWindowInternal;
class nsIWidget;
class nsWindowListener;

class ModeSwitchWin : public nsISupports
{
public:
  ModeSwitchWin(nsWindowListener& aWindowListener);
  ~ModeSwitchWin();
  nsresult Init();

  nsresult ShowModeSwitchWin(PRInt32 aMode, nsIDOMEvent *aDOMEvent);
  nsresult HideModeSwitchWin(PRBool aDelay = PR_FALSE);
  nsresult HostWinFocus(nsIDOMEvent *aDOMEvent);
  nsresult HostWinBlur(nsIDOMEvent *aDOMEvent);
  nsresult UpdateFromEvent(nsIDOMEvent *aDOMEvent);

  NS_DECL_ISUPPORTS

private:
  void CreateModeSwitchWin(PRInt32 aMode = MODE_HOVER);

  static void HideWinCallback(nsITimer *timer, void *closure);
  static void OnClick(GtkWidget *widget, gpointer data);
  static void OnHide(GtkWidget *widget, gpointer data);
  nsresult UpdatePosition();
  nsresult UpdateIcon(PRBool aPanningOn);

  GtkWidget *mWindow;
  GtkWidget *mButton;
  GtkWidget *mParent;

  nsCOMPtr<nsITimer> mHideWinTimer;
  nsWindowListener& mWindowListener;
  nsIDOMWindow *mDOMWindow;
  nsCOMPtr<nsIDOMWindowInternal> mDOMWindowInternal;
  nsCOMPtr<nsIDOMEvent> mDOMEvent;
  PRBool mHostWinFocus;
  PRInt32 mModeSwitchWinX;
  PRInt32 mModeSwitchWinY;
  PRInt32 mZoomLevel;
};

#endif //_MODESWITCHWIN_H_
