/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Oleg Romashin <romaxa@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
#ifndef __EmbedTools_h
#define __EmbedTools_h

#include "nsCOMPtr.h"
#include "nsStringGlue.h"
#include "nsIDOMWindow.h"
#include "nsIWindowWatcher.h"
#include "nsIWebBrowserChrome.h"
#include "nsIEmbeddingSiteWindow.h"
#include "nsIServiceManager.h"
#include "nsIContentViewer.h"
#include "nsIDocShell.h"
#include "nsIInterfaceRequestorUtils.h"
#include <gtk/gtk.h>
#include "imgIRequest.h"
#include "nsIDOMNode.h"

GtkWidget*
GetGtkWidgetForDOMWindow(nsIDOMWindow* aDOMWindow);

GtkWindow*
GetGtkWindowForDOMWindow(nsIDOMWindow* aDOMWindow);

nsresult
GetContentViewer(nsIWebBrowser *webBrowser, nsIContentViewer **aViewer);

GtkWidget* GetAnyLiveWidget(void);

nsresult GetDOMWindowByNode (nsIDOMNode *aNode, nsIDOMWindow * *aDOMWindow);

nsresult GetImageRequest(imgIRequest **aRequest, nsIDOMNode *aDOMNode);

nsresult ScrollToSelectedNode(nsISupports *element);

nsresult CheckDomImageElement (nsIDOMNode *node, nsIDOMWindow *aDOMWindow, nsString& aHref, PRInt32 &aWidth,
                               PRInt32 &aHeight, PRUint32 *aSize = nsnull);
/* Helper Macros */

#define GLIB_IF_PTR_FUNC_NULL(_ptr, _func) \
  PR_BEGIN_MACRO                           \
    if (_ptr) {                            \
      _func(_ptr);                         \
      (_ptr) = 0;                          \
    }                                      \
  PR_END_MACRO

#define GLIB_SOURCE_IF_REMOVE(_ptr) GLIB_IF_PTR_FUNC_NULL(_ptr, g_source_remove)

#endif /* __EmbedTools_h */
