/*
  Copyright (C) 2008, 2009 Jiri Olsa <olsajiri@gmail.com>

  This file is part of the latrace.

  The latrace is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  The latrace is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the latrace (file COPYING).  If not, see 
  <http://www.gnu.org/licenses/>.
*/


#include "config.h"

static char spaces[] = "                                                                                                                                                                           ";

static int print_details(struct lt_config_shared *cfg, char *argdbuf)
{
	fprintf(cfg->fout, "%s\n", argdbuf);
	return 0;
}

#define PRINT_TID() \
do { \
	fprintf(cfg->fout, "%5d   ", (pid_t) syscall(SYS_gettid)); \
} while(0)

int lt_out_entry(struct lt_config_shared *cfg, const char *symname, char *lib_to, 
			char *argbuf, char *argdbuf)
{
	PRINT_TID();

	if (cfg->indent_depth && cfg->indent_sym)
		fprintf(cfg->fout, "%.*s", cfg->indent_depth * cfg->indent_size, spaces);

	if (*argbuf)
		fprintf(cfg->fout, "%s(%s) [%s] {\n", symname, argbuf, lib_to);
	else
		fprintf(cfg->fout, "%s [%s]\n", symname, lib_to);

	if (cfg->args_detailed && *argdbuf)
		print_details(cfg, argdbuf);

	fflush(NULL);
	return 0;
}

int lt_out_exit(struct lt_config_shared *cfg, const char *symname, char *lib_to, 
			char *argbuf, char *argdbuf)
{
	if (!*argbuf)
		return 0;

	PRINT_TID();

	if (cfg->indent_depth && cfg->indent_sym)
		fprintf(cfg->fout, "%.*s", cfg->indent_depth * cfg->indent_size, spaces);

	fprintf(cfg->fout, "} %s%s\n", symname, argbuf);

	if (cfg->args_detailed && *argdbuf)
		print_details(cfg, argdbuf);
	
	fflush(NULL);
	return 0;
}
