/*
  Copyright (C) 2008, 2009 Jiri Olsa <olsajiri@gmail.com>

  This file is part of the latrace.

  The latrace is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  The latrace is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the latrace (file COPYING).  If not, see 
  <http://www.gnu.org/licenses/>.
*/


%{

#include <string.h>

#include "config.h"
#include "args-bison.h"

struct lt_args_include* lt_args_buf_get(void);

%}

alphnum		[-0-9a-zA-Z_]
name		({alphnum})+
filename	([-0-9a-zA-Z\./])+

%x comment include
%%

"/*"			BEGIN(comment);
<comment>[^*\n]*	/* eat anything that's not a '*' */
<comment>"*"+[^*/\n]*	/* eat up '*'s not followed by '/'s */
<comment>\n		{ lt_args_buf_get()->lineno++; }
<comment>"*"+"/"	{ lt_args_buf_get()->lineno++; } BEGIN(INITIAL);

"#include"		{ BEGIN(include); return INCLUDE; }
<include>{filename}	{ yylval.s = strdup(yytext); return FILENAME; } 
<include>"\""		{ return '"'; }
<include>\n		{ BEGIN(INITIAL); }
<include>.		{ ; }

"extern"		{ ; }
"const"			{ ; }
<<EOF>>			{ return END; }
"struct"		{ return STRUCT; }
"typedef"		{ return TYPEDEF; }
{name}			{ yylval.s = strdup(yytext); return NAME; }   
"\*"			{ return '*'; }
")"			{ return ')'; }
"("			{ return '('; }
"}"			{ return '}'; }
"{"			{ return '{'; }
";"			{ return ';'; }
","			{ return ','; }
\			{ ; }
\n			{ lt_args_buf_get()->lineno++; }
.			{ ; }

%%

#ifndef yywrap
int yywrap()
{
	return 1; 
	/* XXX not to get the compiler 'not used' warning */
	yyunput(0, NULL); 
	input();
}
#endif

void yyerror(const char *m)
{
	printf("latrace config file [%s] line %d: %s\n", 
		lt_args_buf_get()->file, 
		lt_args_buf_get()->lineno++, 
		m); 
}
