/* GStreamer
 *
 * Copyright (C) 2002 Ronald Bultje <rbultje@ronald.bitfreak.net>
 *               2006 Edgard Lima <edgard.lima@indt.org.br>
 *               2008 Nokia Corporation <multimedia@maemo.org>
 *
 * v4l2camsrc.h - system calls
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __V4L2CAMSRC_CALLS_H__
#define __V4L2CAMSRC_CALLS_H__

#include "gstv4l2camsrc.h"

/* simple check whether the device is open */
#define GST_V4L2CAMSRC_IS_OPEN(v4l2camsrc) \
  (v4l2camsrc->video_fd > 0)

/* check whether the device is 'active' */
#define GST_V4L2CAMSRC_IS_ACTIVE(v4l2camsrc) \
  (v4l2camsrc->buffer != NULL)

/* checks whether the current v4lv4l2object has already been open()'ed or not */
#define GST_V4L2CAMSRC_CHECK_OPEN(v4l2camsrc)           \
  if (!GST_V4L2CAMSRC_IS_OPEN(v4l2camsrc))              \
{                                                       \
    GST_ELEMENT_ERROR (v4l2camsrc, RESOURCE, SETTINGS,  \
      ("Device is not open."), (NULL));                 \
    return FALSE;                                       \
}

/* checks whether the current v4lv4l2object is close()'ed or whether it is still open */
#define GST_V4L2CAMSRC_CHECK_NOT_OPEN(v4l2camsrc)       \
  if (GST_V4L2CAMSRC_IS_OPEN(v4l2camsrc))               \
{                                                       \
    GST_ELEMENT_ERROR (v4l2camsrc, RESOURCE, SETTINGS,  \
      ("Device is open."), (NULL));                     \
    return FALSE;                                       \
}

/* checks whether we're in capture mode or not */
#define GST_V4L2CAMSRC_CHECK_ACTIVE(v4l2camsrc)         \
  if (!GST_V4L2CAMSRC_IS_ACTIVE(v4l2camsrc))            \
{                                                       \
    GST_ELEMENT_ERROR (v4l2camsrc, RESOURCE, SETTINGS,  \
      (NULL), ("Device is not in streaming mode"));     \
    return FALSE;                                       \
}

/* checks whether we're out of capture mode or not */
#define GST_V4L2CAMSRC_CHECK_NOT_ACTIVE(v4l2camsrc)     \
  if (GST_V4L2CAMSRC_IS_ACTIVE(v4l2camsrc))             \
{                                                       \
    GST_ELEMENT_ERROR (v4l2camsrc, RESOURCE, SETTINGS,  \
      (NULL), ("Device is in streaming mode"));         \
    return FALSE;                                       \
}

/* open/close the device */
gboolean gst_v4l2camsrc_open             (GstV4l2CamSrc *v4l2camsrc);

gboolean gst_v4l2camsrc_close            (GstV4l2CamSrc *v4l2camsrc);

/* attribute control */
gboolean gst_v4l2camsrc_get_attribute    (GstV4l2CamSrc *v4l2camsrc,
                                          int             attribute,
                                          int            *value);

gboolean gst_v4l2camsrc_set_attribute    (GstV4l2CamSrc *v4l2camsrc,
                                          int             attribute,
                                          const int       value);

gboolean   gst_v4l2camsrc_get_capture    (GstV4l2CamSrc * v4l2camsrc);

gboolean   gst_v4l2camsrc_set_capture    (GstV4l2CamSrc * v4l2camsrc,
                                          guint32 pixelformat,
                                          guint32 width, guint32 height,
                                          guint32 fps_n, guint32 fps_d);

gboolean   gst_v4l2camsrc_capture_init   (GstV4l2CamSrc * v4l2camsrc,
                                          GstCaps *caps);

gboolean   gst_v4l2camsrc_capture_start  (GstV4l2CamSrc * v4l2camsrc);

GstFlowReturn gst_v4l2camsrc_grab_frame  (GstV4l2CamSrc * v4l2camsrc,
                                          GstBuffer **buf);

gboolean   gst_v4l2camsrc_capture_stop   (GstV4l2CamSrc * v4l2camsrc);

gboolean   gst_v4l2camsrc_capture_deinit (GstV4l2CamSrc * v4l2camsrc);

gboolean   gst_v4l2camsrc_fill_format_list  (GstV4l2CamSrc * v4l2camsrc);
gboolean   gst_v4l2camsrc_clear_format_list (GstV4l2CamSrc * v4l2camsrc);
void       gst_v4l2camsrc_empty_lists       (GstV4l2CamSrc *v4l2camsrc);

GstCaps*   gst_v4l2camsrc_probe_caps_for_format (GstV4l2CamSrc * v4l2camsrc,
                                                 guint32 pixelformat,
                                                 const GstStructure *template);

gboolean   gst_v4l2camsrc_update_cropping (GstV4l2CamSrc * v4l2camsrc,
                                           gint width, gint height,
                                           gfloat zoom);

#endif /* __V4L2CAMSRC_CALLS_H__ */
