/* GStreamer
 *
 * Copyright (C) 2008 Nokia Corporation <multimedia@maemo.org>
 *
 * gstv4l2photoiface.h: Photo interface implementation for v4l2camsrc
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_V4L2CAMSRC_PHOTOGRAPHY_H__
#define __GST_V4L2CAMSRC_PHOTOGRAPHY_H__

#include <gst/gst.h>
#include <gst/interfaces/photography.h>

#include "gstv4l2camsrc.h"

G_BEGIN_DECLS

/**
 * GstV4l2PhotoCapturePhase:
 * @GST_V4L2PHOTO_OFF: photo capturing functionality disabled.
 * @GST_V4L2PHOTO_VIEWFINDER: element is running in viewfinder mode.
 * @GST_V4L2PHOTO_AUTOFOCUS: element is running autofocus phase.
 * @GST_V4L2PHOTO_CAPTURE: element is capturing HQ image.
 * @GST_V4L2PHOTO_CAPTURE_DONE: finishing HQ capture operation.
 *
 * Photo capturing phases.
 */
typedef enum {
  GST_V4L2PHOTO_OFF = 0,
  GST_V4L2PHOTO_VIEWFINDER,
  GST_V4L2PHOTO_AUTOFOCUS,
  GST_V4L2PHOTO_CAPTURE_START,
  GST_V4L2PHOTO_CAPTURE,
  GST_V4L2PHOTO_CAPTURE_DONE
} GstV4l2PhotoCapturePhase;


/**
 * GstV4l2PhotoShakingRisk:
 * @GST_V4L2PHOTO_SHAKE_LOW: low risk
 * @GST_V4L2PHOTO_SHAKE_MEDIUM: medium risk
 * @GST_V4L2PHOTO_SHAKE_HIGH: high risk
 *
 * Risk level of blurred image as a result of shaking camera device.
 */
typedef enum {
  GST_V4L2PHOTO_SHAKE_LOW = 0,
  GST_V4L2PHOTO_SHAKE_MEDIUM,
  GST_V4L2PHOTO_SHAKE_HIGH
} GstV4l2PhotoShakingRisk;


void
gst_v4l2camsrc_photo_interface_init (GstPhotographyInterface * iface);

gboolean
gst_v4l2camsrc_photo_set_ev_compensation (GstV4l2CamSrc * v4l2camsrc,
                                          gfloat ev_comp);

gboolean
gst_v4l2camsrc_photo_get_ev_compensation (GstV4l2CamSrc * v4l2camsrc,
                                          gfloat *ev_comp);

gboolean
gst_v4l2camsrc_photo_set_iso_speed (GstV4l2CamSrc * v4l2camsrc,
                                    guint iso_speed);

gboolean
gst_v4l2camsrc_photo_get_iso_speed (GstV4l2CamSrc * v4l2camsrc,
                                    guint *iso_speed);

gboolean
gst_v4l2camsrc_photo_set_aperture (GstV4l2CamSrc * v4l2camsrc,
                                   guint aperture);

gboolean
gst_v4l2camsrc_photo_get_aperture (GstV4l2CamSrc * v4l2camsrc,
                                   guint *aperture);

gboolean
gst_v4l2camsrc_photo_set_exposure (GstV4l2CamSrc * v4l2camsrc,
                                   guint32 exposure);

gboolean
gst_v4l2camsrc_photo_get_exposure (GstV4l2CamSrc * v4l2camsrc,
                                   guint32 *exposure);

gboolean
gst_v4l2camsrc_photo_set_wb_mode (GstV4l2CamSrc * v4l2camsrc,
                                  GstWhiteBalanceMode mode);

gboolean
gst_v4l2camsrc_photo_get_wb_mode (GstV4l2CamSrc * v4l2camsrc,
                                  GstWhiteBalanceMode *mode);

gboolean
gst_v4l2camsrc_photo_set_tone_mode (GstV4l2CamSrc * v4l2camsrc,
                                    GstColourToneMode mode);

gboolean
gst_v4l2camsrc_photo_get_tone_mode (GstV4l2CamSrc * v4l2camsrc,
                                    GstColourToneMode *mode);

gboolean
gst_v4l2camsrc_photo_set_scene_mode (GstV4l2CamSrc * v4l2camsrc,
                                     GstSceneMode mode);

gboolean
gst_v4l2camsrc_photo_get_scene_mode (GstV4l2CamSrc * v4l2camsrc,
                                     GstSceneMode *mode);

gboolean
gst_v4l2camsrc_photo_set_flash_mode (GstV4l2CamSrc * v4l2camsrc,
                                     GstFlashMode mode);

gboolean
gst_v4l2camsrc_photo_get_flash_mode (GstV4l2CamSrc * v4l2camsrc,
                                     GstFlashMode *mode);

gboolean
gst_v4l2camsrc_photo_set_zoom (GstV4l2CamSrc * v4l2camsrc, gfloat zoom);

gboolean
gst_v4l2camsrc_photo_get_zoom (GstV4l2CamSrc * v4l2camsrc, gfloat *zoom);

void
gst_v4l2camsrc_photo_set_autofocus (GstV4l2CamSrc * v4l2camsrc, gboolean on);

gboolean
gst_v4l2camsrc_photo_prepare_for_capture (GstV4l2CamSrc * v4l2camsrc,
                                    GstPhotoCapturePrepared func,
                                    GstCaps *capture_caps,
                                    gpointer user_data);

GstPhotoCaps
gst_v4l2camsrc_photo_get_capabilities (GstV4l2CamSrc * v4l2camsrc);

void
gst_v4l2camsrc_photo_ready_for_capture (GstV4l2CamSrc *v4l2camsrc, GstCaps *selected);

gboolean
gst_v4l2camsrc_photo_set_config (GstV4l2CamSrc * v4l2camsrc, GstPhotoSettings * config);

gboolean
gst_v4l2camsrc_photo_get_config (GstV4l2CamSrc * v4l2camsrc, GstPhotoSettings * config);

#define GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, function_name, param_type) \
                                                                                      \
gboolean                                                                              \
interface_as_function ## _photo_set_ ## function_name (GstPhotography * photo,        \
                                                       param_type param)              \
{                                                                                     \
  Type *this = (Type*) photo;                                                         \
  return gst_v4l2camsrc_photo_set_ ## function_name (this, param);                    \
}                                                                                     \
                                                                                      \
gboolean                                                                              \
interface_as_function ## _photo_get_ ## function_name (GstPhotography * photo,        \
                                                       param_type * param)            \
{                                                                                     \
  Type *this = (Type*) photo;                                                         \
  return gst_v4l2camsrc_photo_get_ ## function_name (this, param);                    \
}


#define GST_IMPLEMENT_V4L2CAMSRC_PHOTO_METHODS(Type, interface_as_function)           \
                                                                                      \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, ev_compensation, gfloat)      \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, iso_speed, guint)             \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, aperture, guint)              \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, exposure, guint32)            \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, wb_mode, GstWhiteBalanceMode) \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, tone_mode, GstColourToneMode) \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, scene_mode, GstSceneMode)     \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, flash_mode, GstFlashMode)     \
GST_V4L2CAMSRC_PHOTO_FUNCS(Type, interface_as_function, zoom, gfloat)                 \
                                                                                      \
GstPhotoCaps                                                                          \
interface_as_function ## _photo_get_capabilities (GstPhotography * photo)             \
{                                                                                     \
  Type *this = (Type*) photo;                                                         \
  return gst_v4l2camsrc_photo_get_capabilities (this);                                \
}                                                                                     \
                                                                                      \
gboolean                                                                              \
interface_as_function ## _photo_prepare_for_capture (GstPhotography * photo,          \
                                                     GstPhotoCapturePrepared func,    \
                                                     GstCaps *capture_caps,           \
                                                     gpointer user_data)              \
{                                                                                     \
  Type *this = (Type*) photo;                                                         \
  return gst_v4l2camsrc_photo_prepare_for_capture (this, func,                        \
                                                   capture_caps, user_data);          \
}                                                                                     \
                                                                                      \
void                                                                                  \
interface_as_function ## _photo_set_autofocus (GstPhotography * photo,                \
                                               gboolean on)                           \
{                                                                                     \
  Type *this = (Type*) photo;                                                         \
  gst_v4l2camsrc_photo_set_autofocus (this, on);                                      \
}                                                                                     \
                                                                                      \
gboolean                                                                              \
interface_as_function ## _photo_set_config (GstPhotography * photo,                   \
                                            GstPhotoSettings * config)                \
{                                                                                     \
  Type *this = (Type*) photo;                                                         \
  return gst_v4l2camsrc_photo_set_config (this, config);                              \
}                                                                                     \
                                                                                      \
gboolean                                                                              \
interface_as_function ## _photo_get_config (GstPhotography * photo,                   \
                                            GstPhotoSettings * config)                \
{                                                                                     \
  Type *this = (Type*) photo;                                                         \
  return gst_v4l2camsrc_photo_get_config (this, config);                              \
}                                                                                     \
                                                                                      \
void                                                                                  \
interface_as_function ## _photo_interface_init (GstPhotographyInterface * iface)      \
{                                                                                     \
  iface->set_ev_compensation = interface_as_function ## _photo_set_ev_compensation;   \
  iface->get_ev_compensation = interface_as_function ## _photo_get_ev_compensation;   \
  iface->set_iso_speed = interface_as_function ## _photo_set_iso_speed;               \
  iface->get_iso_speed = interface_as_function ## _photo_get_iso_speed;               \
  iface->set_aperture = interface_as_function ## _photo_set_aperture;                 \
  iface->get_aperture = interface_as_function ## _photo_get_aperture;                 \
  iface->set_exposure = interface_as_function ## _photo_set_exposure;                 \
  iface->get_exposure = interface_as_function ## _photo_get_exposure;                 \
  iface->set_white_balance_mode = interface_as_function ## _photo_set_wb_mode;        \
  iface->get_white_balance_mode = interface_as_function ## _photo_get_wb_mode;        \
  iface->set_colour_tone_mode = interface_as_function ## _photo_set_tone_mode;        \
  iface->get_colour_tone_mode = interface_as_function ## _photo_get_tone_mode;        \
  iface->set_scene_mode = interface_as_function ## _photo_set_scene_mode;             \
  iface->get_scene_mode = interface_as_function ## _photo_get_scene_mode;             \
  iface->set_flash_mode = interface_as_function ## _photo_set_flash_mode;             \
  iface->get_flash_mode = interface_as_function ## _photo_get_flash_mode;             \
  iface->set_zoom = interface_as_function ## _photo_set_zoom;                         \
  iface->get_zoom = interface_as_function ## _photo_get_zoom;                         \
  iface->set_config = interface_as_function ## _photo_set_config;                     \
  iface->get_config = interface_as_function ## _photo_get_config;                     \
                                                                                      \
  iface->get_capabilities = interface_as_function ## _photo_get_capabilities;         \
  iface->prepare_for_capture = interface_as_function ## _photo_prepare_for_capture;   \
  iface->set_autofocus = interface_as_function ## _photo_set_autofocus;               \
                                                                                      \
  gst_v4l2camsrc_photo_interface_init (iface);                                        \
}                                                                                     \


#endif /* __GST_V4L2CAMSRC_PHOTOGRAPHY_H__ */
