/* GStreamer
 *
 * Copyright (C) 2001-2002 Ronald Bultje <rbultje@ronald.bitfreak.net>
 *               2006 Edgard Lima <edgard.lima@indt.org.br>
 *               2008 Nokia Corporation <multimedia@maemo.org>
 *
 * gstv4l2.c: plugin for v4l2 elements
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>

#include "gstv4l2camsrc.h"

/* used in v4l2cam_calls.c and v4l2camsrc_calls.c */
GST_DEBUG_CATEGORY (v4l2cam_debug);
GST_DEBUG_CATEGORY_EXTERN (v4l2camsrc_debug);

static gboolean
plugin_init (GstPlugin * plugin)
{
  GST_DEBUG_CATEGORY_INIT (v4l2cam_debug, "v4l2cam", 0, "V4L2 API calls");

  GST_DEBUG_CATEGORY_INIT (v4l2camsrc_debug, "v4l2camsrc", 0,
      "V4L2 camera source element");

  if (!gst_element_register (plugin, "v4l2camsrc", GST_RANK_NONE,
          GST_TYPE_V4L2CAMSRC))
    return FALSE;

#ifdef ENABLE_NLS
  setlocale (LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#endif /* ENABLE_NLS */

  return TRUE;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    "v4l2cam",
    "V4L2 camera image capturing element",
    plugin_init,
    VERSION,
    "LGPL",
    "Nokia", "www.nokia.com")
