[NAME]
functracer - list backtraces to tracked functions.

[DESCRIPTION]
\fBfunctracer\fR is a specialized, tracing-based debugging tool. It collects backtraces, arguments and return value of functions specified in a plugin. It works with optimized (-O2) code, where debugging symbols are available either in the application binaries themselves, or in separate debug files.

Currently, functracer has two plugins implemented: the "memory" (used by default, when no plugin is specified), "file",
"memtransfer", "gobject" and "thread-resource" plugins. They are installed in /usr/lib/functracer.

The memory plugin is used to track memory allocation usage (calloc, malloc, realloc, free, memalign, posix_memalign and valloc).

The file plugin is used to track file descriptor/pointer usage (open, fclose, open, close, fcloseall, creat, freopen, 
fdopen, accept, dup, dup2, socket,  socketpair, fcntl, pipe and inotify_init).

The memtransfer plugin is used to track memory transfer operations (memcpy, mempcpy, memmove, memccpy, memset, strcpy, strncpy,
stpcpy, stpncpy, strcat, strncat, bcopy, bzero, strdup, strndup, strdupa, strndupa, wmemcpy, wmempcpy, wmemmove, 
wmemset, wcscpy, wcsncpy, wcpcpy, wcpncpy, wcscat, wcsncat, wcsdup).

The gobject plugin is used to track GObject allocation and release (g_object_newv, g_object_ref, g_object_unref).

The thread-resource plugin is used to track resource allocation/release by creating/joining threads
(pthread_create, pthread_join, pthread_detatch).

The function format output is defined below:

- for resource allocation functions:
.RS 1
.IP
 <index>. [timestamp] <function name>(<size>) = <resource ID>
.br
 [backtrace functions]
.RE

- for resource free functions:
.RS 1
.IP
 <index>. [timestamp] <function name>(<resource ID>)
.br
 [backtrace functions]
.RE

For examble, on the memory plugin the resource allocation functions (e.g. calloc, malloc, memalign, realloc) are tracked and functracer reports the following:

 function size   resource
   name    |      address
    |      |        |
    v      v        v
.br
0. malloc(456) = 0x0896adb0
   0x0804868c            ---
   0xb7e87118              |-> backtrace lines
   0xb7d94e6d            ---

For functions that perform both resource allocation and destruction (e.g. realloc), it will be produced two separate events, first the destruction event, then the allocation one. For example, if source code does:

realloc(0x001ae840, 16) = 0x001ae858

Functracer will produce the following trace events:

0. realloc(0x001ae840)       <- destruction event
.br
1. realloc(16) = 0x001ae858  <- allocation event
   [backtrace lines]

.SH OPTIONS

[EXAMPLES]
There are some ways to use this tool. For a small C code below:

 static void do_backtrace(void)
 {	
 	free(realloc(NULL, 200));
 }

 static void do_backtrace_wrapper(char *fmt, ...)
 {
        do_backtrace();
 }

 #define def_func(func, callee) \\
.br
         static void func(char *fmt, ...) { \\
.br
         callee("xyz", &func); \\
         }                                         

 def_func(h, do_backtrace_wrapper)                                
 def_func(g, h)                                
 def_func(f, g)

 int main(void)
 {
	 f("xyz", &main);

	 return 0;
 }

After running functracer, we have the following output:

.br
 # functracer -s -r ./my_program
 generated by functracer 0.14, with resolved names, arm-unknown-linux-gnueabi, 2009-01-20 10:38:54.796569
 PID 1597, ./my_program
 Process 1597 (./my_program) was created
 /lib/ld-2.5.so => 0x40000000-0x4001b000
 /root/my_program => 0x00008000-0x00009000
 /lib/libc-2.5.so => 0x40038000-0x4013c000
 0. realloc(200) = 0x00011008
    0x000085b3: do_backtrace_wrapper+0x18
    0x000085f3: h+0x18
    0x00008623: g+0x18
    0x00008653: f+0x18
    0x0000867f: main+0x14
    0x4004c10b: __libc_start_main+0x108
    0x0000851b: _start+0x28
 1. free(0x00011008)
 Process/Thread 1597 has exited with code 0

[NOTES]
- The built-in symbol resolving in functracer (option "-r") has some limitations compared to the postprocessor symbol resolving (functracer-postproc):
.br
	- it does not resolve source file name and line number.
.br
	- it does not do demangling for C++ symbol names (low-level symbol names into human readable names).

- To see the list of process invocations, just type the following where the trace files were saved:
.br
	# grep ^Process allocs*.trace

.br
- Note that messages in allocs*.trace about processes use "process/thread" instead of just "process". This is a ptrace limitation, because it does not distinguish between threads and process IDs.

.br
- To control the dumping of output files, just send SIGUSR1 to the tracked application (NOT functracer itself) to toggle the tracing on/off. Tracing is not enabled by default on application start, unless "-s" option is used.

.br
- The output file is created by default in the current user home directory. This can be changed using the -l option. The file is named "allocs-<PID>.<n>.trace".

.br
- There is a noticeable impact on the traced program performance.

For complete information, see README.

[AUTHOR]
\fBFunctracer\fR has been developed by:

.br
Anderson Lizardo <anderson.lizardo@indt.org.br>
.br
Allan Bezerra <allan.bezerra@indt.org.br>
.br
Bruna Moreira <bruna.moreira@indt.org.br>
.br
Bruno Abinader <bruno.abinader@indt.org.br>
.br
Ricardo Guimaraes <ricardo.guimaraes@indt.org.br>
.br
Thiago Santos <thiago.santos@indt.org.br>

[COPYRIGHT]
Copyright (C) 2008, 2009 Nokia Corporation.

This is free software.  You may redistribute copies of it under the terms
of the GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.
There is NO WARRANTY, to the extent permitted by law.

[SEE ALSO]
\fBfunctracer-postproc (1) \fR


