#ifndef FAKEROOT_COMMUNICATE_H
#define FAKEROOT_COMMUNICATE_H

#include "config.h"
#include "fakerootconfig.h"

#define LCHOWN_SUPPORT

/* I've got a chicken-and-egg problem here. I want to have
   stat64 support, only running on glibc2.1 or later. To
   find out what glibc we've got installed, I need to 
   #include <features.h>.
   But, before including that file, I have to define _LARGEFILE64_SOURCE
   etc, cause otherwise features.h will not define it's internal defines.
   As I assume that pre-2.1 libc's will just ignore those _LARGEFILE64_SOURCE
   defines, I hope I can get away with this approach:
*/
  
/*First, unconditionally define these, so that glibc 2.1 features.h defines
  the needed 64 bits defines*/
#ifndef _LARGEFILE64_SOURCE
# define _LARGEFILE64_SOURCE 
#endif
#ifndef _LARGEFILE_SOURCE
# define _LARGEFILE_SOURCE 
#endif

/* Then include features.h, to find out what glibc we run */
#ifdef HAVE_FEATURES_H
#include <features.h>
#endif

#ifdef HAVE_SYS_FEATURE_TESTS_H
#include <sys/feature_tests.h>
#endif

/* Then decide whether we do or do not use the stat64 support */
#if defined(sun) || __GLIBC__ > 2 || (__GLIBC__ == 2 && __GLIBC_MINOR__ >= 1)
#define STAT64_SUPPORT
#else
#warning Not using stat64 support
/* if glibc is 2.0 or older, undefine these again */
#undef STAT64_SUPPORT
#undef _LARGEFILE64_SOURCE 
#undef _LARGEFILE_SOURCE 
#endif

/* Sparc glibc 2.0.100 is broken, dlsym segfaults on --fxstat64.. 
#define STAT64_SUPPORT */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utsname.h>

#include "message.h"

#define FAKEROOTUID_ENV           "FAKEROOTUID"
#define FAKEROOTGID_ENV           "FAKEROOTGID"
#define FAKEROOTEUID_ENV          "FAKEROOTEUID"
#define FAKEROOTEGID_ENV          "FAKEROOTEGID"
#define FAKEROOTDONTTRYCHOWN_ENV  "FAKEROOTDONTTRYCHOWN"

#define FD_BASE_ENV               "FAKEROOT_FD_BASE"

#define FAKELIBDIR                "/usr/lib/fakeroot"
#define FAKELIBNAME               "libfakeroot.so.0"

#ifdef __GNUC__
#  define UNUSED __attribute__((unused))
#else 
#  define UNUSED 
#endif

#ifndef S_ISTXT
#  define S_ISTXT S_ISVTX
#endif

#ifndef ALLPERMS
#  define ALLPERMS (S_ISUID|S_ISGID|S_ISVTX|S_IRWXU|S_IRWXG|S_IRWXO)/* 07777 */
#endif

/* func_id values */
enum { chown_func,
/*2*/  chmod_func,
/*3*/  mknod_func, 
       stat_func,
/*5*/  unlink_func,
       debugdata_func,
       reqoptions_func,
       last_func };

#ifdef __cplusplus
extern "C" {
#endif

  extern const char *env_var_set(const char *env);
  extern void send_stat(const struct stat *st, func_id f);
  extern void send_fakem(const struct fake_msg *buf);
  extern void send_get_stat(struct stat *buf);

#ifdef STAT64_SUPPORT  
  extern void stat64from32(struct stat64 *s64, const struct stat *s32);
  extern void stat32from64(struct stat *s32, const struct stat64 *s64);
#endif

  extern void close_comm_sd(void);

#ifdef __cplusplus
}
#endif

#endif
