/* example_reminder_status_applet.c */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "example_reminder_status_applet.h"
#include <hildon/hildon.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <math.h> /* For M_PI. */
#include <glib/gi18n-lib.h> /* Declares _(). */
#include <time.h>

/** TODO: Describe this.
 * 
 */
 
/** This is like G_DEFINE_TYPE(), but it also 
 * implements standard functions such as hd_plugin_module_load(), 
 * which hildon-status-menu expects to be able to call on this library.
 */
HD_DEFINE_PLUGIN_MODULE (ExampleReminderStatusApplet, example_reminder_status_applet,
  HD_TYPE_STATUS_MENU_ITEM)

#define GCONF_KEY_REMINDER_HOURS "/apps/example_reminder_status_applet/hours"
#define GCONF_KEY_REMINDER_MINUTES "/apps/example_reminder_status_applet/minutes"

static void
example_reminder_status_applet_update_reminder_timeout (ExampleReminderStatusApplet *self);

gboolean example_reminder_status_applet_on_timeout (gpointer data)
{
  ExampleReminderStatusApplet *self = EXAMPLE_REMINDER_STATUS_APPLET (data);
  g_assert (self);
  
  /* Show a banner for the reminder: */
  hildon_banner_show_information (GTK_WIDGET (self),
    NULL, /* icon_name - ignored */
    _("Example Reminder"));
  
  /* Make sure the next timeout will happen at the right time: */
  example_reminder_status_applet_update_reminder_timeout (self);
  
  return FALSE; /* Do not emit this particular timeout again. */ 
}

/** Save the values to GConf,
 * and set our timeout handler to be called at the appropriate time.
 */
static void
example_reminder_status_applet_update_reminder_timeout (ExampleReminderStatusApplet *self)
{
  /* Save the values to GConf: */
  GConfClient *gconf_client = gconf_client_get_default ();
  
  GError* err = NULL;
  gconf_client_set_int (gconf_client, 
    GCONF_KEY_REMINDER_HOURS, self->reminder_hours, &err);
  if (err) {
    g_warning ("Error while saving preferences to gconf: %s", err->message);
    g_clear_error (&err);
  }
  
  gconf_client_set_int (gconf_client, 
    GCONF_KEY_REMINDER_MINUTES, self->reminder_minutes, &err);
  if (err) {
    g_warning ("Error while saving preferences to gconf: %s", err->message);
    g_clear_error (&err);
  }
  

  /* Setup the timout handler: */
  if (self->timeout_handler)
    g_source_remove (self->timeout_handler);
    
  /* Calculate the timeout interval by comparing to the current time: */
  time_t t = time(0); /* Gets the current Unix time. */
  struct tm the_c_time = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
  localtime_r(&t, &the_c_time); /* Gets the broken-down local time. */

  guint seconds_reminder = 
    (self->reminder_hours * 60 * 60 + self->reminder_minutes * 60);
  if(seconds_reminder > 60)
    seconds_reminder -= 60; /* Remind at the _start_ of the minute. */
  guint seconds_current =
    (the_c_time.tm_hour * 60 * 60 + the_c_time.tm_min * 60);

  
  guint interval = 0;
  if(seconds_reminder >= seconds_current)
    interval = seconds_reminder - seconds_current;
  else
    interval = (24 * 60 * 60) - (seconds_current - seconds_reminder);
    
  self->timeout_handler = 
    g_timeout_add_seconds (interval, 
      &example_reminder_status_applet_on_timeout, self);
      
  
}

static void 
example_reminder_status_applet_on_settings_dialog_response (GtkDialog *dialog,
  gint response_id G_GNUC_UNUSED, gpointer user_data)
{
  ExampleReminderStatusApplet *self = EXAMPLE_REMINDER_STATUS_APPLET (user_data);
  g_assert (self->settings_window);
  g_assert (self->settings_window == GTK_WIDGET (dialog));
  
  /* Get the chosen time from the dialog: */
  hildon_time_button_get_time (HILDON_TIME_BUTTON (self->time_button), 
    &(self->reminder_hours), &(self->reminder_minutes));  
  
  gtk_widget_destroy (self->settings_window);
  self->settings_window = NULL;
  self->time_button = NULL;
  
  example_reminder_status_applet_update_reminder_timeout (self);
}

static void 
example_reminder_status_applet_on_button_clicked (GtkButton *widget G_GNUC_UNUSED, 
  gpointer user_data)
{
  ExampleReminderStatusApplet *self = EXAMPLE_REMINDER_STATUS_APPLET (user_data);
  g_assert(self);
 
  if (!self->settings_window) {
    /* The Hildon HIG says "Dialogs should be used for small tasks" so 
     * we use GtkDialog instead of HildonWindow: */
    self->settings_window = gtk_dialog_new_with_buttons(
      _("Reminder Status Applet Settings"), 
      NULL /* parent window */, 
      GTK_DIALOG_NO_SEPARATOR /* flags */, 
      GTK_STOCK_CLOSE, GTK_RESPONSE_OK, 
      NULL);
    g_signal_connect (self->settings_window, "response", 
      G_CALLBACK (example_reminder_status_applet_on_settings_dialog_response), 
      self);
     
    /* TODO: Should we use HILDON_MARGIN_* here, or something else. 
     * They are undocumented:
     * https://bugs.maemo.org/show_bug.cgi?id=4462
     * https://bugs.maemo.org/show_bug.cgi?id=4463
     * https://bugs.maemo.org/show_bug.cgi?id=4464
     */
    GtkWidget *vbox = GTK_DIALOG(self->settings_window)->vbox;
    gtk_container_set_border_width(GTK_CONTAINER (vbox), HILDON_MARGIN_DEFAULT);
    
    GtkWidget *hbox = gtk_hbox_new (FALSE, HILDON_MARGIN_DEFAULT);
    gtk_box_pack_start (GTK_BOX (vbox), 
      hbox, TRUE, TRUE, HILDON_MARGIN_DEFAULT);
    gtk_widget_show (hbox);
                 
    self->time_button = hildon_time_button_new (HILDON_SIZE_AUTO, 
      HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    gtk_widget_show (self->time_button);
    
    /* Set the title that will be used for the dialog shown by the button: */
    hildon_button_set_title (HILDON_BUTTON (self->time_button), 
      _("Reminder Time"));
          
    gtk_box_pack_start (GTK_BOX (hbox), self->time_button, TRUE, TRUE, 0);
  }

  
  hildon_time_button_set_time (HILDON_TIME_BUTTON (self->time_button), 
    self->reminder_hours, self->reminder_minutes);
  
    
  gtk_widget_show (self->settings_window);
}

static void
example_reminder_status_applet_dispose (GObject *object)
{
  ExampleReminderStatusApplet *self = EXAMPLE_REMINDER_STATUS_APPLET (object);
 
  if (self->settings_window) {
    gtk_widget_destroy (self->settings_window);
    self->settings_window = NULL;
    self->time_button = NULL;
  }
  
  /* Call the base class's implementation: */
  G_OBJECT_CLASS (example_reminder_status_applet_parent_class)->dispose (object);
}

static void
example_reminder_status_applet_finalize (GObject *object)
{
  /* Call the base class's implementation: */
  G_OBJECT_CLASS (example_reminder_status_applet_parent_class)->finalize (object);
}

static void
example_reminder_status_applet_class_init (ExampleReminderStatusAppletClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->dispose = example_reminder_status_applet_dispose;
  object_class->finalize = example_reminder_status_applet_finalize;
}

static void
example_reminder_status_applet_class_finalize (ExampleReminderStatusAppletClass *klass G_GNUC_UNUSED)
{
}

static GdkPixbuf* load_icon(gint size)
{
  GError *error = NULL;
  GdkPixbuf *pixbuf = gtk_icon_theme_load_icon (gtk_icon_theme_get_default (),
	  "example-reminder-status-applet",
		 size, GTK_ICON_LOOKUP_NO_SVG, &error);
		 
  if (error) {
    g_warning ("gtk_icon_theme_load_icon() failed: %s\n", error->message);
    g_clear_error (&error);
    

    /* Output the icon theme search path to help us with debugging: */
    GtkIconTheme *icon_theme = gtk_icon_theme_get_default ();
    
    gchar** search_path = NULL;
    gint n_elements = 0;
    gtk_icon_theme_get_search_path (icon_theme, &search_path, &n_elements);
    
    if(n_elements == 0 || !search_path) {
      g_warning ("gtk_icon_theme_get_search_path() returned no paths.\n");
    }
    
    gint i = 0;
    for(i = 0; i < n_elements; i++) {
      gchar* path = search_path[i];
      g_warning ("icon theme search path %d: %s\n", i, path);
    }
    
    g_strfreev (search_path);
  }
  
  /* Fall back to the stock missing image item, which is likely to exist: */
  if (!pixbuf) {
    pixbuf = gtk_icon_theme_load_icon (gtk_icon_theme_get_default (),
	  "gtk-missing-image",
		 size, GTK_ICON_LOOKUP_NO_SVG, &error);
		
		if (error) {
		  g_warning ("gtk_icon_theme_load_icon() failed: %s\n", error->message);
      g_clear_error (&error);
		}
		
		if (pixbuf) {
		  g_warning ("load_icon(): Successfully fell back to the stock missing image icon.\n");
		}	 
	}
  
  return pixbuf;
}

static void
example_reminder_status_applet_init (ExampleReminderStatusApplet *self)
{
  /* Initialize these from the stored settings in gconf: */
  GConfClient *gconf_client = gconf_client_get_default ();
  
  GError* err = NULL;
  self->reminder_hours = gconf_client_get_int (gconf_client, 
    GCONF_KEY_REMINDER_HOURS, &err);
  if (err) {
    g_warning ("Error while reading preferences from gconf: %s", err->message);
    g_clear_error (&err);
  }
  
  self->reminder_minutes = gconf_client_get_int (gconf_client, 
    GCONF_KEY_REMINDER_MINUTES, &err);
  if (err) {
    g_warning ("Error while reading preferences from gconf: %s", err->message);
    g_clear_error (&err);
  }
  
  
  /* Add a button to the status menu: */
  self->button = 
    hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
		  HILDON_BUTTON_ARRANGEMENT_VERTICAL, 
		  _("Reminders"), _("View and edit reminders"));
  gtk_widget_show (self->button);
  gtk_container_add (GTK_CONTAINER (self), self->button);  
  
  g_signal_connect (self->button, "clicked", 
    G_CALLBACK (example_reminder_status_applet_on_button_clicked), self);
  
  /* Add an icon to the status menu button: */
  /* TODO: Don't hard-code 48:
   * See bug https://bugs.maemo.org/show_bug.cgi?id=4387 */
  GdkPixbuf *pixbuf = load_icon (48);
  if (pixbuf) {
    GtkWidget *image = gtk_image_new_from_pixbuf (pixbuf);
    hildon_button_set_image (HILDON_BUTTON (self->button), image);
    gdk_pixbuf_unref(pixbuf);
    pixbuf = NULL;
  }
  
  /* Show the icon */
  /* 18x18 pixels is the documented size for this: */
  pixbuf = load_icon (18);
  if (pixbuf) {
    hd_status_plugin_item_set_status_area_icon (HD_STATUS_PLUGIN_ITEM (self),
      pixbuf);
    gdk_pixbuf_unref(pixbuf);
    pixbuf = NULL;
  }

  /* Always show the status applet: */
  gtk_widget_show (GTK_WIDGET (self));
}

ExampleReminderStatusApplet*
example_reminder_status_applet_new (void)
{
  return g_object_new (EXAMPLE_TYPE_REMINDER_STATUS_APPLET, NULL);
}


