/*
 * @file crash-reporter-handler.h
 *
 * This file contains the function headers
 * for  crash-reporter-handler.c.
 *
 * This file is part of crash-reporter
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef CREPORTER_HANDLER_H
#define CREPORTER_HANDLER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libintl.h>

#define _(String) dgettext(PACKAGE,String)

#define CREPORTER_GCONF_CONNECTION_STATUS_DIR	"/apps/osso/crash-reporter/connection"
#define CREPORTER_GCONF_CONNECTION_STATUS	CREPORTER_GCONF_CONNECTION_STATUS_DIR"/Connection"
#define CREPORTER_GCONF_DELETE_STATUS		"/apps/osso/crash-reporter/deleteAfterSending"

#define CREPORTER_BASE 9000
#define CREPORTER_NO_SETTINGS_ERROR		(CREPORTER_BASE+1)
#define CREPORTER_CURL_COULD_NOT_CONN_ERROR	(CREPORTER_BASE+2)
#define CREPORTER_CURL_FILE_NOT_FOUND	(CREPORTER_BASE+2)

typedef enum {
	CONN_NOT_INITIATED,
	CONN_INITIATED,
	CONN_CONNECTED,
	CONN_DISCONNECTED
} creporterConnectionState;

/**
  This function is to initiate a connection to the default IAP.
  Uploading of the raw data file will be done in the connection
  callback function after successful connection to IAP is made.

  @param void
  @return TRUE on success else FALSE.
  */
gboolean creporter_connect_iap(void);

/**
  This function will initialize the creporter_libs

  @param void
  @return if success TRUE  else FALSE
  */
gboolean creporter_libs_init(void);


/**
  This function will store the creporterConnectionState value as gconf data

  @param creporterConnectionState value
  @return TRUE if success else FALSE
  */
gboolean creporter_libs_gconf_set_connc_status(creporterConnectionState val);

/**
  This function will get the creporterConnectionState value from gconf file

  @param creporterConnectionState value
  @return TRUE if success else FALSE
  */
gboolean creporter_libs_gconf_get_connc_status(creporterConnectionState *val);

/**
  This function uploads the files to the configured server

  @param the text_uri of the file to upload
  @return CREPORTER_ERROR in case of failure else CREPORTER_SUCCESS
*/
/*
 * context to be passed as arg
 */
typedef struct _crash_upload_context crash_upload_context;
#define SERVER_RESPONSE_SZ (2048)
struct _crash_upload_context
{
    gchar filename[256];
    creporterSettings *settings;
    gint rv;
    gchar server_response[SERVER_RESPONSE_SZ];
    gint server_response_sz;
    gint http_resp_code;
    gint curl_status;
};
gint thread_creporter_upload(crash_upload_context *);


#endif
