/**
 * @file crash-reporter-ui-utils.h
 * 
 * This file contains the Crash Reporter UI utils prototyping 
 *
 * This file is part of crash-reporter
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef CREPORTER_UI_UTILS_FILE_H
#define CREPORTER_UI_UTILS_FILE_H

#define DESKTOP_DIR_PATH	"/usr/share/applications/hildon"
#define URL			"url"

typedef enum {
	CONF_USER_CONFIRMATION1,
	CONF_USER_CONFIRMATION2,
	CONF_CONNECTION_ERROR,
	CONF_CURL_ERROR,
	CONF_NO_SERVER_DETAILS,
	CONF_FILE_SENT,
	NO_MORE_DUPS
}creporterConfirmationType;

/**
  This function set the connection status callback notifiers 
  
  @param void
  @param void
*/
void creporter_ui_set_connec_callback_notifiers(void);

/**
  This function asks and takes the user confirmation
  and establishes the iap connection

  @param gboolean TRUE when need to send all files
  		   FALSE when only one file is to be send
  @param void		   
*/		   
void creporter_ui_ask_user_conf(gboolean send_all_files_mode);


/**
  This function appends all the files present in both the 'core-dumps'
  directories into the 'files_list'. This is called when Crash Reporter UI app
  needs to send all files
  
  @param void
  @param TRUE if success else FALSE
*/
gboolean creporter_ui_collect_all_corefile_names(void);

/**
  This function is called to upload all the files that stored in files_list
  This will call the Crash Reporter library APIs to upload the each file

  @param: pointers to attempted, succeeded counters
  @return void
*/
#if 0
gint creporter_ui_upload_files(gint *, gint *);
#endif
/**
  This function is called to exit the Crash Reporter UI application

  @param void
  @return void 
  */
void creporter_ui_exit(void);

extern struct core_location_reg * core_location_registry;

/**
  This function is used to display all the notes in the appl.

  @param the type note to be displayed
  @return the response from the user
  */
gint creporter_ui_display_note(creporterConfirmationType conf_type, crash_upload_context * ctx);

#endif
