/**
 * @file crash-reporter-upload.h
 * 
 * This file contains the function prototypes used for uploading the files.
 *
 * This file is part of crash-reporter
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

typedef enum {
	HTTP_RESP_OK = 0,
	HTTP_RESP_AUTH_FAIL,
	HTTP_RESP_OTHER_ERROR
} httpRespCode;

/**
  Function to upload raw data to server

  @param gchar * is the pointer to upload file name
  @param gchar * is the pointer to settings about server

  @return gint - returns the https response code
*/
gint upload (crash_upload_context * ctx);
