/*
 * @file crash-reporter-settings-dialog.h
 *
 * This file contains the implementation of
 * Crash Reporter settings dialog.
 *
 * This file is part of crash-reporter
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef CREPORTER_SETTINGS_DIALOG_H_
#define CREPORTER_SETTINGS_DIALOG_H_

#include <glib.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <libosso.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define _(String) dgettext(PACKAGE,String)

#define SCRIPT				"/etc/init.d/crash-reporter"
#define MMC_PRESENT    			"/system/osso/af/mmc-device-present"
#define INTERNAL_MMC_PRESENT    	"/system/osso/af/internal-mmc-device-present"

#define PRIVACY_STATEMENT_FILE		"/usr/share/crash-reporter-settings/privacy.txt"


typedef struct _creporterData  creporterData;

/**
 *   This structure has the elements for
 *   settings dialog
 **/
struct _creporterData {
	GtkWidget* checkbox_dumping_enabled;
	GtkWidget* checkbox_sending_enabled;
	GtkWidget* checkbox_avoid_dups;
	GtkWidget* checkbox_include_core;
	GtkWidget* checkbox_include_syslog;
	GtkWidget* checkbox_include_pkglist;

	GtkWidget* caption_what_to_include;
	GtkWidget* caption_dumping_enabled;
	GtkWidget* caption_sending_enabled;
	GtkWidget* caption_avoid_dups;
	GtkWidget *caption_privacy;
	GtkWidget *caption_include_core;
	GtkWidget *caption_include_syslog;
	GtkWidget *caption_include_pkglist;
};

typedef enum {
	CP_RESPONSE_OK,
	CP_RESPONSE_SEND_ALL,
	CP_RESPONSE_DISCLAIMER
} CpDialogResponse;

typedef enum {
	CP_CONF_OK,
	CP_CONF_CANCEL
} CpConfResponse;

/**
  This function is called for creation of settings dialog.
  
  @param data is the pointer to the creporterData struct
  @param context is the pointer to the osso context
  
  @return none 
  */
void 
creporter_cp_dialog_create(gpointer data,osso_context_t *context);

extern struct core_location_reg * core_location_registry;

#endif
