/**
 * @file crash-reporter-common.h
 *
 * This file contains the common function prototypes and defs
 * for Maemo Crash Reporter.
 *
 * This file is part of Crash Reporter
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/*
 * common defs
 */
#define CRASH_REPORTER_DAEMON		"crash_reporter_daemon"
#define CRASH_REPORTER_UI          	"crash_reporter_ui"

#define ROOTFS_LOCATION 	"/"

/* ERROR CODES */
#define CREPORTER_SUCCESS 0
#define CREPORTER_CANCEL -2

#define NUM_ENV_MOUNTPOINTS 2
#define NUM_STATIC_MOUNTPOINTS 3
#define MAX_CORE_DIRS (NUM_ENV_MOUNTPOINTS + NUM_STATIC_MOUNTPOINTS + 1)
#define MAX_MOUNTPOINT_NAMELEN (128)

#define CREPORTER_SERVICE		CRASH_REPORTER_UI
#define CREPORTER_METHOD_SEND_FILE	"crash_reporter_send_file"
#define CREPORTER_METHOD_SEND_ALL	"crash_reporter_send_all_files"
#define CREPORTER_METHOD_DUPS_NOTE	"crash_reporter_dups_note"

#define MAX_SIMILAR_RCORES (10)

#define FILE_PERMISSION 	0777

struct core_location_reg {
    char mountpoint[MAX_MOUNTPOINT_NAMELEN];
    char dir[MAX_MOUNTPOINT_NAMELEN + 16]; /* mountpoint + core-dumps */
    int nhandle;
};

/*
 * use RUNS_IN_SDK_HOST to test it in sbox i386 target,
 * it forces network connection as "connected" and makes
 * fake upload progress without really sending anything.
 *
 * Check also FAKE_SERVER_RESPONSE in crash-reporter-upload.c,
 * it forces curl error and shows small fake server response
 */
//#define RUNS_IN_SDK_HOST
//#define FAKE_SERVER_RESPONSE
