/*
 * @file crash-reporter-cp-applet.c
 *
 * This file contains the implementation of
 * control panel applet for Crash Reporter.
 * 
 * This file is part of crash-reporter
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <osso-log.h>
#include <log-functions.h>
#include <libosso.h>

#include "crash-reporter-settings-dialog.h"
#include "crash-reporter-utils.h"

struct core_location_reg * core_location_registry = NULL;

/**
  Definition of execute interface for Crash Reporter applet,
  used by any calling application (primary user: Control Panel application).
 
  @param osso	osso context of the calling application.
  @param data  Pointer to gtk window of the calling application.
  @param user_activated   Flag indicating calling mode, either normal user
 			   activation or system activation.
 */
osso_return_t 
execute(osso_context_t *osso, gpointer data,
	        gboolean user_activated);

osso_return_t 
execute(osso_context_t *osso, gpointer data,
	        gboolean user_activated)
{
	g_type_init();	
	
	core_location_registry = create_core_location_registry();
	creporter_cp_dialog_create(data, osso);
	g_free(core_location_registry);
	core_location_registry = NULL;
	return OSSO_OK;
}
