/**
 * @file crash-reporter-daemon-monitor.h
 * 
 * This file contains the directory monitoring function prototypes.
 * In case Rich cores are generated the Crash Reporter UI is launched. 
 * 
 * This file is part of crash-reporter
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef CREPORTER_DAEMON_MONITOR_FILE_H
#define CREPORTER_DAEMON_MONITOR_FILE_H
#include <gconf/gconf-client.h>
#include <libosso.h>
#include <glib/gstdio.h>
#include <log-functions.h>
#include <osso-log.h>
#include <string.h>

osso_context_t *context;

/**
  This function sets the monitors for MMC1 and MMC2
  The monitor_event() will be called when any changes
  are done to the monitored directories

  @param idx index to cores location registry
  @return TRUE if success else FALSE
  */
gboolean set_directory_monitor(int idx);
/** 
  This function initializes inotify watch 
  and makes first check for the presence of core files in 
  'core-dumps' directories in both the MMCs. 

  @param void
*/
void init_inotify_and_check_for_cores(void); 
#endif
