/**
 * @file crash-reporter-settings-file.h
 *
 * This file contains the function prototypes for Crash Reporter  application's
 * config file functions.
 *
 * This file is part of crash-reporter
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef CREPORTER_CONFIG_FILE_H
#define CREPORTER_CONFIG_FILE_H

#include <glib.h>
#include <libosso.h>
#include <log-functions.h>
#include <osso-log.h>
#include <sys/stat.h>

/*
 * Settings file defines server settings and credentials
 * It is located in /usr/share/crash-reporter/ and not written by application;
 * Name is composed in code, thus defining only last part here
 */
#define CREPORTER_SYSTEM_SETTINGS_LOCATION "/usr/share/crash-reporter-settings"
#define SETTINGS_FILE		"/crash-reporter.conf"
#define SERVER_SECTION	"Server"
#define USER_NAME	"user_name"
#define PWD		"password"
#define SERVER_ADDR	"server_addr"
#define USE_SSL		"use_ssl"

/*
 * Privacy file defines what to enable in core dump
 * It is located in /etc, thus defining name fully here.
 * This is user-writable (written from control panel)
 * Note that rich-core-dumper examines this file by
 * sourcing it directly.
 * It is located either in /home/user/ or in /usr/share/crash-reporter/
 * Name is composed in code, thus defining only last part here
 */
#define PRIVACY_SETTINGS_LOCATION	"/home/user"
#define PRIVACY_SETTINGS_FILE		"/crash-reporter-privacy.conf"
#define SETTINGS_SECTION	"Settings"
#define PRIVACY_SECTION		"Privacy"
#define DUMPING_ENABLED		"coredumping"
#define SENDING_ENABLED		"sending"
#define AVOID_DUPS		"avoid-dups"
#define INCLUDE_CORE		"INCLUDE_CORE"
#define INCLUDE_SYSLOG		"INCLUDE_SYSLOG"
#define INCLUDE_PKGLIST		"INCLUDE_PKGLIST"

#define HTTP_OK		"HTTP/1.1 20"
#define HTTP_UNAUTH	"HTTP/1.1 401"

typedef struct _creporterSettings creporterSettings;
typedef struct _privacySettings privacySettings;

/**
   Settings about where to send crash reports
  */
struct _creporterSettings {
	gchar* user_name;
	gchar* passwd;
	gchar* server_addr;
	gboolean use_ssl;
};

/**
   Settings about enabled & privacy (user can change these)
  */
struct _privacySettings {
	gboolean dumping_enabled;
	gboolean sending_enabled;
	gboolean avoid_dups;
	gboolean include_core;
	gboolean include_syslog;
	gboolean include_pkglist;
};

/**
  Functions to read/write contents of settings file.

  @param none.

  @return pointer to settings structure.
 */
/*creporterSettings*  creporter_read_settings(void);*/
privacySettings* creporter_read_privacy_settings(void);
void creporter_write_settings(creporterSettings*);
void creporter_write_privacy_settings(privacySettings*);

creporterSettings * creporter_get_settings(void);


/**
  Functions to free settings struct.

  @param settings is a pointer to the configSettings struct.

  @return none.
 */
void creporter_free_privacy_settings(privacySettings * settings);

#endif
