/*
 * This file is part of control-plugin-upstart
 *
 * Copyright (C) 2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef UPSTART_CONFIG_HANDLER_H
#define UPSTART_CONFIG_HANDLER_H

#include <glib.h>

#define CONFIG_DIR "/home/user/.control-plugin-upstart"
#define CONFIG_FILE_NAME "upstart-plugin.conf"
#define CONFIG_FILE (CONFIG_DIR "/" CONFIG_FILE_NAME)
#define MASTER_FILE_NAME ".current-config-file-name.conf"
#define CURRENT_CFILE (CONFIG_DIR "/" MASTER_FILE_NAME)
#define EVENT_DIR "/etc/event.d"
#define NOP_DIR (CONFIG_DIR "/event.nop.d")
#define ON_ACTIVITY_WORD "ON"
#define OFF_ACTIVITY_WORD "OFF"
#define REBOOT_WAIT 100000 /* 100 ms wait before reboot */

/* Different data fields in our element_list */
#define FILE_NAME_STR "e_name"
#define PRINT_NAME_STR "p_name"
#define CHECK_BTN_STR "c_btn"
#define ACTIVITY_STR "a_str"
#define COMMENT_STR "comm_str"

extern GList* element_list;


/* Functions */
void config_init(gchar* config_file);
gint move_event_files(void);
void free_element_list(void);
void set_current_config_file(const gchar* file_name);
void save_current_config_file_name(void);
void update_config_file(void);

#endif /* UPSTART_CONFIG_HANDLER_H */
