/*
 * This file is part of control-plugin-upstart
 *
 * Copyright (C) 2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


/***************************************************************
 * This is the command line version of control_plugin_upstart
 * It will make changes to upstart event files based on config file
 * and if any changes were done, it will force reboot.
 * Command line systax is
 * control-plugin-upstart-cmdline [config_file_name]
 * If config_file_name paramter is not given then current config 
 * file is used.
 ***************************************************************/

#include <glib.h>
#include <glib-object.h>
#include <sys/reboot.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "upstart_config_handler.h"

int main(int argc, char **argv)
{

    gchar* config_file;
    gchar  config_file_with_path[NAME_MAX];
    gchar* basename;

    g_type_init();

    if (argc > 1) {
        config_file = argv[1];
        /* Config file argument can include full path or not.
         * If it doesn't then add default dir to path.
         */
        basename = g_path_get_basename(config_file);
        if (strlen(config_file) > strlen(basename)) {
        /* Line already contains directories, use as it is */
        g_strlcpy(config_file_with_path, config_file, 
                  sizeof(config_file_with_path));
        } else {
            /* It was just file name. Add default directory */
            snprintf(config_file_with_path, sizeof(config_file_with_path),
                     "%s/%s", CONFIG_DIR, config_file);
        }
        g_free(basename);
        config_file = config_file_with_path;
    } else {
        /* No config file as input.
         * Use NULL, it will be replaced with default one
         */
        config_file = NULL;
    }

    config_init(config_file);
    if (move_event_files()) {
        sync();
        g_debug("Time to reboot\n");
        g_usleep(REBOOT_WAIT);
        reboot(RB_AUTOBOOT);
    } else {
        /* No changes done, no need for reboot */
        g_debug("No need for reboot\n");
    }
    return 0;
}
