/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Authored By Matthew Allum  <mallum@openedhand.com>
 *
 * Copyright (C) 2006 OpenedHand
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _HAVE_CLUTTER_H
#define _HAVE_CLUTTER_H

#include "clutter-actor.h"
#include "clutter-alpha.h"
#include "clutter-backend.h"
#include "clutter-color.h"
#include "clutter-container.h"
#include "clutter-behaviour.h"
#include "clutter-behaviour-bspline.h"
#include "clutter-behaviour-depth.h"
#include "clutter-behaviour-ellipse.h"
#include "clutter-behaviour-opacity.h"
#include "clutter-behaviour-path.h"
#include "clutter-behaviour-rotate.h"
#include "clutter-behaviour-scale.h"
#include "clutter-child-meta.h"
#include "clutter-clone-texture.h"
#include "clutter-deprecated.h"
#include "clutter-effect.h"
#include "clutter-entry.h"
#include "clutter-event.h"
#include "clutter-feature.h"
#include "clutter-rectangle.h"
#include "clutter-group.h"
#include "clutter-keysyms.h" 
#include "clutter-label.h"
#include "clutter-list-model.h"
#include "clutter-main.h"
#include "clutter-media.h"
#include "clutter-model.h"
#include "clutter-stage.h"
#include "clutter-stage-manager.h"
#include "clutter-texture.h"
#include "clutter-frame-source.h"
#include "clutter-timeout-pool.h"
#include "clutter-timeline.h"
#include "clutter-score.h"
#include "clutter-script.h"
#include "clutter-scriptable.h"
#include "clutter-types.h"
#include "clutter-units.h"
#include "clutter-util.h"
#include "clutter-version.h"

#include "clutter-enum-types.h"

#endif
