/**
 * Clinkc-av control point test tool
 *
 * Content Directory Service tests
 *
 * Copyright (c) 2006 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef AV_CDSTEST_H
#define AV_CDSTEST_H

#include <cybergarage/upnp/ccontrolpoint.h>

#define NUM_CDS_TEST_CASES 5

#define TEST_CASE_CDS_GET_SEARCH_CAPS "CDS Get Search Caps Test"
#define TEST_CASE_CDS_GET_SORT_CAPS "CDS Get Sort Caps Test"
#define TEST_CASE_CDS_GET_SYSTEM_UPDATE_ID "CDS Get System Update ID Test"
#define TEST_CASE_CDS_BROWSE_DIRECT_CHILDREN "CDS Browse Direct Children Test"
#define TEST_CASE_CDS_SEARCH "CDS Search"

int cp_test_cds_print_statistics();

BOOL cp_test_cds(CgUpnpControlPoint* cp);

int cp_test_cds_get_search_caps(CgUpnpControlPoint* cp, char* udn);
int cp_test_cds_get_sort_caps(CgUpnpControlPoint* cp, char* udn);
int cp_test_cds_get_system_update_id(CgUpnpControlPoint* cp, char* udn);
int cp_test_cds_browse_direct_children(CgUpnpControlPoint* cp, char* udn);
int cp_test_cds_search(CgUpnpControlPoint* cp, char* udn);

#endif
