/*
 * UPnP Browser for Maemo
 *
 * playlist_dialog.c
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifdef MAEMO
#include <hildon-widgets/gtk-infoprint.h>
#include <hildon-widgets/hildon-defines.h>
#endif

#include <gtk/gtk.h>
#include <cybergarage/util/cstring.h>

#include "playlist_dialog.h"

PlaylistDialog* playlist_dialog_new()
{
	PlaylistDialog* dialog = g_new(PlaylistDialog, 1);

	/* Create the view */
	dialog->playlist_dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog->playlist_dialog), "Playlist");
	gtk_window_set_type_hint(GTK_WINDOW(dialog->playlist_dialog), 
				 GDK_WINDOW_TYPE_HINT_DIALOG);
	
	dialog->vbox = GTK_DIALOG(dialog->playlist_dialog)->vbox;
	gtk_widget_show(dialog->vbox);
	
	/* Create the playlist view */
	playlist_dialog_create_view_model(dialog);

	/* Action area */
	dialog->dialog_action_area =
			GTK_DIALOG(dialog->playlist_dialog)->action_area;
	gtk_widget_show(dialog->dialog_action_area);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog->dialog_action_area),
				  GTK_BUTTONBOX_END);

	/* Remove button */
	dialog->remove_button = gtk_button_new_with_label("Remove");
	gtk_widget_show(dialog->remove_button);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog->playlist_dialog), 
				     dialog->remove_button, 
				     GTK_RESPONSE_NONE);

	/* Clear button */
	dialog->clear_button = gtk_button_new_with_label("Clear");
	gtk_widget_show(dialog->clear_button);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog->playlist_dialog), 
				     dialog->clear_button, 
				     GTK_RESPONSE_NONE);

	/* Close button */
	dialog->close_button = gtk_button_new_with_label("Close");
	gtk_widget_show(dialog->close_button);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog->playlist_dialog),
				     dialog->close_button,
				     GTK_RESPONSE_OK);
				     
	return dialog;
}

void playlist_dialog_create_view_model(PlaylistDialog* dialog)
{
	GtkCellRenderer *renderer = NULL;
	GtkTreeViewColumn *column = NULL;
	GtkTreeIter iter;
	
	/* Create renderer model */
	dialog->playlist_model = gtk_list_store_new(PLAYLISTMODEL_COLUMNS,
				/* track name */    G_TYPE_STRING,
				/* track uri */	    G_TYPE_STRING,
				/* server udn */    G_TYPE_STRING,
				/* renderer udn */  G_TYPE_STRING);
	
	dialog->playlist_view = gtk_tree_view_new_with_model(GTK_TREE_MODEL(dialog->playlist_model));
	gtk_widget_show(dialog->playlist_view);
	
	/* Create a scrolled window */
	dialog->scrolled_window = gtk_scrolled_window_new(
		gtk_tree_view_get_hadjustment(GTK_TREE_VIEW(dialog->playlist_view)),
		gtk_tree_view_get_vadjustment(GTK_TREE_VIEW(dialog->playlist_view)));
	gtk_widget_show(dialog->scrolled_window);

	/* Set the scrollbar showing policy */
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(dialog->scrolled_window),
				       GTK_POLICY_NEVER,
				       GTK_POLICY_AUTOMATIC);

	/* Add the playlist view to the scrolled window */
	gtk_container_add(GTK_CONTAINER(dialog->scrolled_window),
			  dialog->playlist_view);

	/* Add the scrolled window to the dialog */
	gtk_container_add(GTK_CONTAINER(dialog->vbox),
			  dialog->scrolled_window);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Media", renderer,
						"text", 
						PLAYLISTMODEL_COLUMN_NAME,
						NULL);

	gtk_tree_view_append_column(GTK_TREE_VIEW(dialog->playlist_view), column);
	
	gtk_list_store_append(dialog->playlist_model, &iter);
	gtk_list_store_set(dialog->playlist_model, &iter, 
			PLAYLISTMODEL_COLUMN_NAME,
				"Foobar",
			-1);
}

void playlist_dialog_delete(PlaylistDialog* dialog)
{
	g_return_if_fail(dialog != NULL);
	
	gtk_object_destroy(GTK_OBJECT(dialog->playlist_dialog));
	
	g_free(dialog);
}

void playlist_dialog_run()
{
	PlaylistDialog* dialog = playlist_dialog_new();

	while (gtk_dialog_run(GTK_DIALOG(dialog->playlist_dialog)) == GTK_RESPONSE_NONE);

	playlist_dialog_delete(dialog);
}
