#include <check.h>
#include "testing.h"
#include <glib-object.h>

#include "gwebhistorylist.h"
#include "stub_gwebhistorylist.h"

static GWebHistoryList* self;
static gboolean destroyed_flag;


static void destroy_notify(gpointer user_data, GObject* where_object_was)
{
	destroyed_flag = TRUE;
}

void setup_gwebhistorylist(void)
{
	g_type_init();
	self = G_WEB_HISTORY_LIST(stub_g_web_history_list_new());
	fail_if(self == NULL, "failed to create object");
	destroyed_flag = FALSE;
}

void teardown_gwebhistorylist(void)
{
	g_object_weak_ref(G_OBJECT(self), destroy_notify, NULL);

	g_object_unref(G_OBJECT(self));
	//run_main_loop(DEFAULT_MAIN_LOOP_RUN_TIME);

	//fail_unless(destroyed_flag, "failed to destroy object");

	self = NULL;
	destroyed_flag = FALSE;
}

START_TEST(test_g_web_history_list_destroy)
{
	g_web_history_list_destroy(self);
}
END_TEST

START_TEST(test_g_web_history_list_delete_item)
{
	gint pos;

	pos = 0;

	g_web_history_list_delete_item(self, pos);
}
END_TEST

START_TEST(test_g_web_history_list_get_items)
{
	GObject* ret;

	ret = g_web_history_list_get_items(self);
}
END_TEST

START_TEST(test_g_web_history_list_get_items_count)
{
	gint ret;

	ret = g_web_history_list_get_items_count(self);
}
END_TEST

START_TEST(test_g_web_history_list_get_item_title)
{
	gchar* ret;
	gint pos;

	pos = 0;

	ret = g_web_history_list_get_item_title(self, pos);
}
END_TEST

START_TEST(test_g_web_history_list_get_item_url)
{
	gchar* ret;
	gint pos;

	pos = 0;

	ret = g_web_history_list_get_item_url(self, pos);
}
END_TEST

START_TEST(test_g_web_history_list_get_item_time)
{
	GTime ret;
	gint pos;

	pos = 0;

	ret = g_web_history_list_get_item_time(self, pos);
}
END_TEST

START_TEST(test_g_web_shistory_list_get_item_thumbnail)
{
	gchar* ret;
	gint pos;

	pos = 0;

	ret = g_web_shistory_list_get_item_thumbnail(self, pos);
}
END_TEST


Suite* create_gwebhistorylist_suite(void)
{
	Suite* s = suite_create("gwebhistorylist");

	TCase* tc = tcase_create("tests");
	tcase_add_checked_fixture(tc, setup_gwebhistorylist, teardown_gwebhistorylist);
	tcase_add_test(tc, test_g_web_history_list_destroy);
	tcase_add_test(tc, test_g_web_history_list_delete_item);
	tcase_add_test(tc, test_g_web_history_list_get_items);
	tcase_add_test(tc, test_g_web_history_list_get_items_count);
	tcase_add_test(tc, test_g_web_history_list_get_item_title);
	tcase_add_test(tc, test_g_web_history_list_get_item_url);
	tcase_add_test(tc, test_g_web_history_list_get_item_time);
	tcase_add_test(tc, test_g_web_shistory_list_get_item_thumbnail);
	suite_add_tcase(s, tc);

	return s;
}
