#include <check.h>
#include "testing.h"
#include <glib-object.h>

#include "gwebtransferitemlist.h"
#include "stub_gwebtransferitemlist.h"

static GWebTransferItemList* self;
static gboolean destroyed_flag;


static void destroy_notify(gpointer user_data, GObject* where_object_was)
{
	destroyed_flag = TRUE;
}

void setup_gwebtransferitemlist(void)
{
	g_type_init();
	self = G_WEB_TRANSFER_ITEM_LIST(stub_g_web_transfer_item_list_new());
	fail_if(self == NULL, "failed to create object");
	destroyed_flag = FALSE;
}

void teardown_gwebtransferitemlist(void)
{
	g_object_weak_ref(G_OBJECT(self), destroy_notify, NULL);

	g_object_unref(G_OBJECT(self));
	//run_main_loop(DEFAULT_MAIN_LOOP_RUN_TIME);

	//fail_unless(destroyed_flag, "failed to destroy object");

	self = NULL;
	destroyed_flag = FALSE;
}

START_TEST(test_g_web_transfer_item_list_destroy)
{
	g_web_transfer_item_list_destroy(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_list_get_items)
{
	GObject** ret;

	ret = g_web_transfer_item_list_get_items(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_list_get_items_count)
{
	gint ret;

	ret = g_web_transfer_item_list_get_items_count(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_list_get_item)
{
	GWebTransferItem* ret;
	int pos = 0;

	ret = g_web_transfer_item_list_get_item(self, pos);
}
END_TEST

Suite* create_gwebtransferitemlist_suite(void)
{
	Suite* s = suite_create("gwebtransferitemlist");

	TCase* tc = tcase_create("tests");
	tcase_add_checked_fixture(tc, setup_gwebtransferitemlist, teardown_gwebtransferitemlist);
	tcase_add_test(tc, test_g_web_transfer_item_list_destroy);
	tcase_add_test(tc, test_g_web_transfer_item_list_get_items);
	tcase_add_test(tc, test_g_web_transfer_item_list_get_items_count);
	tcase_add_test(tc, test_g_web_transfer_item_list_get_item);
	suite_add_tcase(s, tc);

	return s;
}
