#include <check.h>
#include "testing.h"
#include <glib-object.h>

#include "gweb.h"
#include "stub_gweb.h"

static GWeb* self;
static gboolean destroyed_flag;


static void destroy_notify(gpointer user_data, GObject* where_object_was)
{
	destroyed_flag = TRUE;
}

void setup_gweb(void)
{
	g_type_init();
	self = G_WEB(stub_g_web_new());
	fail_if(self == NULL, "failed to create object");
	destroyed_flag = FALSE;
}

void teardown_gweb(void)
{
	g_object_weak_ref(G_OBJECT(self), destroy_notify, NULL);

	g_object_unref(G_OBJECT(self));
	//run_main_loop(DEFAULT_MAIN_LOOP_RUN_TIME);

	//fail_unless(destroyed_flag, "failed to destroy object");

	self = NULL;
	destroyed_flag = FALSE;
}

START_TEST(test_g_web_destroy)
{
	g_web_destroy(self);
}
END_TEST

START_TEST(test_g_web_new_web_engine_window)
{
	GWebEngine* ret;

	ret = g_web_new_web_engine_window(self);
}
END_TEST

START_TEST(test_g_web_new_web_engine_window_with_context)
{
	GWebEngine* ret;
	gpointer context = NULL;
	gboolean leave_tracks, without_history;

	leave_tracks = FALSE;
	without_history = FALSE;

	ret = g_web_new_web_engine_window_with_context(self, context, leave_tracks, without_history);
}
END_TEST

START_TEST(test_g_web_new_web_transfer_item)
{
	GWebTransferItem* ret;
	const gchar* url = NULL;
	const gchar* filename = NULL;

	ret = g_web_new_web_transfer_item(self, url, filename);
}
END_TEST

START_TEST(test_g_web_initialize_web_transfer_item)
{
	GWebTransferItem* ret;
	GObject* item = NULL;

	ret = g_web_initialize_web_transfer_item(self, item);
}
END_TEST

START_TEST(test_g_web_get_web_transfer_item_list)
{
	GWebTransferItemList* ret;

	ret = g_web_get_web_transfer_item_list(self);
}
END_TEST

START_TEST(test_g_web_set_home_page)
{
	GWebStatus ret;
	const gchar* url = NULL;

	ret = g_web_set_home_page(self, url);
}
END_TEST

START_TEST(test_g_web_get_home_page)
{
	gchar* ret;

	ret = g_web_get_home_page(self);
}
END_TEST

START_TEST(test_g_web_set_language)
{
	GWebStatus ret;
	const gchar* lang = NULL;

	ret = g_web_set_language(self, lang);
}
END_TEST

START_TEST(test_g_web_get_language)
{
	gchar* ret;

	ret = g_web_get_language(self);
}
END_TEST

START_TEST(test_g_web_reset_cache_history_length)
{
	g_web_reset_cache_history_length(self);
}
END_TEST

START_TEST(test_g_web_get_maximum_cache_size)
{
	gint ret;

	ret = g_web_get_maximum_cache_size(self);
}
END_TEST

START_TEST(test_g_web_set_default_home_page)
{
	GWebStatus ret;
	const gchar* url = NULL;

	ret = g_web_set_default_home_page(self, url);
}
END_TEST

START_TEST(test_g_web_get_default_home_page)
{
	gchar* ret;

	ret = g_web_get_default_home_page(self);
}
END_TEST

START_TEST(test_g_web_home_page_set)
{
	gboolean ret;

	ret = g_web_home_page_set(self);
}
END_TEST

START_TEST(test_g_web_set_frame_borders_enabled)
{
	gboolean enabled = FALSE;

	g_web_set_frame_borders_enabled(self, enabled);
}
END_TEST

START_TEST(test_g_web_get_frame_borders_enabled)
{
	gboolean ret;

	ret = g_web_get_frame_borders_enabled(self);
}
END_TEST

START_TEST(test_g_web_set_location_completion_suffixes)
{
	GWebStatus ret;
	const gchar* suffixes = NULL;

	ret = g_web_set_location_completion_suffixes(self, suffixes);
}
END_TEST

START_TEST(test_g_web_get_location_completion_suffixes)
{
	gchar* ret;

	ret = g_web_get_location_completion_suffixes(self);
}
END_TEST

START_TEST(test_g_web_set_plugins_enabled)
{
	GWebStatus ret;
	gboolean enabled = FALSE;

	ret = g_web_set_plugins_enabled(self, enabled);
}
END_TEST

START_TEST(test_g_web_set_ssl2_support)
{
	GWebStatus ret;
	gboolean enabled = FALSE;

	ret = g_web_set_ssl2_support(self, enabled);
}
END_TEST

START_TEST(test_g_web_get_ssl2_support)
{
	gboolean ret;

	ret = g_web_get_ssl2_support(self);
}
END_TEST

START_TEST(test_g_web_get_plugins_enabled)
{
	gboolean ret;

	ret = g_web_get_plugins_enabled(self);
}
END_TEST

START_TEST(test_g_web_set_js_enabled)
{
	GWebStatus ret;
	gboolean enabled = FALSE;

	ret = g_web_set_js_enabled(self, enabled);
}
END_TEST

START_TEST(test_g_web_get_js_enabled)
{
	gboolean ret;

	ret = g_web_get_js_enabled(self);
}
END_TEST

START_TEST(test_g_web_set_memory_cache)
{
	GMemoryCache acceptance = G_MEMORY_CACHE_AUTOMATIC;

	g_web_set_memory_cache(self, acceptance);
}
END_TEST

START_TEST(test_g_web_get_memory_cache)
{
	GMemoryCache ret;

	ret = g_web_get_memory_cache(self);
}
END_TEST

START_TEST(test_g_web_set_cache_size)
{
	GWebStatus ret;
	gint size = 0;

	ret = g_web_set_cache_size(self, size);
}
END_TEST

START_TEST(test_g_web_get_cache_size)
{
	gint ret;

	ret = g_web_get_cache_size(self);
}
END_TEST

START_TEST(test_g_web_set_browse_offline)
{
	GWebStatus ret;
	gboolean enabled = FALSE;

	ret = g_web_set_browse_offline(self, enabled);
}
END_TEST

START_TEST(test_g_web_get_browse_offline)
{
	gboolean ret;

	ret = g_web_get_browse_offline(self);
}
END_TEST

START_TEST(test_g_web_set_automatic_redirection_enabled)
{
	GWebStatus ret;
	gboolean enabled = FALSE;

	ret = g_web_set_automatic_redirection_enabled(self, enabled);
}
END_TEST

START_TEST(test_g_web_get_automatic_redirection_enabled)
{
	gboolean ret;

	ret = g_web_get_automatic_redirection_enabled(self);
}
END_TEST

START_TEST(test_g_web_set_load_images)
{
	GWebStatus ret;
	GWebEngineImagePolicy level = G_WEBENGINE_POLICY_NO_IMAGES;

	ret = g_web_set_load_images(self, level);
}
END_TEST

START_TEST(test_g_web_get_load_images)
{
	GWebEngineImagePolicy ret;

	ret = g_web_get_load_images(self);
}
END_TEST

START_TEST(test_g_web_disconnect)
{
	g_web_disconnect(self);
}
END_TEST

START_TEST(test_g_web_clear_cache)
{
	GWebStatus ret;

	ret = g_web_clear_cache(self);
}
END_TEST

START_TEST(test_g_web_get_plugins_list)
{
	GWebPluginList* ret;

	ret = g_web_get_plugins_list(self);
}
END_TEST

START_TEST(test_g_web_get_history_list)
{
	GWebHistoryList* ret;

	ret = g_web_get_history_list(self);
}
END_TEST

START_TEST(test_g_web_set_new_window_loads)
{
	GWebStatus ret;
	gboolean enabled = FALSE;

	ret = g_web_set_new_window_loads(self, enabled);
}
END_TEST

START_TEST(test_g_web_get_new_window_loads)
{
	gboolean ret;

	ret = g_web_get_new_window_loads(self);
}
END_TEST

START_TEST(test_g_web_set_cookie_acceptance)
{
	GCookieAcceptance acceptance = G_ACCEPT_COOKIE_ALWAYS;

	g_web_set_cookie_acceptance(self, acceptance);
}
END_TEST

START_TEST(test_g_web_get_cookie_acceptance)
{
	GCookieAcceptance ret;

	ret = g_web_get_cookie_acceptance(self);
}
END_TEST

START_TEST(test_g_web_set_popup_acceptance)
{
	GPopupAcceptance acceptance = G_ACCEPT_POPUP_ALWAYS;

	g_web_set_popup_acceptance(self, acceptance);
}
END_TEST

START_TEST(test_g_web_get_popup_acceptance)
{
	GPopupAcceptance ret;

	ret = g_web_get_popup_acceptance(self);
}
END_TEST

START_TEST(test_g_web_suspend)
{
	GWebStatus ret;

	ret = g_web_suspend(self);
}
END_TEST

START_TEST(test_g_web_suspended)
{
	gboolean ret;

	ret = g_web_suspended(self);
}
END_TEST

START_TEST(test_g_web_resume)
{
	g_web_resume(self);
}
END_TEST

START_TEST(test_g_web_set_ua_string)
{
	gchar* string = NULL;

	g_web_set_ua_string(self, string);
}
END_TEST

START_TEST(test_g_web_set_user_agent_id)
{
	GWebStatus ret;
	gint id = 0;

	ret = g_web_set_user_agent_id(self, id);
}
END_TEST

START_TEST(test_g_web_get_user_agent_id)
{
	gint ret;

	ret = g_web_get_user_agent_id(self);
}
END_TEST

START_TEST(test_g_web_enable_url_loading)
{
	gboolean enabled = FALSE;

	g_web_enable_url_loading(self, enabled);
}
END_TEST

START_TEST(test_g_web_free_memory)
{
	gboolean progressive = FALSE;

	g_web_free_memory(self, progressive);
}
END_TEST

START_TEST(test_g_web_store_transfers)
{
	GWebStatus ret;

	ret = g_web_store_transfers(self);
}
END_TEST

START_TEST(test_g_web_restore_transfers)
{
	GWebStatus ret;

	ret = g_web_restore_transfers(self);
}
END_TEST

START_TEST(test_g_web_delete_all_cookies)
{
	GWebStatus ret;

	ret = g_web_delete_all_cookies(self);
}
END_TEST

START_TEST(test_g_web_confirm_cookie)
{
	GWebStatus ret;
	gpointer context = NULL;
	gboolean accept = FALSE;
	GWebCookieAction action = G_WEB_COOKIE_NO_ACTION;

	ret = g_web_confirm_cookie(self, context, accept, action);
}
END_TEST

START_TEST(test_g_web_get_global)
{
	GObject* ret;

	ret = g_web_get_global(self);
}
END_TEST

START_TEST(test_g_web_get_certificate_enum_message)
{
	GWebCertificateMessage ret;
	GObject* context = NULL;

	ret = g_web_get_certificate_enum_message(self, context);
}
END_TEST

START_TEST(test_g_web_perform_crtificate_context_action)
{
	GWebCertificateReaction ret;
	GObject* context = NULL;
	GWebCertificateAction action = G_WEB_CERT_ACTION_OK;
	GObject* cert = NULL;

	ret = g_web_perform_crtificate_context_action(self, context, action, cert);
}
END_TEST

START_TEST(test_g_web_get_certificate_context_iter)
{
	GWebStatus ret;
	GObject* context = NULL;
	GObject* iterator;

	ret = g_web_get_certificate_context_iter(self, context, &iterator);
}
END_TEST

START_TEST(test_g_web_get_certificate_iter)
{
	GObject* ret;
	GObject* iterator;

	ret = g_web_get_certificate_iter(self, &iterator);
}
END_TEST

START_TEST(test_g_web_certificate_iter_free)
{
	GObject* iterator = NULL;

	g_web_certificate_iter_free(self, iterator);
}
END_TEST

START_TEST(test_g_web_certificate_free)
{
	GObject* cert = NULL;

	g_web_certificate_free(self, cert);
}
END_TEST

START_TEST(test_g_web_notify_plugins)
{
	gint event = 0;

	g_web_notify_plugins(self, event);
}
END_TEST

START_TEST(test_g_web_username_matchinfo_get_matches)
{
	gint ret;
	GObject* info = NULL;

	ret = g_web_username_matchinfo_get_matches(self, info);
}
END_TEST

START_TEST(test_g_web_username_matchinfo_delete)
{
	GObject* info = NULL;
	gint index = 0;

	g_web_username_matchinfo_delete(self, info, index);
}
END_TEST

START_TEST(test_g_web_username_matchinfo_get_username)
{
	GWebStatus ret;
	GObject* info = NULL;
	gint index = 0;
	gchar* username;

	ret = g_web_username_matchinfo_get_username(self, info, index, &username);
}
END_TEST

START_TEST(test_g_web_get_password_manager)
{
	GWebPasswordManager* ret;
	const gchar* server = NULL;
	gint index = 0;

	ret = g_web_get_password_manager(self, server, index);
}
END_TEST

START_TEST(test_g_web_store_personal_data)
{
	GWebStatus ret;
	const gchar* server = NULL;
	const gchar* username = NULL;
	const gchar* password = NULL;

	ret = g_web_store_personal_data(self, server, username, password);
}
END_TEST

START_TEST(test_g_web_delete_personal_data)
{
	GWebStatus ret;
	const gchar* server = NULL;
	const gchar* username = NULL;

	ret = g_web_delete_personal_data(self, server, username);
}
END_TEST

START_TEST(test_g_web_clear_passwords)
{
	GWebStatus ret;

	ret = g_web_clear_passwords(self);
}
END_TEST

START_TEST(test_g_web_clear_authenticated_sessions)
{
	GWebStatus ret;

	ret = g_web_clear_authenticated_sessions(self);
}
END_TEST

START_TEST(test_g_web_clear_personal_data)
{
	g_web_clear_personal_data(self);
}
END_TEST

START_TEST(test_g_web_clear_all_history)
{
	GWebStatus ret;

	ret = g_web_clear_all_history(self);
}
END_TEST

START_TEST(test_g_web_set_remember_password)
{
	GWebStatus ret;
	gboolean enabled = FALSE;

	ret = g_web_set_remember_password(self, enabled);
}
END_TEST

START_TEST(test_g_web_get_remember_password)
{
	gboolean ret;

	ret = g_web_get_remember_password(self);
}
END_TEST

START_TEST(test_g_web_set_remember_password_for_forms)
{
	GWebStatus ret;
	gboolean enabled = FALSE;

	ret = g_web_set_remember_password_for_forms(self, enabled);
}
END_TEST

START_TEST(test_g_web_get_remember_password_for_forms)
{
	gboolean ret;

	ret = g_web_get_remember_password_for_forms(self);
}
END_TEST

START_TEST(test_g_web_set_plugin_enabled)
{
	GWebStatus ret;
	gchar* name = NULL;
	gboolean enabled = FALSE;

	ret = g_web_set_plugin_enabled(self, name, enabled);
}
END_TEST

START_TEST(test_g_web_set_oom_cb)
{
	GWebStatus ret;
	GFunc func = NULL;

	ret = g_web_set_oom_cb(self, func);
}
END_TEST

START_TEST(test_g_web_get_plugin_enabled)
{
	gboolean ret;
	gchar* name = NULL;

	ret = g_web_get_plugin_enabled(self, name);
}
END_TEST

START_TEST(test_g_web_set_plugin_ignore_filepath)
{
	GWebStatus ret;

	ret = g_web_set_plugin_ignore_filepath(self);
}
END_TEST

START_TEST(test_g_web_notify_service)
{
	const gchar* name = NULL;
	gpointer* context = NULL;
	const gchar* topic = NULL;
	gchar* data = NULL;

	g_web_notify_service(self, name, context, topic, data);
}
END_TEST

Suite* create_gweb_suite(void)
{
	Suite* s = suite_create("gweb");

	TCase* tc = tcase_create("tests");
	tcase_add_checked_fixture(tc, setup_gweb, teardown_gweb);
	tcase_add_test(tc, test_g_web_destroy);
	tcase_add_test(tc, test_g_web_new_web_engine_window);
	tcase_add_test(tc, test_g_web_new_web_engine_window_with_context);
	tcase_add_test(tc, test_g_web_new_web_transfer_item);
	tcase_add_test(tc, test_g_web_initialize_web_transfer_item);
	tcase_add_test(tc, test_g_web_get_web_transfer_item_list);
	tcase_add_test(tc, test_g_web_set_home_page);
	tcase_add_test(tc, test_g_web_get_home_page);
	tcase_add_test(tc, test_g_web_set_language);
	tcase_add_test(tc, test_g_web_get_language);
	tcase_add_test(tc, test_g_web_reset_cache_history_length);
	tcase_add_test(tc, test_g_web_get_maximum_cache_size);
	tcase_add_test(tc, test_g_web_set_default_home_page);
	tcase_add_test(tc, test_g_web_get_default_home_page);
	tcase_add_test(tc, test_g_web_home_page_set);
	tcase_add_test(tc, test_g_web_set_frame_borders_enabled);
	tcase_add_test(tc, test_g_web_get_frame_borders_enabled);
	tcase_add_test(tc, test_g_web_set_location_completion_suffixes);
	tcase_add_test(tc, test_g_web_get_location_completion_suffixes);
	tcase_add_test(tc, test_g_web_set_plugins_enabled);
	tcase_add_test(tc, test_g_web_set_ssl2_support);
	tcase_add_test(tc, test_g_web_get_ssl2_support);
	tcase_add_test(tc, test_g_web_get_plugins_enabled);
	tcase_add_test(tc, test_g_web_set_js_enabled);
	tcase_add_test(tc, test_g_web_get_js_enabled);
	tcase_add_test(tc, test_g_web_set_memory_cache);
	tcase_add_test(tc, test_g_web_get_memory_cache);
	tcase_add_test(tc, test_g_web_set_cache_size);
	tcase_add_test(tc, test_g_web_get_cache_size);
	tcase_add_test(tc, test_g_web_set_browse_offline);
	tcase_add_test(tc, test_g_web_get_browse_offline);
	tcase_add_test(tc, test_g_web_set_automatic_redirection_enabled);
	tcase_add_test(tc, test_g_web_get_automatic_redirection_enabled);
	tcase_add_test(tc, test_g_web_set_load_images);
	tcase_add_test(tc, test_g_web_get_load_images);
	tcase_add_test(tc, test_g_web_disconnect);
	tcase_add_test(tc, test_g_web_clear_cache);
	tcase_add_test(tc, test_g_web_get_plugins_list);
	tcase_add_test(tc, test_g_web_get_history_list);
	tcase_add_test(tc, test_g_web_set_new_window_loads);
	tcase_add_test(tc, test_g_web_get_new_window_loads);
	tcase_add_test(tc, test_g_web_set_cookie_acceptance);
	tcase_add_test(tc, test_g_web_get_cookie_acceptance);
	tcase_add_test(tc, test_g_web_set_popup_acceptance);
	tcase_add_test(tc, test_g_web_get_popup_acceptance);
	tcase_add_test(tc, test_g_web_suspend);
	tcase_add_test(tc, test_g_web_suspended);
	tcase_add_test(tc, test_g_web_resume);
	tcase_add_test(tc, test_g_web_set_ua_string);
	tcase_add_test(tc, test_g_web_set_user_agent_id);
	tcase_add_test(tc, test_g_web_get_user_agent_id);
	tcase_add_test(tc, test_g_web_enable_url_loading);
	tcase_add_test(tc, test_g_web_free_memory);
	tcase_add_test(tc, test_g_web_store_transfers);
	tcase_add_test(tc, test_g_web_restore_transfers);
	tcase_add_test(tc, test_g_web_delete_all_cookies);
	tcase_add_test(tc, test_g_web_confirm_cookie);
	tcase_add_test(tc, test_g_web_get_global);
	tcase_add_test(tc, test_g_web_get_certificate_enum_message);
	tcase_add_test(tc, test_g_web_perform_crtificate_context_action);
	tcase_add_test(tc, test_g_web_get_certificate_context_iter);
	tcase_add_test(tc, test_g_web_get_certificate_iter);
	tcase_add_test(tc, test_g_web_certificate_iter_free);
	tcase_add_test(tc, test_g_web_certificate_free);
	tcase_add_test(tc, test_g_web_notify_plugins);
	tcase_add_test(tc, test_g_web_username_matchinfo_get_matches);
	tcase_add_test(tc, test_g_web_username_matchinfo_delete);
	tcase_add_test(tc, test_g_web_username_matchinfo_get_username);
	tcase_add_test(tc, test_g_web_get_password_manager);
	tcase_add_test(tc, test_g_web_store_personal_data);
	tcase_add_test(tc, test_g_web_delete_personal_data);
	tcase_add_test(tc, test_g_web_clear_passwords);
	tcase_add_test(tc, test_g_web_clear_authenticated_sessions);
	tcase_add_test(tc, test_g_web_clear_personal_data);
	tcase_add_test(tc, test_g_web_clear_all_history);
	tcase_add_test(tc, test_g_web_set_remember_password);
	tcase_add_test(tc, test_g_web_get_remember_password);
	tcase_add_test(tc, test_g_web_set_remember_password_for_forms);
	tcase_add_test(tc, test_g_web_get_remember_password_for_forms);
	tcase_add_test(tc, test_g_web_set_plugin_enabled);
	tcase_add_test(tc, test_g_web_set_oom_cb);
	tcase_add_test(tc, test_g_web_get_plugin_enabled);
	tcase_add_test(tc, test_g_web_set_plugin_ignore_filepath);
	tcase_add_test(tc, test_g_web_notify_service);
	suite_add_tcase(s, tc);

	return s;
}
