#include <glib.h>
#include <stdlib.h>

#include "stub_gweb.h"
#include "gwebcommon.h"

static void stub_g_web_interface_init(GWebIface* interface);
static void stub_g_web_class_init(StubGWebClass* klass);
static void stub_g_web_init(StubGWeb* self);
static void stub_g_web_finalize(GObject* object);
static void stub_g_web_destroy(GWeb* self);

static GWebEngine* stub_g_web_new_web_engine_window(GWeb* self);
static GWebEngine* stub_g_web_new_web_engine_window_with_context(
		GWeb* self,
		gpointer context,
		gboolean leave_tracks,
		gboolean without_history);
static gboolean stub_g_web_web_set_pref(GWeb* self, const gchar* name, GValue* value);
static gboolean stub_g_web_web_get_pref(GWeb* self, const gchar* name, GValue* value);
static GWebTransferItem* stub_g_web_new_web_transfer_item(
		GWeb* self,
		const gchar* url,
		const gchar* filename);
static GWebTransferItem* stub_g_web_initialize_web_transfer_item(
		GWeb* self,
		GObject* web_transfer_item);
static GWebTransferItemList* stub_g_web_get_web_transfer_item_list(GWeb* self);
static GWebStatus stub_g_web_set_home_page(GWeb* self, const gchar* home_page);
static gchar* stub_g_web_get_home_page(GWeb* self);
static GWebStatus stub_g_web_set_language(GWeb* self, const gchar* language);
static void stub_g_web_reset_cache_history_length(GWeb* self);
static gchar* stub_g_web_get_language(GWeb* self);
static gint stub_g_web_get_maximum_cache_size(GWeb* self);
static GWebStatus stub_g_web_set_default_home_page(GWeb* self, const gchar* default_page);
static gchar* stub_g_web_get_default_home_page(GWeb* self);
static gboolean stub_g_web_home_page_set(GWeb* self);
static void stub_g_web_set_frame_borders_enabled(GWeb* self, gboolean enabled);
static gboolean stub_g_web_get_frame_borders_enabled(GWeb* self);
static GWebStatus stub_g_web_set_location_completion_suffixes(GWeb* self, const gchar* suffixes);
static gchar* stub_g_web_get_location_completion_suffixes(GWeb* self);
static GWebStatus stub_g_web_set_plugins_enabled(GWeb* self, gboolean enabled);
static GWebStatus stub_g_web_set_oom_cb(GWeb* self, GFunc func);
static GWebStatus stub_g_web_set_ssl2_support(GWeb* self, gboolean enabled);
static gboolean stub_g_web_get_ssl2_support(GWeb* self);
static gboolean stub_g_web_get_plugins_enabled(GWeb* self);
static GWebStatus stub_g_web_set_js_enabled(GWeb* self, gboolean enabled);
static gboolean stub_g_web_get_js_enabled(GWeb* self);
static void stub_g_web_set_memory_cache(GWeb* self, GMemoryCache acceptance);
static GMemoryCache stub_g_web_get_memory_cache(GWeb* self);
static GWebStatus stub_g_web_set_cache_size(GWeb* self, gint size);
static gint stub_g_web_get_cache_size(GWeb* self);
static GWebStatus stub_g_web_set_browse_offline(GWeb* self, gboolean offline);
static gboolean stub_g_web_get_browse_offline(GWeb* self);
static GWebStatus stub_g_web_set_automatic_redirection_enabled(GWeb* self, gboolean enabled);
static gboolean stub_g_web_get_automatic_redirection_enabled(GWeb* self);
static GWebStatus stub_g_web_set_load_images(GWeb* self, GWebEngineImagePolicy level);
static GWebEngineImagePolicy stub_g_web_get_load_images(GWeb* self);
static void stub_g_web_disconnect(GWeb* self);
static GWebStatus stub_g_web_clear_cache(GWeb* self);
static GWebPluginList* stub_g_web_get_plugins_list(GWeb* self);
static GWebHistoryList* stub_g_web_get_history_list(GWeb* self);
static GWebStatus stub_g_web_set_new_window_loads(GWeb* self, gboolean loads);
static gboolean stub_g_web_get_new_window_loads(GWeb* self);
static void stub_g_web_set_cookie_acceptance(GWeb* self, GCookieAcceptance acceptance);
static GCookieAcceptance stub_g_web_get_cookie_acceptance(GWeb* self);
static void stub_g_web_set_popup_acceptance(GWeb* self, GPopupAcceptance acceptance);
static GPopupAcceptance stub_g_web_get_popup_acceptance(GWeb* self);
static GWebStatus stub_g_web_suspend(GWeb* self);
static gboolean stub_g_web_suspended(GWeb* self);
static void stub_g_web_resume(GWeb* self);
static void stub_g_web_set_ua_string(GWeb* self, gchar* ua_string);
static GWebStatus stub_g_web_set_user_agent_id(GWeb* self, gint ua_id);
static gint stub_g_web_get_user_agent_id(GWeb* self);
static void stub_g_web_enable_url_loading(GWeb* self, gboolean enable);
static void stub_g_web_free_memory(GWeb* self, gboolean progressive);
static GWebStatus stub_g_web_store_transfers(GWeb* self);
static GWebStatus stub_g_web_restore_transfers(GWeb* self);
static GWebStatus stub_g_web_delete_all_cookies(GWeb* self);
static GWebStatus stub_g_web_confirm_cookie(
		GWeb* self,
		gpointer context,
		gboolean accept,
		GWebCookieAction action);
static GObject* stub_g_web_get_global(GWeb* self);
static GWebCertificateMessage stub_g_web_get_certificate_enum_message(GWeb* self, GObject* context);
static gint stub_g_web_username_matchinfo_get_matches(GWeb* self, GObject* info);
static void stub_g_web_username_matchinfo_delete(GWeb* self, GObject* info, gint index);
static GWebStatus stub_g_web_username_matchinfo_get_username(
		GWeb* self,
		GObject* info,
		gint index,
		gchar** username);
static GWebPasswordManager* stub_g_web_get_password_manager(
		GWeb* self,
		const gchar* server,
		gint index);
static GWebStatus stub_g_web_store_personal_data(
		GWeb* self,
		const gchar* server,
		const gchar* username,
		const gchar* password);
static GWebStatus stub_g_web_delete_personal_data(
		GWeb* self,
		const gchar* server,
		const gchar* username);
static GWebCertificateReaction stub_g_web_perform_crtificate_context_action(
		GWeb* self,
		GObject* context,
		GWebCertificateAction action,
		GObject* cert);
static GWebStatus stub_g_web_get_certificate_context_iter(
		GWeb* self,
		GObject* context,
		GObject** iterator);
static GObject* stub_g_web_get_certificate_iter(GWeb* self, GObject** iterator);
static void stub_g_web_certificate_free(GWeb* self, GObject* cert);
static void stub_g_web_certificate_iter_free(GWeb* self, GObject* iterator);
static void stub_g_web_notify_plugins(GWeb* self, gint event);
static GWebStatus stub_g_web_clear_passwords(GWeb* self);
static GWebStatus stub_g_web_clear_authenticated_sessions(GWeb* self);
static void stub_g_web_clear_personal_data(GWeb* self);
static GWebStatus stub_g_web_clear_all_history(GWeb* self);
static GWebStatus stub_g_web_set_remember_password(GWeb* self, gboolean rpassword);
static gboolean stub_g_web_get_remember_password(GWeb* self);
static GWebStatus stub_g_web_set_remember_password_for_forms(GWeb* self, gboolean rpassword);
static gboolean stub_g_web_get_remember_password_for_forms(GWeb* self);
static gboolean stub_g_web_get_plugin_enabled(GWeb* self, gchar* name);
static GWebStatus stub_g_web_set_plugin_enabled(GWeb* self, gchar* name, gboolean enable);
static GWebStatus stub_g_web_set_plugin_ignore_filepath(GWeb* self);
static void stub_g_web_notify_service(
		GWeb* self,
		const gchar* service_name,
		gpointer* context,
		const gchar* topic,
		gchar* data);


static GObjectClass* stub_g_web_parent_class = NULL;


GType stub_g_web_get_type(void)
{
	static GType stub_g_web_type = 0;

	if (!stub_g_web_type) {
		static const GTypeInfo stub_g_web_info =
		{
			sizeof (StubGWebClass),
			/* base_init */ NULL,
			/* base_finalize */ NULL,
			/* class_init */ (GClassInitFunc) stub_g_web_class_init,
			/* class_finalize */ NULL,
			/* class_data */ NULL,
			sizeof(StubGWeb),
			/* n_preallocs */ 0,
			/* instance_init */ (GInstanceInitFunc) stub_g_web_init
		};

		static const GInterfaceInfo interface_info =
		{
			(GInterfaceInitFunc)stub_g_web_interface_init,
			/* interface_finalize */ NULL,
			/* interface_data */ NULL
		};

		stub_g_web_type = g_type_register_static(
				G_TYPE_OBJECT,
				"StubGWeb",
				&stub_g_web_info, 0);

		g_type_add_interface_static(
				stub_g_web_type,
				G_TYPE_WEB,
				&interface_info);
	}

	return stub_g_web_type;
}

static void stub_g_web_interface_init(GWebIface* iface)
{
	iface->destroy = (void (*) (GWeb*))
		stub_g_web_destroy;

	iface->new_web_engine_window = (GWebEngine* (*) (GWeb*))
		stub_g_web_new_web_engine_window;

	iface->new_web_engine_window_with_context =
		(GWebEngine* (*) (GWeb*, gpointer, gboolean, gboolean))
		stub_g_web_new_web_engine_window_with_context;

	iface->web_set_pref = (gboolean (*) (GWeb*, const gchar*, GValue*))
		stub_g_web_web_set_pref;

	iface->web_get_pref = (gboolean (*) (GWeb*, const gchar*, GValue*))
		stub_g_web_web_get_pref;

	iface->new_web_transfer_item = (GWebTransferItem* (*) (GWeb*, const gchar*, const gchar*))
		stub_g_web_new_web_transfer_item;

	iface->initialize_web_transfer_item = (GWebTransferItem* (*) (GWeb*, GObject*))
		stub_g_web_initialize_web_transfer_item;

	iface->get_web_transfer_item_list = (GWebTransferItemList* (*) (GWeb*))
		stub_g_web_get_web_transfer_item_list;

	iface->set_home_page = (GWebStatus (*) (GWeb*, const gchar*))
		stub_g_web_set_home_page;

	iface->get_home_page = (gchar* (*) (GWeb*))
		stub_g_web_get_home_page;

	iface->set_language = (GWebStatus (*) (GWeb*, const gchar*))
		stub_g_web_set_language;

	iface->reset_cache_history_length = (void (*) (GWeb*))
		stub_g_web_reset_cache_history_length;

	iface->get_language = (gchar* (*) (GWeb*))
		stub_g_web_get_language;

	iface->get_maximum_cache_size = (gint (*) (GWeb*))
		stub_g_web_get_maximum_cache_size;

	iface->set_default_home_page = (GWebStatus (*) (GWeb*, const gchar*))
		stub_g_web_set_default_home_page;

	iface->get_default_home_page = (gchar* (*) (GWeb*))
		stub_g_web_get_default_home_page;

	iface->home_page_set = (gboolean (*) (GWeb*))
		stub_g_web_home_page_set;

	iface->set_frame_borders_enabled = (void (*) (GWeb*, gboolean))
		stub_g_web_set_frame_borders_enabled;

	iface->get_frame_borders_enabled = (gboolean (*) (GWeb*))
		stub_g_web_get_frame_borders_enabled;

	iface->set_location_completion_suffixes = (GWebStatus (*) (GWeb*, const gchar*))
		stub_g_web_set_location_completion_suffixes;

	iface->get_location_completion_suffixes = (gchar* (*) (GWeb*))
		stub_g_web_get_location_completion_suffixes;

	iface->set_plugins_enabled = (GWebStatus (*) (GWeb*, gboolean))
		stub_g_web_set_plugins_enabled;

	iface->set_oom_cb = (GWebStatus (*) (GWeb*, GFunc))
		stub_g_web_set_oom_cb;

	iface->set_ssl2_support = (GWebStatus (*) (GWeb*, gboolean))
		stub_g_web_set_ssl2_support;

	iface->get_ssl2_support = (gboolean (*) (GWeb*))
		stub_g_web_get_ssl2_support;

	iface->get_plugins_enabled = (gboolean (*) (GWeb*))
		stub_g_web_get_plugins_enabled;

	iface->set_js_enabled = (GWebStatus (*) (GWeb*, gboolean))
		stub_g_web_set_js_enabled;

	iface->get_js_enabled = (gboolean (*) (GWeb*))
		stub_g_web_get_js_enabled;

	iface->set_memory_cache = (void (*) (GWeb*, GMemoryCache))
		stub_g_web_set_memory_cache;

	iface->get_memory_cache = (GMemoryCache (*) (GWeb*))
		stub_g_web_get_memory_cache;

	iface->set_cache_size = (GWebStatus (*) (GWeb*, gint))
		stub_g_web_set_cache_size;

	iface->get_cache_size = (gint (*) (GWeb*))
		stub_g_web_get_cache_size;

	iface->set_browse_offline = (GWebStatus (*) (GWeb*, gboolean))
		stub_g_web_set_browse_offline;

	iface->get_browse_offline = (gboolean (*) (GWeb*))
		stub_g_web_get_browse_offline;

	iface->set_automatic_redirection_enabled = (GWebStatus (*) (GWeb*, gboolean))
		stub_g_web_set_automatic_redirection_enabled;

	iface->get_automatic_redirection_enabled = (gboolean (*) (GWeb*))
		stub_g_web_get_automatic_redirection_enabled;

	iface->set_load_images = (GWebStatus (*) (GWeb*, GWebEngineImagePolicy))
		stub_g_web_set_load_images;

	iface->get_load_images = (GWebEngineImagePolicy (*) (GWeb*))
		stub_g_web_get_load_images;

	iface->disconnect = (void (*) (GWeb*))
		stub_g_web_disconnect;

	iface->clear_cache = (GWebStatus (*) (GWeb*))
		stub_g_web_clear_cache;

	iface->get_plugins_list = (GWebPluginList* (*) (GWeb*))
		stub_g_web_get_plugins_list;

	iface->get_history_list = (GWebHistoryList* (*) (GWeb*))
		stub_g_web_get_history_list;

	iface->set_new_window_loads = (GWebStatus (*) (GWeb*, gboolean))
		stub_g_web_set_new_window_loads;

	iface->get_new_window_loads = (gboolean (*) (GWeb*))
		stub_g_web_get_new_window_loads;

	iface->set_cookie_acceptance = (void (*) (GWeb*, GCookieAcceptance))
		stub_g_web_set_cookie_acceptance;

	iface->get_cookie_acceptance = (GCookieAcceptance (*) (GWeb*))
		stub_g_web_get_cookie_acceptance;

	iface->set_popup_acceptance = (void (*) (GWeb*, GPopupAcceptance))
		stub_g_web_set_popup_acceptance;

	iface->get_popup_acceptance = (GPopupAcceptance (*) (GWeb*))
		stub_g_web_get_popup_acceptance;

	iface->suspend = (GWebStatus (*) (GWeb*))
		stub_g_web_suspend;

	iface->suspended = (gboolean (*) (GWeb*))
		stub_g_web_suspended;

	iface->resume = (void (*) (GWeb*))
		stub_g_web_resume;

	iface->set_ua_string = (void (*) (GWeb*, gchar*))
		stub_g_web_set_ua_string;

	iface->set_user_agent_id = (GWebStatus (*) (GWeb*, gint))
		stub_g_web_set_user_agent_id;

	iface->get_user_agent_id = (gint (*) (GWeb*))
		stub_g_web_get_user_agent_id;

	iface->enable_url_loading = (void (*) (GWeb*, gboolean))
		stub_g_web_enable_url_loading;

	iface->free_memory = (void (*) (GWeb*, gboolean))
		stub_g_web_free_memory;

	iface->store_transfers = (GWebStatus (*) (GWeb*))
		stub_g_web_store_transfers;

	iface->restore_transfers = (GWebStatus (*) (GWeb*))
		stub_g_web_restore_transfers;

	iface->delete_all_cookies = (GWebStatus (*) (GWeb*))
		stub_g_web_delete_all_cookies;

	iface->confirm_cookie = (GWebStatus (*) (GWeb*, gpointer, gboolean, GWebCookieAction))
		stub_g_web_confirm_cookie;

	iface->get_global = (GObject* (*) (GWeb*))
		stub_g_web_get_global;

	iface->get_certificate_enum_message = (GWebCertificateMessage (*) (GWeb*, GObject*))
		stub_g_web_get_certificate_enum_message;

	iface->username_matchinfo_get_matches = (gint (*) (GWeb*, GObject*))
		stub_g_web_username_matchinfo_get_matches;

	iface->username_matchinfo_delete = (void (*) (GWeb*, GObject*, gint))
		stub_g_web_username_matchinfo_delete;

	iface->username_matchinfo_get_username = (GWebStatus (*) (GWeb*, GObject*, gint, gchar**))
		stub_g_web_username_matchinfo_get_username;

	iface->get_password_manager = (GWebPasswordManager* (*) (GWeb*, const gchar*, gint))
		stub_g_web_get_password_manager;

	iface->store_personal_data = (GWebStatus (*) (GWeb*, const gchar*, const gchar*, const gchar*))
		stub_g_web_store_personal_data;

	iface->delete_personal_data = (GWebStatus (*) (GWeb*, const gchar*, const gchar*))
		stub_g_web_delete_personal_data;

	iface->perform_crtificate_context_action =
		(GWebCertificateReaction (*) (GWeb*, GObject*, GWebCertificateAction, GObject*))
		stub_g_web_perform_crtificate_context_action;

	iface->get_certificate_context_iter = (GWebStatus (*) (GWeb*, GObject*, GObject**))
		stub_g_web_get_certificate_context_iter;

	iface->get_certificate_iter = (GObject* (*) (GWeb*, GObject**))
		stub_g_web_get_certificate_iter;

	iface->certificate_free = (void (*) (GWeb*, GObject*))
		stub_g_web_certificate_free;

	iface->certificate_iter_free = (void (*) (GWeb*, GObject*))
		stub_g_web_certificate_iter_free;

	iface->notify_plugins = (void (*) (GWeb*, gint))
		stub_g_web_notify_plugins;

	iface->clear_passwords = (GWebStatus (*) (GWeb*))
		stub_g_web_clear_passwords;

	iface->clear_authenticated_sessions = (GWebStatus (*) (GWeb*))
		stub_g_web_clear_authenticated_sessions;

	iface->clear_personal_data = (void (*) (GWeb*))
		stub_g_web_clear_personal_data;

	iface->clear_all_history = (GWebStatus (*) (GWeb*))
		stub_g_web_clear_all_history;

	iface->set_remember_password = (GWebStatus (*) (GWeb*, gboolean))
		stub_g_web_set_remember_password;

	iface->get_remember_password = (gboolean (*) (GWeb*))
		stub_g_web_get_remember_password;

	iface->set_remember_password_for_forms = (GWebStatus (*) (GWeb*, gboolean))
		stub_g_web_set_remember_password_for_forms;

	iface->get_remember_password_for_forms = (gboolean (*) (GWeb*))
		stub_g_web_get_remember_password_for_forms;

	iface->get_plugin_enabled = (gboolean (*) (GWeb*, gchar*))
		stub_g_web_get_plugin_enabled;

	iface->set_plugin_enabled = (GWebStatus (*) (GWeb*, gchar*, gboolean))
		stub_g_web_set_plugin_enabled;

	iface->set_plugin_ignore_filepath = (GWebStatus (*) (GWeb*))
		stub_g_web_set_plugin_ignore_filepath;

	iface->notify_service = (void (*) (GWeb*, const gchar*, gpointer*, const gchar*, gchar*))
		stub_g_web_notify_service;
}

static void stub_g_web_class_init(StubGWebClass* klass)
{
	GObjectClass* object;
	stub_g_web_parent_class = g_type_class_peek_parent(klass);
	object = G_OBJECT_CLASS(klass);
	object->finalize = stub_g_web_finalize;
}

static void stub_g_web_init(StubGWeb* self)
{}

static void stub_g_web_finalize(GObject* object)
{
	StubGWeb* self = STUB_G_WEB(object);
	stub_g_web_destroy(G_WEB(self));
}

GObject* stub_g_web_new()
{
	GObject* instance = g_object_new(stub_g_web_get_type(), NULL);
	return G_OBJECT(instance);
}

static void stub_g_web_destroy(GWeb* self)
{}





static GWebEngine* stub_g_web_new_web_engine_window(GWeb* self)
{
	return NULL;
}

static GWebEngine* stub_g_web_new_web_engine_window_with_context(
		GWeb* self,
		gpointer context,
		gboolean leave_tracks,
		gboolean without_history)
{
	return NULL;
}

static gboolean stub_g_web_web_set_pref(GWeb* self, const gchar* name, GValue* value)
{
	return TRUE;
}

static gboolean stub_g_web_web_get_pref(GWeb* self, const gchar* name, GValue* value)
{
	return TRUE;
}

static GWebTransferItem* stub_g_web_new_web_transfer_item(
		GWeb* self,
		const gchar* url,
		const gchar* filename)
{
	return NULL;
}

static GWebTransferItem* stub_g_web_initialize_web_transfer_item(
		GWeb* self,
		GObject* web_transfer_item)
{
	return NULL;
}

static GWebTransferItemList* stub_g_web_get_web_transfer_item_list(GWeb* self)
{
	return NULL;
}

static GWebStatus stub_g_web_set_home_page(GWeb* self, const gchar* home_page)
{
	return G_WEB_STATUS_OK;
}

static gchar* stub_g_web_get_home_page(GWeb* self)
{
	return NULL;
}

static GWebStatus stub_g_web_set_language(GWeb* self, const gchar* language)
{
	return G_WEB_STATUS_OK;
}

static void stub_g_web_reset_cache_history_length(GWeb* self)
{}

static gchar* stub_g_web_get_language(GWeb* self)
{
	return NULL;
}

static gint stub_g_web_get_maximum_cache_size(GWeb* self)
{
	return 0;
}

static GWebStatus stub_g_web_set_default_home_page(GWeb* self, const gchar* default_page)
{
	return G_WEB_STATUS_OK;
}

static gchar* stub_g_web_get_default_home_page(GWeb* self)
{
	return NULL;
}

static gboolean stub_g_web_home_page_set(GWeb* self)
{
	return TRUE;
}

static void stub_g_web_set_frame_borders_enabled(GWeb* self, gboolean enabled)
{}

static gboolean stub_g_web_get_frame_borders_enabled(GWeb* self)
{
	return TRUE;
}

static GWebStatus stub_g_web_set_location_completion_suffixes(GWeb* self, const gchar* suffixes)
{
	return G_WEB_STATUS_OK;
}

static gchar* stub_g_web_get_location_completion_suffixes(GWeb* self)
{
	return NULL;
}

static GWebStatus stub_g_web_set_plugins_enabled(GWeb* self, gboolean enabled)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_set_oom_cb(GWeb* self, GFunc func)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_set_ssl2_support(GWeb* self, gboolean enabled)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_get_ssl2_support(GWeb* self)
{
	return TRUE;
}

static gboolean stub_g_web_get_plugins_enabled(GWeb* self)
{
	return TRUE;
}

static GWebStatus stub_g_web_set_js_enabled(GWeb* self, gboolean enabled)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_get_js_enabled(GWeb* self)
{
	return TRUE;
}

static void stub_g_web_set_memory_cache(GWeb* self, GMemoryCache acceptance)
{}

static GMemoryCache stub_g_web_get_memory_cache(GWeb* self)
{
	return G_MEMORY_CACHE_AUTOMATIC;
}

static GWebStatus stub_g_web_set_cache_size(GWeb* self, gint size)
{
	return G_WEB_STATUS_OK;
}

static gint stub_g_web_get_cache_size(GWeb* self)
{
	return 0;
}

static GWebStatus stub_g_web_set_browse_offline(GWeb* self, gboolean offline)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_get_browse_offline(GWeb* self)
{
	return TRUE;
}

static GWebStatus stub_g_web_set_automatic_redirection_enabled(GWeb* self, gboolean enabled)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_get_automatic_redirection_enabled(GWeb* self)
{
	return TRUE;
}

static GWebStatus stub_g_web_set_load_images(GWeb* self, GWebEngineImagePolicy level)
{
	return G_WEB_STATUS_OK;
}

static GWebEngineImagePolicy stub_g_web_get_load_images(GWeb* self)
{
	return G_WEBENGINE_POLICY_ALL_IMAGES;
}

static void stub_g_web_disconnect(GWeb* self)
{}

static GWebStatus stub_g_web_clear_cache(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static GWebPluginList* stub_g_web_get_plugins_list(GWeb* self)
{
	return NULL;
}

static GWebHistoryList* stub_g_web_get_history_list(GWeb* self)
{
	return NULL;
}

static GWebStatus stub_g_web_set_new_window_loads(GWeb* self, gboolean loads)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_get_new_window_loads(GWeb* self)
{
	return TRUE;
}

static void stub_g_web_set_cookie_acceptance(GWeb* self, GCookieAcceptance acceptance)
{}

static GCookieAcceptance stub_g_web_get_cookie_acceptance(GWeb* self)
{
	return G_ACCEPT_COOKIE_ALWAYS;
}

static void stub_g_web_set_popup_acceptance(GWeb* self, GPopupAcceptance acceptance)
{}

static GPopupAcceptance stub_g_web_get_popup_acceptance(GWeb* self)
{
	return G_ACCEPT_POPUP_ALWAYS;
}

static GWebStatus stub_g_web_suspend(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_suspended(GWeb* self)
{
	return TRUE;
}

static void stub_g_web_resume(GWeb* self)
{}

static void stub_g_web_set_ua_string(GWeb* self, gchar* ua_string)
{}

static GWebStatus stub_g_web_set_user_agent_id(GWeb* self, gint ua_id)
{
	return G_WEB_STATUS_OK;
}

static gint stub_g_web_get_user_agent_id(GWeb* self)
{
	return 0;
}

static void stub_g_web_enable_url_loading(GWeb* self, gboolean enable)
{}

static void stub_g_web_free_memory(GWeb* self, gboolean progressive)
{}

static GWebStatus stub_g_web_store_transfers(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_restore_transfers(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_delete_all_cookies(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_confirm_cookie(
		GWeb* self,
		gpointer context,
		gboolean accept,
		GWebCookieAction action)
{
	return G_WEB_STATUS_OK;
}

static GObject* stub_g_web_get_global(GWeb* self)
{
	return NULL;
}

static GWebCertificateMessage stub_g_web_get_certificate_enum_message(GWeb* self, GObject* context)
{
	return G_WEB_CERT_MESS_VALID;
}

static gint stub_g_web_username_matchinfo_get_matches(GWeb* self, GObject* info)
{
	return 0;
}

static void stub_g_web_username_matchinfo_delete(GWeb* self, GObject* info, gint index)
{}

static GWebStatus stub_g_web_username_matchinfo_get_username(
		GWeb* self,
		GObject* info,
		gint index,
		gchar** username)
{
	return G_WEB_STATUS_OK;
}

static GWebPasswordManager* stub_g_web_get_password_manager(
		GWeb* self,
		const gchar* server,
		gint index)
{
	return NULL;
}

static GWebStatus stub_g_web_store_personal_data(
		GWeb* self,
		const gchar* server,
		const gchar* username,
		const gchar* password)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_delete_personal_data(
		GWeb* self,
		const gchar* server,
		const gchar* username)
{
	return G_WEB_STATUS_OK;
}

static GWebCertificateReaction stub_g_web_perform_crtificate_context_action(
		GWeb* self,
		GObject* context,
		GWebCertificateAction action,
		GObject* cert)
{
	return G_WEB_CERT_REACTION_NOTHING;
}

static GWebStatus stub_g_web_get_certificate_context_iter(
		GWeb* self,
		GObject* context,
		GObject** iterator)
{
	return G_WEB_STATUS_OK;
}

static GObject* stub_g_web_get_certificate_iter(GWeb* self, GObject** iterator)
{
	return NULL;
}

static void stub_g_web_certificate_free(GWeb* self, GObject* cert)
{}

static void stub_g_web_certificate_iter_free(GWeb* self, GObject* iterator)
{}

static void stub_g_web_notify_plugins(GWeb* self, gint event)
{}

static GWebStatus stub_g_web_clear_passwords(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_clear_authenticated_sessions(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static void stub_g_web_clear_personal_data(GWeb* self)
{}

static GWebStatus stub_g_web_clear_all_history(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_set_remember_password(GWeb* self, gboolean rpassword)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_get_remember_password(GWeb* self)
{
	return TRUE;
}

static GWebStatus stub_g_web_set_remember_password_for_forms(GWeb* self, gboolean rpassword)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_get_remember_password_for_forms(GWeb* self)
{
	return TRUE;
}

static gboolean stub_g_web_get_plugin_enabled(GWeb* self, gchar* name)
{
	return TRUE;
}

static GWebStatus stub_g_web_set_plugin_enabled(GWeb* self, gchar* name, gboolean enable)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_set_plugin_ignore_filepath(GWeb* self)
{
	return G_WEB_STATUS_OK;
}

static void stub_g_web_notify_service(
		GWeb* self,
		const gchar* service_name,
		gpointer* context,
		const gchar* topic,
		gchar* data)
{}
