#include <check.h>
#include "testing.h"
#include <glib-object.h>

#include "gwebpassman.h"
#include "stub_gwebpassman.h"

static GWebPasswordManager* self;
static gboolean destroyed_flag;


static void destroy_notify(gpointer user_data, GObject* where_object_was)
{
	destroyed_flag = TRUE;
}

void setup_gwebpassman(void)
{
	g_type_init();
	self = G_WEB_PASSWORD_MANAGER(stub_g_web_password_manager_new());
	fail_if(self == NULL, "failed to create object");
	destroyed_flag = FALSE;
}

void teardown_gwebpassman(void)
{
	g_object_weak_ref(G_OBJECT(self), destroy_notify, NULL);

	g_object_unref(G_OBJECT(self));
	//run_main_loop(DEFAULT_MAIN_LOOP_RUN_TIME);

	//fail_unless(destroyed_flag, "failed to destroy object");

	self = NULL;
	destroyed_flag = FALSE;
}

START_TEST(test_g_web_password_manager_get_login_username)
{
	GWebStatus ret;
	gchar* username;

	ret = g_web_password_manager_get_login_username(self, &username);
}
END_TEST

START_TEST(test_g_web_password_manager_get_login_password)
{
	GWebStatus ret;
	gchar* password;

	ret = g_web_password_manager_get_login_password(self, &password);
}
END_TEST

START_TEST(test_g_web_password_manager_login_get_personal_data)
{
	GObject* ret;

	ret = g_web_password_manager_login_get_personal_data(self);
}
END_TEST


Suite* create_gwebpassman_suite(void)
{
	Suite* s = suite_create("gwebpassman");

	TCase* tc = tcase_create("tests");
	tcase_add_checked_fixture(tc, setup_gwebpassman, teardown_gwebpassman);
	tcase_add_test(tc, test_g_web_password_manager_get_login_username);
	tcase_add_test(tc, test_g_web_password_manager_get_login_password);
	tcase_add_test(tc, test_g_web_password_manager_login_get_personal_data);
	suite_add_tcase(s, tc);

	return s;
}
