/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <glib-object.h>
#include "gwebcommon.h"

#ifndef __GWEBPASSMAN_H__
#define __GWEBPASSMAN_H__

G_BEGIN_DECLS

#define G_TYPE_WEB_PASSWORD_MANAGER             (g_web_password_manager_get_type())
#define G_WEB_PASSWORD_MANAGER(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_WEB_PASSWORD_MANAGER, GWebPasswordManager))
#define G_WEB_PASSWORD_MANAGER_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST((vtable), G_TYPE_WEB_PASSWORD_MANAGER, GWebPasswordManagerIface))
#define G_IS_WEB_PASSWORD_MANAGER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_WEB_PASSWORD_MANAGER))
#define G_IS_WEB_PASSWORD_MANAGER_CLASS(vtable)    (G_TYPE_CHECK_CLASS_TYPE((vatable), G_TYPE_WEB_PASSWORD_MANAGER))
#define G_WEB_PASSWORD_MANAGER_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE((inst), G_TYPE_WEB_PASSWORD_MANAGER, GWebPasswordManagerIface))

typedef struct _GWebPasswordManager      GWebPasswordManager;
typedef struct _GWebPasswordManagerIface  GWebPasswordManagerIface;

struct _GWebPasswordManagerIface
{
	GTypeInterface parent;
	
	GWebStatus (*get_login_username) (GWebPasswordManager *self, gchar** username);
	GWebStatus (*get_login_password) (GWebPasswordManager *self, gchar** password);
	GObject* (*login_get_personal_data) (GWebPasswordManager *self);
};

GType      g_web_password_manager_get_type         (void);

/**
  * Get the username from a GWebPasswordManager.
  * attention The string must be freed using g_free().
  *
  * @param self Object Pointer.
  * @param username Return argument for the username.
  *
  * @return @c G_WEB_STATUS_OK on success.
  */
GWebStatus g_web_password_manager_get_login_username(GWebPasswordManager *self, gchar** username);

/**
  * Get the password from a GWebPasswordManager..
  * attention The string must be freed using g_free().
  *
  * @param self Object Pointer.
  * @param password Return argument for the password.
  *
  * @return @c G_WEB_STATUS_OK on success.
  */
GWebStatus g_web_password_manager_get_login_password(GWebPasswordManager *self, gchar** password);

/**
  * Get the personal data that is stored for a server.
  *
  * @param self Object Pointer.
  * @return Returns the personal data.
  */
GObject* g_web_password_manager_login_get_personal_data(GWebPasswordManager *self);

G_END_DECLS

#endif //__GWEBPASSMAN_H__
