/**
 * @file ui_itemlist.h item list/view handling
 *
 * Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 *	      
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _UI_ITEMLIST_H
#define _UI_ITEMLIST_H

#include <gtk/gtk.h>
#include <time.h>
#include "feed_types.h"
#include "appdata.h"
#include "common.h"

/** Enumeration of the columns in the itemstore. */
/* TODO: used in sorting order in export.c. _Could_ be removed
 */
enum is_columns {
    /* This is set to the first item so that default sorting is by time */
    IS_TIME = 0,        /**< Time of item creation */
    IS_TITLE,           /**< Name of the item */
    IS_TIME_STR,        /**< Time of item creation as a string*/
    IS_LABEL,           /**< Displayed name */
    IS_ICON,            /**< Pixbuf reference to the item's icon */
    IS_PTR,         /**< Pointer to item sturuct */
    IS_TYPE,            /**< Type of feed that the item came from */
    IS_ICON2,           /**< Pixbuf reference to the item's feed's icon */
    IS_LEN          /**< Number of columns in the itemstore */
};

extern nodePtr displayed_node;


/**
 * Method to reset the format string of the date column.
 * Should be called upon initializaton and each time the
 * date format changes.
 */
void ui_itemlist_reset_date_format(void);

/* methods needs to but should not be exposed... */
gchar *ui_itemlist_format_date(time_t t);

/**
 * Adds content to the htmlview after a new feed has been selected and
 * sets an item as read.
 *
 * @param node The feedlist node being processed.
 */
void ui_itemlist_display(nodePtr node);

/**
 * Display a feed's items
 *
 * @param fp The feed to display.
 */
void ui_itemlist_load(nodePtr fp);

/**
 * Append a news item to the search feed vfolder and process pending GUI.
 *
 * @param ip The news item to add to search results.
 */
void ui_itemlist_search_append(itemPtr ip);

/**
 * Initialize search vfolder.
 *
 */
void ui_itemlist_search_init();

/**
 * Remove the items from the itemlist.
 */
void ui_itemlist_clear(void);

#endif
