/**
    @file ui_feed_directory.h

    Feed directory functionality and dialogs.

    Copyright (c) 2004-2006 Nokia Corporation. All rights reserved.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifndef _UI_FEED_DIRECTORY_H
#define _UI_FEED_DIRECTORY_H

#include "folder.h"

#define FEED_DIRECTORY_SOURCE "/apps/osso/rss-feed-reader/feed-directory-source"

#define FEED_DIRECTORY_MAX_DEPTH 10

/** On menu clicked callback.
  * Will use the latest gconf value for FEED_DIRECTORY_SOURCE
  * If that value is NULL, set it to FEED_DIRECTORY_SOURCE_VALUE
*/
void on_menuitem_feed_directory_clicked(GtkWidget * menuitem,
                                        gpointer user_data);


/** Creates the feed directory dialog 
  * 
  * @param widget not used
  * @param user_data not used
  */
void ui_feed_directory_button_clicked(GtkWidget * widget,
                                      gpointer user_data,
                                      gchar * fdsource, folderPtr folder);

/** Creates the UI feed.
   *@param request is passed from ui_feed_directory_process(),
    ultimately from ui_feed_directory_get()
    Needed to get the parent folder in which the feed dir will reside
*/
GtkWidget *ui_feed_directory_create_dialog(folderPtr folder);

/** Downloads the contents of the feed directory. The callback function
  * ui_feed_directory_process (defined above) is called after downloading.
  */
void ui_feed_directory_get();

/** Checks if the type of the given outline is rss
  *
  * @param cur the current node
  * @return TRUE if the given outline is of type rss, otherwise FALSE
  */
gboolean ui_feed_directory_outline_type_is_rss(xmlNodePtr cur);

void ui_feed_directory_process(struct request *request);

void ui_feed_directory_from_add_feed_dialog(xmlDocPtr doc, xmlNodePtr cur,
                                            folderPtr ptr, gchar * fd_source);

typedef struct fd_node_ptr {
    gchar *title;               /* The title of the feed or category */
    gchar *url;                 /* An empty url denotes a category   */

    gboolean selected;          /* If the feed has been selected     */

    GtkWidget *checkbutton;     /* Checkbutton for this feed         */
} *fdNodePtr;

#endif
