/**
 * @file feed_cache.h cash related feed handling
 * 
 * Copyright (C) 2003 Lars Lindner <lars.lindner@gmx.net>
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _FEED_CACHE_H
#define _FEED_CACHE_H

#include <glib.h>
#include <stdio.h>
#include "feed_types.h"

extern gboolean conf_keep_feeds_in_memory;

/**
 * Loads a feed from a cache file.
 *
 * @param type the type of feed being loaded. This effects the
 * extension of the cache file.
 *
 * @param id the name of the cache file used. Some types of feed have
 * an extension, such as ocs, that is appended to the id, to generate
 * the cache filename.
 *
 * @returns FALSE if the feed file could not be opened and TRUE if it
 * was opened or was already loaded.
 */
gboolean feed_load(feedPtr fp);

/** Only some feed informations are kept in memory to lower memory
  * usage. This method unloads everything besides necessary infos.
  *
  * @param fp a pointer to a feed structure
  */
gboolean feed_unload(feedPtr fp);




#endif /*_FEED_CACHE_H*/
